/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wiki.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static Settings m_instance;
    private final XComponentContext m_xContext;
    private int lastUsedWikiServer = 0;
    private final List<Map<String, String>> m_WikiConnections = new ArrayList<Map<String, String>>();
    private final List<Map<String, Object>> m_aWikiDocs = new ArrayList<Map<String, Object>>();

    private Settings(XComponentContext ctx) {
        this.m_xContext = ctx;
        this.loadConfiguration();
    }

    public static synchronized Settings getSettings(XComponentContext ctx) {
        if (m_instance == null) {
            m_instance = new Settings(ctx);
        }
        return m_instance;
    }

    public void addWikiCon(Map<String, String> wikiCon) {
        this.m_WikiConnections.add(wikiCon);
    }

    public List<Map<String, String>> getWikiCons() {
        return this.m_WikiConnections;
    }

    private String getWikiConUrlByNumber(int num) {
        String url = "";
        if (num >= 0 && num < this.m_WikiConnections.size()) {
            Map<String, String> ht = this.m_WikiConnections.get(num);
            url = ht.get("Url");
        }
        return url;
    }

    public void addWikiDoc(Map<String, Object> aWikiDoc) {
        String sURL = (String)aWikiDoc.get("CompleteUrl");
        Map<String, Object> aEntry = this.getDocByCompleteUrl(sURL);
        if (aEntry != null) {
            this.m_aWikiDocs.remove(aEntry);
        } else if (this.m_aWikiDocs.size() > 10) {
            this.m_aWikiDocs.remove(0);
        }
        this.m_aWikiDocs.add(aWikiDoc);
    }

    public List<Map<String, Object>> getWikiDocs() {
        return this.m_aWikiDocs;
    }

    public Object[] getWikiDocList(int serverid) {
        String wikiserverurl = this.getWikiConUrlByNumber(serverid);
        ArrayList<String> theDocs = new ArrayList<String>();
        String[] docs = new String[]{};
        for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
            Map<String, Object> ht = this.m_aWikiDocs.get(i);
            String docurl = (String)ht.get("Url");
            if (!docurl.equals(wikiserverurl)) continue;
            theDocs.add((String)ht.get("Doc"));
        }
        return theDocs.toArray(docs);
    }

    public int getLastUsedWikiServer() {
        return this.lastUsedWikiServer;
    }

    public void setLastUsedWikiServer(int l) {
        this.lastUsedWikiServer = l;
    }

    public String[] getWikiURLs() {
        String[] WikiList = new String[this.m_WikiConnections.size()];
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Map<String, String> ht = this.m_WikiConnections.get(i);
            WikiList[i] = ht.get("Url");
        }
        return WikiList;
    }

    public Map<String, String> getSettingByUrl(String sUrl) {
        Map<String, String> ht = null;
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Map<String, String> h1 = this.m_WikiConnections.get(i);
            String u1 = h1.get("Url");
            if (!u1.equals(sUrl)) continue;
            ht = h1;
            try {
                String[] pPasswords;
                String sUserName = ht.get("Username");
                String aPassword = ht.get("Password");
                if (sUserName == null || sUserName.length() <= 0 || aPassword != null && aPassword.length() != 0 || (pPasswords = Helper.GetPasswordsForURLAndUser(this.m_xContext, sUrl, sUserName)) == null || pPasswords.length <= 0) break;
                ht.put("Password", pPasswords[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        return ht;
    }

    private Map<String, Object> getDocByCompleteUrl(String curl) {
        Map<String, Object> ht = null;
        for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
            Map<String, Object> h1 = this.m_aWikiDocs.get(i);
            String u1 = (String)h1.get("CompleteUrl");
            if (!u1.equals(curl)) continue;
            ht = h1;
        }
        return ht;
    }

    public void removeSettingByUrl(String sUrl) {
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Map<String, String> h1 = this.m_WikiConnections.get(i);
            String u1 = h1.get("Url");
            if (!u1.equals(sUrl)) continue;
            this.m_WikiConnections.remove(i);
        }
    }

    public void storeConfiguration() {
        try {
            String[] pNames;
            XNameContainer xContainer = Helper.GetConfigNameContainer(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension/ConnectionList");
            for (String pName : pNames = xContainer.getElementNames()) {
                xContainer.removeByName(pName);
            }
            XSingleServiceFactory xConnectionFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xContainer);
            for (Map<String, String> ht : this.m_WikiConnections) {
                Object oNewConnection = xConnectionFactory.createInstance();
                XNameReplace xNewConn = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)oNewConnection);
                if (xNewConn != null) {
                    xNewConn.replaceByName("UserName", (Object)ht.get("Username"));
                }
                xContainer.insertByName(ht.get("Url"), (Object)xNewConn);
            }
            XChangesBatch xBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xContainer);
            xBatch.commitChanges();
            xContainer = Helper.GetConfigNameContainer(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension/RecentDocs");
            for (String pName : pNames = xContainer.getElementNames()) {
                xContainer.removeByName(pName);
            }
            XSingleServiceFactory xDocListFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xContainer);
            int i = 0;
            for (Map<String, Object> ht : this.m_aWikiDocs) {
                Object oNewDoc = xDocListFactory.createInstance();
                XNameReplace xNewDoc = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)oNewDoc);
                for (Map.Entry<String, Object> entry : ht.entrySet()) {
                    xNewDoc.replaceByName(entry.getKey(), entry.getValue());
                }
                xContainer.insertByName("d" + i++, (Object)xNewDoc);
            }
            XChangesBatch xBatch2 = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xContainer);
            xBatch2.commitChanges();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadConfiguration() {
        block7: {
            this.m_WikiConnections.clear();
            try {
                String[] allDocs;
                String[] allCons;
                XNameAccess xAccess = Helper.GetConfigNameAccess(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension");
                if (xAccess == null) break block7;
                Object oList = xAccess.getByName("ConnectionList");
                XNameAccess xConnectionList = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oList);
                for (String aConnection : allCons = xConnectionList.getElementNames()) {
                    HashMap<String, String> ht = new HashMap<String, String>();
                    ht.put("Url", aConnection);
                    ht.put("Username", "");
                    ht.put("Password", "");
                    try {
                        String aUsername;
                        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xConnectionList.getByName(aConnection));
                        if (xProps != null && (aUsername = AnyConverter.toString((Object)xProps.getPropertyValue("UserName"))) != null && aUsername.length() > 0) {
                            ht.put("Username", aUsername);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.addWikiCon(ht);
                }
                Object oDocs = xAccess.getByName("RecentDocs");
                XNameAccess xRecentDocs = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oDocs);
                for (String aDocument : allDocs = xRecentDocs.getElementNames()) {
                    Object oDoc = xRecentDocs.getByName(aDocument);
                    XNameAccess xDoc = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oDoc);
                    HashMap<String, Object> ht = new HashMap<String, Object>();
                    ht.put("Url", xDoc.getByName("Url"));
                    ht.put("CompleteUrl", xDoc.getByName("CompleteUrl"));
                    ht.put("Doc", xDoc.getByName("Doc"));
                    this.addWikiDoc(ht);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

