/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jfree.report.JFreeReportBoot;
import org.libreoffice.report.OutputRepository;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ManifestWriter {
    public static final String MANIFEST_NS = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
    public static final String TAG_DEF_PREFIX = "org.libreoffice.report.pentaho.output.";
    private final Map<String, String> entries = new HashMap<String, String>();

    public void addEntry(String fullPath, String mimeType) {
        if (fullPath == null) {
            throw new NullPointerException();
        }
        if (mimeType == null) {
            throw new NullPointerException();
        }
        if ("META-INF/manifest.xml".equals(fullPath)) {
            return;
        }
        this.entries.put(fullPath, mimeType);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void write(OutputRepository outputRepository) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.configure(JFreeReportBoot.getInstance().getGlobalConfig(), TAG_DEF_PREFIX);
        OutputStream manifestOutputStream = outputRepository.createOutputStream("META-INF/manifest.xml", "text/xml");
        OutputStreamWriter writer = new OutputStreamWriter(manifestOutputStream, "UTF-8");
        XmlWriter xmlWriter = new XmlWriter((Writer)writer, (TagDescription)tagDescription);
        xmlWriter.setAlwaysAddNamespace(true);
        xmlWriter.writeXmlDeclaration("UTF-8");
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("manifest", MANIFEST_NS);
        xmlWriter.writeTag(MANIFEST_NS, "manifest", rootAttributes, false);
        for (Map.Entry<String, String> entry : this.entries.entrySet()) {
            AttributeList entryAttrs = new AttributeList();
            entryAttrs.setAttribute(MANIFEST_NS, "media-type", entry.getValue());
            entryAttrs.setAttribute(MANIFEST_NS, "full-path", entry.getKey());
            xmlWriter.writeTag(MANIFEST_NS, "file-entry", entryAttrs, true);
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
    }
}

