/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.util;

import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.JobDefinitionException;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ParameterMap;
import org.libreoffice.report.ReportEngineMetaData;
import org.libreoffice.report.ReportJobDefinition;
import org.libreoffice.report.util.DefaultJobProperties;
import org.libreoffice.report.util.DefaultParameterMap;

public class DefaultReportJobDefinition
implements ReportJobDefinition {
    private final DefaultParameterMap parameters = new DefaultParameterMap();
    private final DefaultJobProperties properties;

    public DefaultReportJobDefinition(ReportEngineMetaData metaData) {
        this.properties = new DefaultJobProperties(metaData);
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) throws JobDefinitionException {
        this.properties.setProperty("input.datasource-factory", dataSourceFactory);
    }

    public DataSourceFactory getDataSourceFactory() {
        return (DataSourceFactory)this.properties.getProperty("input.datasource-factory");
    }

    public InputRepository getInputRepository() {
        return (InputRepository)this.properties.getProperty("input.repository");
    }

    public void setInputRepository(InputRepository inputRepository) throws JobDefinitionException {
        this.properties.setProperty("input.repository", inputRepository);
    }

    public OutputRepository getOutputRepository() {
        return (OutputRepository)this.properties.getProperty("output.repository");
    }

    public void setOutputRepository(OutputRepository outputRepository) throws JobDefinitionException {
        this.properties.setProperty("output.repository", outputRepository);
    }

    public ParameterMap getQueryParameters() {
        return this.parameters;
    }

    public void setReportDefinitionName(String reportDefinitionName) throws JobDefinitionException {
        this.properties.setProperty("input.name", reportDefinitionName);
    }

    public String getReportDefinitionName() {
        return (String)this.properties.getProperty("input.name");
    }

    public JobProperties getProcessingParameters() {
        return this.properties;
    }
}

