/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.ObjectOleElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.draw.ObjectOleReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.MasterDetailReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ReportElementReadHandler;
import org.libreoffice.report.pentaho.parser.text.NoCDATATextContentReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubDocumentReadHandler
extends NoCDATATextContentReadHandler {
    private final ObjectOleElement element;
    private boolean ignore = false;

    public SubDocumentReadHandler(ObjectOleElement element) {
        this.element = element;
    }

    private SubDocumentReadHandler(Section section, ObjectOleElement element) {
        super(section);
        this.element = element;
    }

    public SubDocumentReadHandler(Section section) {
        this(section, new ObjectOleElement());
        this.ignore = true;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        if (!this.ignore) {
            super.startParsing(attrs);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        ElementReadHandler readHandler;
        if ("http://openoffice.org/2005/report".equals(uri)) {
            if ("report-control".equals(tagName)) {
                return new IgnoreAnyChildReadHandler();
            }
            if ("report-element".equals(tagName)) {
                return new ReportElementReadHandler(this.element);
            }
            if ("master-detail-fields".equals(tagName)) {
                return new MasterDetailReadHandler(this.element);
            }
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(uri) && (readHandler = "object-ole".equals(tagName) ? new ObjectOleReadHandler(this.element) : ("frame".equals(tagName) ? new SubDocumentReadHandler(new Section(), this.element) : null)) != null) {
            this.getChildren().add((Object)readHandler);
            return readHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }
}

