/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sdb.XCompletedExecution;
import com.sun.star.sdb.XParametersSupplier;
import com.sun.star.sdb.XQueriesSupplier;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdb.tools.XConnectionTools;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XParameters;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libreoffice.report.DataSource;
import org.libreoffice.report.DataSourceException;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.SDBCReportData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDBCReportDataFactory
implements DataSourceFactory {
    private static final String ESCAPEPROCESSING = "EscapeProcessing";
    private static final Log LOGGER = LogFactory.getLog(SDBCReportDataFactory.class);
    public static final String COMMAND_TYPE = "command-type";
    public static final String ESCAPE_PROCESSING = "escape-processing";
    public static final String SORT_EXPRESSIONS = "sort-expressions";
    public static final String GROUP_EXPRESSIONS = "group-expressions";
    public static final String MASTER_VALUES = "master-values";
    public static final String MASTER_COLUMNS = "master-columns";
    public static final String DETAIL_COLUMNS = "detail-columns";
    public static final String UNO_FILTER = "Filter";
    private static final String APPLY_FILTER = "ApplyFilter";
    private static final String UNO_COMMAND = "Command";
    private static final String UNO_COMMAND_TYPE = "CommandType";
    private final XConnection connection;
    private final XComponentContext m_cmpCtx;
    private final Map<RowSetProperties, XRowSet> rowSetProperties = new HashMap<RowSetProperties, XRowSet>();
    private final Map<RowSetProperties, ParameterDefinition> parameterMap = new HashMap<RowSetProperties, ParameterDefinition>();
    private boolean rowSetCreated = false;

    public SDBCReportDataFactory(XComponentContext cmpCtx, XConnection connection) {
        this.connection = connection;
        this.m_cmpCtx = cmpCtx;
    }

    @Override
    public DataSource queryData(String command, Map<String, Object> parameters) throws DataSourceException {
        try {
            if (command == null) {
                return new SDBCReportData(null);
            }
            int commandType = 2;
            String commandTypeValue = (String)parameters.get(COMMAND_TYPE);
            if (commandTypeValue != null) {
                commandType = "query".equals(commandTypeValue) ? 1 : ("table".equals(commandTypeValue) ? 0 : 2);
            }
            Boolean escapeProcessing = (Boolean)parameters.get(ESCAPE_PROCESSING);
            String filter = (String)parameters.get(UNO_FILTER);
            Integer maxRows = (Integer)parameters.get("MaxRows");
            RowSetProperties rowSetProps = new RowSetProperties(escapeProcessing, commandType, command, filter, maxRows);
            Object[] p = this.createRowSet(rowSetProps, parameters);
            XRowSet rowSet = (XRowSet)p[0];
            if (command.length() != 0) {
                ParameterDefinition paramDef = (ParameterDefinition)p[1];
                this.fillParameter(parameters, rowSet, paramDef);
                this.rowSetCreated = this.rowSetCreated && (maxRows == null || maxRows == 0);
                XCompletedExecution execute = (XCompletedExecution)UnoRuntime.queryInterface(XCompletedExecution.class, (Object)rowSet);
                if (this.rowSetCreated && execute != null && paramDef.parameterCount > 0) {
                    XInteractionHandler handler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.m_cmpCtx.getServiceManager().createInstanceWithContext("com.sun.star.sdb.InteractionHandler", this.m_cmpCtx));
                    execute.executeWithCompletion(handler);
                } else {
                    rowSet.execute();
                }
            }
            this.rowSetCreated = false;
            return new SDBCReportData(rowSet);
        }
        catch (Exception ex) {
            this.rowSetCreated = false;
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    private String getOrderStatement(List sortExpressions) {
        String quote;
        StringBuffer order = new StringBuffer();
        int count = sortExpressions.size();
        try {
            quote = this.connection.getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException ex) {
            LOGGER.error("ReportProcessing failed / getOrderStatement could not get quote character", ex);
            quote = "";
        }
        for (int i = 0; i < count; ++i) {
            String sorting;
            Object[] pair = (Object[])sortExpressions.get(i);
            String expression = (String)pair[0];
            if (!expression.startsWith(quote)) {
                expression = quote + expression + quote;
            }
            if ((expression = expression.trim()).length() <= 0) continue;
            order.append(expression);
            if (order.length() > 0) {
                order.append(' ');
            }
            if ((sorting = (String)pair[1]) == null || sorting.equals("false")) {
                order.append("DESC");
            }
            if (i + 1 >= count) continue;
            order.append(", ");
        }
        return order.toString();
    }

    private XSingleSelectQueryComposer getComposer(XConnectionTools tools, String command, int commandType) {
        Class[] parameter = new Class[]{Integer.TYPE, String.class};
        try {
            Object[] param = new Object[]{commandType, command};
            Method call = tools.getClass().getMethod("getComposer", parameter);
            return (XSingleSelectQueryComposer)call.invoke((Object)tools, param);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private void fillParameter(Map parameters, XRowSet rowSet, ParameterDefinition paramDef) throws SQLException, IllegalArgumentException {
        ArrayList masterValues = (ArrayList)parameters.get(MASTER_VALUES);
        if (masterValues != null && !masterValues.isEmpty()) {
            XParameters para = (XParameters)UnoRuntime.queryInterface(XParameters.class, (Object)rowSet);
            for (int i = 0; i < masterValues.size(); ++i) {
                Object object = masterValues.get(i);
                if (object instanceof BigDecimal) {
                    object = ((BigDecimal)object).toString();
                }
                Integer pos = (Integer)paramDef.parameterIndex.get(i);
                para.setObject(pos + 1, object);
            }
        }
    }

    private final Object[] createRowSet(RowSetProperties rowSetProps, Map<String, Object> parameters) throws Exception {
        ArrayList detailColumns = (ArrayList)parameters.get(DETAIL_COLUMNS);
        if (this.rowSetProperties.containsKey(rowSetProps) && detailColumns != null && !detailColumns.isEmpty()) {
            return new Object[]{this.rowSetProperties.get(rowSetProps), this.parameterMap.get(rowSetProps)};
        }
        this.rowSetCreated = true;
        XRowSet rowSet = (XRowSet)UnoRuntime.queryInterface(XRowSet.class, (Object)this.m_cmpCtx.getServiceManager().createInstanceWithContext("com.sun.star.sdb.RowSet", this.m_cmpCtx));
        XPropertySet rowSetProp = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)rowSet);
        rowSetProp.setPropertyValue("ActiveConnection", (Object)this.connection);
        rowSetProp.setPropertyValue(ESCAPEPROCESSING, (Object)rowSetProps.escapeProcessing);
        rowSetProp.setPropertyValue(UNO_COMMAND_TYPE, (Object)rowSetProps.commandType);
        rowSetProp.setPropertyValue(UNO_COMMAND, (Object)rowSetProps.command);
        if (rowSetProps.filter != null) {
            rowSetProp.setPropertyValue(UNO_FILTER, (Object)rowSetProps.filter);
            rowSetProp.setPropertyValue(APPLY_FILTER, (Object)(rowSetProps.filter.length() != 0 ? 1 : 0));
        } else {
            rowSetProp.setPropertyValue(APPLY_FILTER, (Object)Boolean.FALSE);
        }
        if (rowSetProps.maxRows != null) {
            rowSetProp.setPropertyValue("MaxRows", (Object)rowSetProps.maxRows);
        }
        XConnectionTools tools = (XConnectionTools)UnoRuntime.queryInterface(XConnectionTools.class, (Object)this.connection);
        this.fillOrderStatement(rowSetProps.command, rowSetProps.commandType, parameters, tools, rowSetProp);
        ParameterDefinition paramDef = this.createParameter(parameters, tools, rowSetProps, rowSet);
        this.rowSetProperties.put(rowSetProps, rowSet);
        this.parameterMap.put(rowSetProps, paramDef);
        return new Object[]{rowSet, paramDef};
    }

    private ParameterDefinition createParameter(Map parameters, XConnectionTools tools, RowSetProperties rowSetProps, XRowSet rowSet) throws SQLException, UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        ParameterDefinition paramDef = new ParameterDefinition();
        XSingleSelectQueryComposer composer = this.getComposer(tools, rowSetProps.command, rowSetProps.commandType);
        if (composer != null) {
            ArrayList masterValues;
            XIndexAccess params;
            XPropertySet rowSetProp = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)rowSet);
            if (((Boolean)rowSetProp.getPropertyValue(APPLY_FILTER)).booleanValue()) {
                composer.setFilter((String)rowSetProp.getPropertyValue(UNO_FILTER));
            }
            ArrayList detailColumns = (ArrayList)parameters.get(DETAIL_COLUMNS);
            ArrayList<String> handledColumns = new ArrayList<String>();
            XParametersSupplier paraSup = (XParametersSupplier)UnoRuntime.queryInterface(XParametersSupplier.class, (Object)composer);
            if (paraSup != null && (params = paraSup.getParameters()) != null) {
                int oldParameterCount = params.getCount();
                paramDef.parameterCount = oldParameterCount;
                if (detailColumns != null) {
                    block2: for (int i = 0; i < oldParameterCount; ++i) {
                        try {
                            XPropertySet parameter = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)params.getByIndex(i));
                            if (parameter == null) continue;
                            String name = (String)parameter.getPropertyValue("Name");
                            for (int j = 0; j < detailColumns.size(); ++j) {
                                if (!name.equals(detailColumns.get(j))) continue;
                                handledColumns.add(name);
                                paramDef.parameterIndex.add(i);
                                --paramDef.parameterCount;
                                continue block2;
                            }
                            continue;
                        }
                        catch (IndexOutOfBoundsException ex) {
                            Logger.getLogger(SDBCReportDataFactory.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
            if ((masterValues = (ArrayList)parameters.get(MASTER_VALUES)) != null && !masterValues.isEmpty() && paramDef.parameterIndex.size() != detailColumns.size()) {
                String quote = this.connection.getMetaData().getIdentifierQuoteString();
                StringBuffer oldFilter = new StringBuffer();
                oldFilter.append(composer.getFilter());
                if (oldFilter.length() != 0) {
                    oldFilter.append(" AND ");
                }
                int newParamterCounter = 1;
                Iterator it = detailColumns.iterator();
                while (it.hasNext()) {
                    String detail = (String)it.next();
                    if (!handledColumns.contains(detail)) {
                        oldFilter.append(quote);
                        oldFilter.append(detail);
                        oldFilter.append(quote);
                        oldFilter.append(" = :link_");
                        oldFilter.append(newParamterCounter);
                        if (it.hasNext()) {
                            oldFilter.append(" AND ");
                        }
                        paramDef.parameterIndex.add(newParamterCounter + paramDef.parameterCount - 1);
                    }
                    ++newParamterCounter;
                }
                composer.setFilter(oldFilter.toString());
                String sQuery = composer.getQuery();
                rowSetProp.setPropertyValue(UNO_COMMAND, (Object)sQuery);
                rowSetProp.setPropertyValue(UNO_COMMAND_TYPE, (Object)2);
            }
        }
        return paramDef;
    }

    private void fillOrderStatement(String command, int commandType, Map parameters, XConnectionTools tools, XPropertySet rowSetProp) throws SQLException, UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, NoSuchElementException {
        StringBuffer order = new StringBuffer(this.getOrderStatement((ArrayList)parameters.get(SORT_EXPRESSIONS)));
        if (order.length() > 0 && commandType != 0) {
            String statement = command;
            XSingleSelectQueryComposer composer = this.getComposer(tools, command, commandType);
            if (composer != null) {
                statement = composer.getQuery();
                composer.setQuery(statement);
                String sOldOrder = composer.getOrder();
                if (sOldOrder.length() > 0) {
                    order.append(',');
                    order.append(sOldOrder);
                    composer.setOrder("");
                    statement = composer.getQuery();
                }
            } else if (commandType == 1) {
                XQueriesSupplier xSupplyQueries = (XQueriesSupplier)UnoRuntime.queryInterface(XQueriesSupplier.class, (Object)this.connection);
                XNameAccess queries = xSupplyQueries.getQueries();
                if (queries.hasByName(command)) {
                    XPropertySet prop = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)queries.getByName(command));
                    Boolean escape = (Boolean)prop.getPropertyValue(ESCAPEPROCESSING);
                    rowSetProp.setPropertyValue(ESCAPEPROCESSING, (Object)escape);
                    String queryCommand = (String)prop.getPropertyValue(UNO_COMMAND);
                    statement = "SELECT * FROM (" + queryCommand + ") \"__LibreOffice_report_result\"";
                }
            } else {
                statement = "SELECT * FROM (" + command + ") \"__LibreOffice_report_result\"";
            }
            rowSetProp.setPropertyValue(UNO_COMMAND, (Object)statement);
            rowSetProp.setPropertyValue(UNO_COMMAND_TYPE, (Object)2);
        }
        rowSetProp.setPropertyValue("Order", (Object)order.toString());
    }

    private class ParameterDefinition {
        private int parameterCount = 0;
        private final ArrayList<Integer> parameterIndex = new ArrayList();

        private ParameterDefinition() {
        }
    }

    private class RowSetProperties {
        final Boolean escapeProcessing;
        final int commandType;
        final Integer maxRows;
        final String command;
        final String filter;

        public RowSetProperties(Boolean escapeProcessing, int commandType, String command, String filter, Integer maxRows) {
            this.escapeProcessing = escapeProcessing;
            this.commandType = commandType;
            this.command = command;
            this.filter = filter;
            this.maxRows = maxRows;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowSetProperties other = (RowSetProperties)obj;
            if (!(this.escapeProcessing == other.escapeProcessing || this.escapeProcessing != null && this.escapeProcessing.equals(other.escapeProcessing))) {
                return false;
            }
            if (this.commandType != other.commandType) {
                return false;
            }
            if (!(this.maxRows == other.maxRows || this.maxRows != null && this.maxRows.equals(other.maxRows))) {
                return false;
            }
            if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
                return false;
            }
            return !(this.filter == null ? other.filter != null : !this.filter.equals(other.filter));
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + (this.escapeProcessing != null ? this.escapeProcessing.hashCode() : 0);
            hash = 59 * hash + this.commandType;
            hash = 59 * hash + (this.maxRows != null ? this.maxRows.hashCode() : 0);
            hash = 59 * hash + (this.command != null ? this.command.hashCode() : 0);
            hash = 59 * hash + (this.filter != null ? this.filter.hashCode() : 0);
            return hash;
        }
    }
}

