/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;
import com.sun.star.wizards.form.DataEntrySetter;
import com.sun.star.wizards.form.FieldLinker;
import com.sun.star.wizards.form.FormConfiguration;
import com.sun.star.wizards.form.FormControlArranger;
import com.sun.star.wizards.form.StyleApplier;
import com.sun.star.wizards.form.UIControlArranger;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.ArrayList;

public class FormDocument
extends TextDocument {
    protected ArrayList<ControlForm> oControlForms = new ArrayList();
    protected CommandMetaData oMainFormDBMetaData;
    protected CommandMetaData oSubFormDBMetaData;
    protected String[][] LinkFieldNames;
    private FormHandler oFormHandler;
    private XPropertySet xPropPageStyle;
    private static final int SOFORMGAP = 2000;
    private boolean bhasSubForm;
    private UIControlArranger curUIControlArranger;
    private StyleApplier curStyleApplier;
    private int nPageWidth;
    private int nPageHeight;
    private int nFormWidth;
    private int nFormHeight;
    private Point aMainFormPoint;
    private static final String SOMAINFORM = "MainForm";
    private static final String SOSUBFORM = "SubForm";

    public FormDocument(XMultiServiceFactory xMSF) {
        super(xMSF, new TextDocument.ModuleIdentifier("com.sun.star.sdb.FormDesign"), true);
        try {
            this.oFormHandler = new FormHandler(xMSF, this.xTextDocument);
            this.oFormHandler.setDrawObjectsCaptureMode(false);
            TextStyleHandler oTextStyleHandler = new TextStyleHandler(this.xTextDocument);
            new ViewHandler(this.xTextDocument);
            this.oMainFormDBMetaData = new CommandMetaData(xMSF);
            this.oSubFormDBMetaData = new CommandMetaData(xMSF);
            ViewHandler oViewHandler = new ViewHandler(this.xTextDocument);
            TextStyleHandler oTextStyleSupplier = new TextStyleHandler(this.xTextDocument);
            Helper.setUnoPropertyValue(this.xTextDocument, "ApplyFormDesignMode", Boolean.FALSE);
            oViewHandler.setViewSetting("ShowTableBoundaries", Boolean.FALSE);
            oViewHandler.setViewSetting("ShowOnlineLayout", Boolean.TRUE);
            this.xPropPageStyle = oTextStyleSupplier.getStyleByName("PageStyles", "Standard");
            Size aSize = oTextStyleHandler.changePageAlignment(this.xPropPageStyle, true);
            this.nPageWidth = aSize.Width;
            this.nPageHeight = aSize.Height;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void addUIFormController(UIControlArranger _curUIControlArranger) {
        this.curUIControlArranger = _curUIControlArranger;
    }

    public void addStyleApplier(StyleApplier _curStyleApplier) {
        this.curStyleApplier = _curStyleApplier;
    }

    private String getDataSourceName() {
        return this.oMainFormDBMetaData.DataSourceName;
    }

    private void adjustPageStyle() {
        try {
            int totfieldcount = this.getMainFieldCount() + this.getSubFieldCount();
            int nMargin = totfieldcount > 30 ? 500 : (totfieldcount > 20 ? 750 : 1000);
            this.xPropPageStyle.setPropertyValue("RightMargin", (Object)nMargin);
            this.xPropPageStyle.setPropertyValue("LeftMargin", (Object)nMargin);
            this.xPropPageStyle.setPropertyValue("TopMargin", (Object)nMargin);
            this.xPropPageStyle.setPropertyValue("BottomMargin", (Object)nMargin);
            this.aMainFormPoint = new Point(nMargin, nMargin);
            this.nFormWidth = (int)(0.8 * (double)this.nPageWidth) - 2 * nMargin;
            this.nFormHeight = (int)(0.65 * (double)this.nPageHeight) - 2 * nMargin;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void initialize(boolean _baddParentForm, boolean _bShouldHaveSubForm, boolean _bModifySubForm, Short _NBorderType) {
        this.bhasSubForm = _bShouldHaveSubForm;
        this.adjustPageStyle();
        if (_baddParentForm) {
            if (this.oControlForms.isEmpty()) {
                ControlForm aMainControlForm = new ControlForm(this, SOMAINFORM, this.aMainFormPoint, this.getMainFormSize(3));
                this.oControlForms.add(aMainControlForm);
            } else {
                this.oFormHandler.removeControlsofForm(SOMAINFORM);
                this.oControlForms.get((int)0).oFormController = null;
            }
            this.oControlForms.get(0).initialize(this.curUIControlArranger.getSelectedArrangement(0), _NBorderType);
        }
        if (_bShouldHaveSubForm) {
            if (this.oControlForms.size() == 1) {
                this.adjustMainFormSize(_NBorderType);
                ControlForm aSubControlForm = new ControlForm(this, SOSUBFORM, this.getSubFormPoint(), this.getSubFormSize());
                this.oControlForms.add(aSubControlForm);
                aSubControlForm.initialize(this.curUIControlArranger.getSelectedArrangement(1), _NBorderType);
            } else if (_bModifySubForm && this.oControlForms.size() > 1) {
                this.oFormHandler.removeControlsofForm(SOSUBFORM);
                this.oControlForms.get((int)1).oFormController = null;
                this.oControlForms.get(1).initialize(this.curUIControlArranger.getSelectedArrangement(1), _NBorderType);
            }
        } else {
            ControlForm aMainForm = this.oControlForms.get(0);
            if (aMainForm.xFormContainer != null && aMainForm.xFormContainer.hasByName(SOSUBFORM)) {
                this.oFormHandler.removeControlsofForm(SOSUBFORM);
                this.oFormHandler.removeElement(aMainForm.xFormContainer, SOSUBFORM);
                this.oControlForms.get((int)1).oFormController = null;
                this.oControlForms.remove(1);
                this.adjustMainFormSize(_NBorderType);
            }
        }
    }

    private int getMainFieldCount() {
        return this.oMainFormDBMetaData.getFieldNames().length;
    }

    private int getSubFieldCount() {
        return this.oSubFormDBMetaData.getFieldNames().length;
    }

    private Size getMainFormSize(int _curArrangement) {
        int nMainFormHeight = this.nFormHeight;
        if (this.bhasSubForm) {
            if (_curArrangement == 3) {
                nMainFormHeight = (int)((double)(this.nFormHeight - 2000) / 2.0);
            } else {
                int nTotalFieldCount = this.getMainFieldCount() + this.getSubFieldCount();
                nMainFormHeight = (int)((double)this.getMainFieldCount() / (double)nTotalFieldCount * ((double)(this.nFormHeight - 2000) / 2.0));
            }
        }
        return new Size(this.nFormWidth, nMainFormHeight);
    }

    private Size getSubFormSize() {
        int nMainFormHeight = this.oControlForms.get(0).getActualFormHeight();
        return new Size(this.nFormWidth, this.nFormHeight - nMainFormHeight - 2000);
    }

    private Point getSubFormPoint() {
        ControlForm curMainControlForm = this.oControlForms.get(0);
        return new Point(curMainControlForm.aStartPoint.X, curMainControlForm.aStartPoint.Y + curMainControlForm.getFormSize().Height + 2000);
    }

    private void adjustMainFormSize(Short _NBorderType) {
        ControlForm oMainControlForm = this.oControlForms.get(0);
        oMainControlForm.setFormSize(this.getMainFormSize(oMainControlForm.curArrangement));
        if (oMainControlForm.curArrangement == 3) {
            oMainControlForm.oGridControl.setSize(oMainControlForm.getFormSize());
        } else {
            oMainControlForm.oFormController.positionControls(oMainControlForm.curArrangement, oMainControlForm.aStartPoint, oMainControlForm.getFormSize(), this.curUIControlArranger.getAlignValue(), _NBorderType);
        }
    }

    private void adjustSubFormPosSize(Short _NBorderType) {
        ControlForm oMainControlForm = this.oControlForms.get(0);
        ControlForm oSubControlForm = this.oControlForms.get(1);
        oSubControlForm.setFormSize(new Size(this.nFormWidth, this.nFormHeight - oMainControlForm.getFormSize().Height));
        if (oSubControlForm.curArrangement == 3) {
            Point aPoint = oSubControlForm.oGridControl.getPosition();
            int idiffheight = oSubControlForm.getEntryPointY() - oMainControlForm.getActualFormHeight() - oMainControlForm.aStartPoint.Y - 2000;
            oSubControlForm.setStartPoint(new Point(aPoint.X, aPoint.Y - idiffheight));
            oSubControlForm.oGridControl.setPosition(oSubControlForm.aStartPoint);
            oSubControlForm.oGridControl.setSize(this.getSubFormSize());
        } else {
            oSubControlForm.setStartPoint(new Point(oSubControlForm.aStartPoint.X, oMainControlForm.getActualFormHeight() + oMainControlForm.aStartPoint.Y + 2000));
            oSubControlForm.oFormController.positionControls(oSubControlForm.curArrangement, oSubControlForm.aStartPoint, oSubControlForm.getAvailableFormSize(), this.curUIControlArranger.getAlignValue(), _NBorderType);
        }
    }

    public ControlForm getControlFormByName(String _sname) {
        for (int i = 0; i < this.oControlForms.size(); ++i) {
            ControlForm curControlForm = this.oControlForms.get(i);
            if (!curControlForm.Name.equals(_sname)) continue;
            return curControlForm;
        }
        return null;
    }

    public ControlForm[] getControlForms() {
        ControlForm[] aResult = new ControlForm[this.oControlForms.size()];
        this.oControlForms.toArray(aResult);
        return aResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finalizeForms(DataEntrySetter _curDataEntrySetter, FieldLinker _curFieldLinker, FormConfiguration _curFormConfiguration) {
        try {
            this.xTextDocument.lockControllers();
            PropertyValue[] aFormProperties = _curDataEntrySetter.getFormProperties();
            ControlForm oMasterControlForm = this.getControlFormByName(SOMAINFORM);
            oMasterControlForm.setFormProperties(aFormProperties, this.oMainFormDBMetaData);
            oMasterControlForm.finalizeControls();
            if (oMasterControlForm.xFormContainer.hasByName(SOSUBFORM)) {
                ControlForm oSubControlForm = this.getControlFormByName(SOSUBFORM);
                oSubControlForm.setFormProperties(aFormProperties, this.oSubFormDBMetaData);
                String sRefTableName = _curFormConfiguration.getreferencedTableName();
                this.LinkFieldNames = sRefTableName.equals(PropertyNames.EMPTY_STRING) ? _curFieldLinker.getLinkFieldNames() : _curFieldLinker.getLinkFieldNames(_curFormConfiguration.getRelationController(), sRefTableName);
                if (this.LinkFieldNames != null && this.LinkFieldNames.length > 0) {
                    oSubControlForm.xPropertySet.setPropertyValue("DetailFields", (Object)this.LinkFieldNames[0]);
                    oSubControlForm.xPropertySet.setPropertyValue("MasterFields", (Object)this.LinkFieldNames[1]);
                    oSubControlForm.finalizeControls();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockallControllers();
        }
    }

    public class ControlForm {
        XNameContainer xFormContainer;
        GridControl oGridControl;
        FormControlArranger oFormController;
        int curArrangement;
        FormDocument oFormDocument;
        String Name;
        Point aStartPoint;
        private Size aFormSize;
        CommandMetaData oDBMetaData;
        XPropertySet xPropertySet;

        public ControlForm(FormDocument _oFormDocument, String _sname, Point _astartPoint, Size _aFormSize) {
            this.aStartPoint = _astartPoint;
            this.aFormSize = _aFormSize;
            this.oFormDocument = _oFormDocument;
            this.Name = _sname;
            if (_sname.equals(FormDocument.SOSUBFORM)) {
                ControlForm oMainControlForm = FormDocument.this.oControlForms.get(0);
                this.xFormContainer = FormDocument.this.oFormHandler.insertFormbyName(_sname, oMainControlForm.xFormContainer);
            } else {
                this.xFormContainer = FormDocument.this.oFormHandler.insertFormbyName(_sname);
            }
            this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xFormContainer);
            this.oDBMetaData = _sname.equals(FormDocument.SOMAINFORM) ? this.oFormDocument.oMainFormDBMetaData : this.oFormDocument.oSubFormDBMetaData;
        }

        public void initialize(int _curArrangement, Short _NBorderType) {
            ControlForm curSubControlForm;
            boolean adaptControlStyles = false;
            FormDocument.this.xTextDocument.lockControllers();
            this.curArrangement = _curArrangement;
            if (this.oGridControl != null) {
                ((FormDocument)FormDocument.this).oFormHandler.xDrawPage.remove(this.oGridControl.xShape);
                this.oGridControl.xComponent.dispose();
                this.oGridControl = null;
            }
            if (this.oFormController == null) {
                this.oFormController = new FormControlArranger(FormDocument.this.oFormHandler, this.xFormContainer, this.oDBMetaData, FormDocument.this.xProgressBar, this.aStartPoint, this.aFormSize);
            } else if (this.curArrangement == 3) {
                FormDocument.this.oFormHandler.moveShapesToNirwana(this.getLabelControls());
                FormDocument.this.oFormHandler.moveShapesToNirwana(this.getDatabaseControls());
            }
            if (this.curArrangement == 3) {
                this.insertGridControl(_NBorderType);
                adaptControlStyles = true;
            } else {
                adaptControlStyles = !this.oFormController.areControlsexisting();
                this.oFormController.positionControls(_curArrangement, this.aStartPoint, this.getAvailableFormSize(), FormDocument.this.curUIControlArranger.getAlignValue(), _NBorderType);
            }
            if (adaptControlStyles) {
                FormDocument.this.curStyleApplier.applyStyle(false, true);
            }
            if (this.Name.equals(FormDocument.SOMAINFORM) && FormDocument.this.oControlForms.size() > 1 && (curSubControlForm = FormDocument.this.oControlForms.get(1)) != null) {
                FormDocument.this.adjustSubFormPosSize(_NBorderType);
            }
            this.setFormSize(new Size(this.aFormSize.Width, this.getActualFormHeight()));
            FormDocument.this.unlockallControllers();
        }

        public Control[] getLabelControls() {
            if (this.oFormController != null) {
                return this.oFormController.getLabelControlList();
            }
            return null;
        }

        public Size getFormSize() {
            return this.aFormSize;
        }

        private Size getAvailableFormSize() {
            if (this.Name.equals(FormDocument.SOMAINFORM)) {
                this.setFormSize(FormDocument.this.getMainFormSize(this.curArrangement));
            } else {
                this.setFormSize(FormDocument.this.getSubFormSize());
            }
            return this.aFormSize;
        }

        public void setFormSize(Size _aSize) {
            this.aFormSize = _aSize;
            this.oFormController.setFormSize(this.aFormSize);
        }

        private void setStartPoint(Point _aPoint) {
            this.aStartPoint = _aPoint;
            if (this.oFormController != null) {
                this.oFormController.setStartPoint(_aPoint);
            }
        }

        private int getActualFormHeight() {
            if (this.curArrangement == 3) {
                return this.oGridControl.xShape.getSize().Height;
            }
            return this.oFormController.getFormHeight();
        }

        private int getEntryPointY() {
            if (this.curArrangement == 3) {
                return this.oGridControl.xShape.getPosition().Y;
            }
            return this.oFormController.getEntryPointY();
        }

        private void setFormProperties(PropertyValue[] _aPropertySetList, CommandMetaData _oDBMetaData) {
            try {
                this.xPropertySet.setPropertyValue("DataSourceName", (Object)FormDocument.this.getDataSourceName());
                this.xPropertySet.setPropertyValue(PropertyNames.COMMAND, (Object)_oDBMetaData.getCommandName());
                this.xPropertySet.setPropertyValue(PropertyNames.COMMAND_TYPE, (Object)_oDBMetaData.getCommandType());
                for (int i = 0; i < _aPropertySetList.length; ++i) {
                    this.xPropertySet.setPropertyValue(_aPropertySetList[i].Name, _aPropertySetList[i].Value);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }

        public DatabaseControl[] getDatabaseControls() {
            if (this.oFormController != null) {
                return this.oFormController.DBControlList;
            }
            return null;
        }

        public GridControl getGridControl() {
            return this.oGridControl;
        }

        public int getArrangemode() {
            return this.curArrangement;
        }

        private void insertGridControl(Short _NBorderType) {
            try {
                this.curArrangement = 3;
                this.oGridControl = this.Name.equals(FormDocument.SOMAINFORM) ? new GridControl(FormDocument.this.xMSF, this.Name + "_Grid", FormDocument.this.oFormHandler, this.xFormContainer, this.oDBMetaData.FieldColumns, this.aStartPoint, FormDocument.this.getMainFormSize(3)) : new GridControl(FormDocument.this.xMSF, this.Name + "_Grid", FormDocument.this.oFormHandler, this.xFormContainer, this.oDBMetaData.FieldColumns, this.aStartPoint, FormDocument.this.getSubFormSize());
                this.oGridControl.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)_NBorderType);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }

        public void finalizeControls() {
            Control[] oLabelControls = this.getLabelControls();
            DatabaseControl[] oDBControls = this.getDatabaseControls();
            if (oLabelControls != null) {
                for (int i = 0; i < this.getLabelControls().length; ++i) {
                    if (this.curArrangement == 3) {
                        if (oLabelControls[i] == null || oDBControls[i] == null) continue;
                        FormDocument.this.oFormHandler.removeShape(oLabelControls[i].xShape);
                        FormDocument.this.oFormHandler.removeShape(oDBControls[i].xShape);
                        continue;
                    }
                    FormDocument.this.oFormHandler.groupShapesTogether(FormDocument.this.xMSF, oLabelControls[i].xShape, oDBControls[i].xShape);
                }
            }
        }
    }
}

