/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.space;

import net.adaptivebox.space.DesignDim;

public class DesignSpace {
    private DesignDim[] dimProps;

    public DesignSpace(int dim) {
        this.dimProps = new DesignDim[dim];
    }

    public void setElemAt(DesignDim elem, int index) {
        this.dimProps[index] = elem;
    }

    public int getDimension() {
        if (this.dimProps == null) {
            return -1;
        }
        return this.dimProps.length;
    }

    public double boundAdjustAt(double val, int dim) {
        return this.dimProps[dim].paramBound.boundAdjust(val);
    }

    public void mutationAt(double[] location, int i) {
        location[i] = this.dimProps[i].paramBound.getRandomValue();
    }

    public double getMagnitudeIn(int dimensionIndex) {
        return this.dimProps[dimensionIndex].paramBound.getLength();
    }

    public void initializeGene(double[] tempX) {
        for (int i = 0; i < tempX.length; ++i) {
            tempX[i] = this.dimProps[i].paramBound.getRandomValue();
        }
    }

    public double[] getFreshGene() {
        double[] tempX = new double[this.getDimension()];
        this.initializeGene(tempX);
        return tempX;
    }

    public void getMappingPoint(double[] point) {
        for (int i = 0; i < this.getDimension(); ++i) {
            point[i] = this.dimProps[i].paramBound.annulusAdjust(point[i]);
            if (!this.dimProps[i].isDiscrete()) continue;
            point[i] = this.dimProps[i].getGrainedValue(point[i]);
        }
    }
}

