/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.sco;

import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.DesignSpace;
import net.adaptivebox.space.ILocationEngine;

public class SCAgent {
    private ProblemEncoder problemEncoder;
    private IGoodnessCompareEngine specComparator;
    private final int TaoB = 2;
    private final int TaoW = 4;
    private Library externalLib;
    private SearchPoint trailPoint;
    private SearchPoint pcurrent_t;

    public void setExternalLib(Library lib) {
        this.externalLib = lib;
    }

    public void setProblemEncoder(ProblemEncoder encoder) {
        this.problemEncoder = encoder;
        this.trailPoint = this.problemEncoder.getFreshSearchPoint();
        this.pcurrent_t = this.problemEncoder.getEncodedSearchPoint();
    }

    public void setSpecComparator(IGoodnessCompareEngine comparer) {
        this.specComparator = comparer;
    }

    public SearchPoint generatePoint() {
        this.generatePoint(this.trailPoint);
        this.problemEncoder.evaluate(this.trailPoint);
        return this.trailPoint;
    }

    private void generatePoint(ILocationEngine tempPoint) {
        SearchPoint Xrefer;
        SearchPoint Xmodel;
        int xb = this.externalLib.tournamentSelection(this.specComparator, 2, true);
        SearchPoint libBPoint = this.externalLib.getSelectedPoint(xb);
        if (this.specComparator.compare(this.pcurrent_t.getEncodeInfo(), libBPoint.getEncodeInfo()) == 2) {
            Xmodel = libBPoint;
            Xrefer = this.pcurrent_t;
        } else {
            Xmodel = this.pcurrent_t;
            Xrefer = libBPoint;
        }
        this.inferPoint(tempPoint, Xmodel, Xrefer, this.problemEncoder.getDesignSpace());
    }

    public void updateInfo() {
        int xw = this.externalLib.tournamentSelection(this.specComparator, 4, false);
        this.externalLib.getSelectedPoint(xw).importPoint(this.pcurrent_t);
        this.pcurrent_t.importPoint(this.trailPoint);
    }

    private boolean inferPoint(ILocationEngine newPoint, ILocationEngine point1, ILocationEngine point2, DesignSpace space) {
        double[] newLoc = newPoint.getLocation();
        double[] real1 = point1.getLocation();
        double[] real2 = point2.getLocation();
        for (int i = 0; i < newLoc.length; ++i) {
            newLoc[i] = real1[i] * 2.0 - real2[i];
            newLoc[i] = space.boundAdjustAt(newLoc[i], i);
            newLoc[i] = RandomGenerator.doubleRangeRandom(newLoc[i], real2[i]);
        }
        return true;
    }
}

