/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.problem;

import net.adaptivebox.encode.EvalElement;
import net.adaptivebox.encode.EvalStruct;
import net.adaptivebox.global.BasicBound;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.space.DesignDim;
import net.adaptivebox.space.DesignSpace;

public abstract class ProblemEncoder {
    private final double[] tempResponseSet;
    private final double[] tempLocation;
    private final DesignSpace designSpace;
    private final EvalStruct evalStruct;

    protected ProblemEncoder(int paramNum, int targetNum) throws Exception {
        this.designSpace = new DesignSpace(paramNum);
        this.evalStruct = new EvalStruct(targetNum);
        this.tempLocation = new double[paramNum];
        this.tempResponseSet = new double[targetNum];
    }

    public DesignSpace getDesignSpace() {
        return this.designSpace;
    }

    public EvalStruct getEvalStruct() {
        return this.evalStruct;
    }

    protected void setDefaultXAt(int i, double min, double max, double grain) {
        DesignDim dd = new DesignDim();
        dd.grain = grain;
        dd.paramBound = new BasicBound(min, max);
        this.designSpace.setElemAt(dd, i);
    }

    protected void setDefaultYAt(int i, double min, double max) {
        EvalElement ee = new EvalElement();
        ee.targetBound = new BasicBound(min, max);
        this.evalStruct.setElemAt(ee, i);
    }

    public SearchPoint getFreshSearchPoint() {
        return new SearchPoint(this.designSpace.getDimension());
    }

    public SearchPoint getEncodedSearchPoint() {
        SearchPoint point = this.getFreshSearchPoint();
        this.designSpace.initializeGene(point.getLocation());
        this.evaluate(point);
        return point;
    }

    public void evaluate(SearchPoint point) {
        System.arraycopy(point.getLocation(), 0, this.tempLocation, 0, this.tempLocation.length);
        this.designSpace.getMappingPoint(this.tempLocation);
        this.calcTargets(this.tempResponseSet, this.tempLocation);
        this.evalStruct.evaluate(point.getEncodeInfo(), this.tempResponseSet);
        point.setObjectiveValue(this.tempResponseSet[0]);
    }

    protected abstract double calcTargetAt(int var1, double[] var2);

    private void calcTargets(double[] VY, double[] VX) {
        for (int i = 0; i < VY.length; ++i) {
            VY[i] = this.calcTargetAt(i, VX);
        }
    }
}

