/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import net.adaptivebox.global.BasicTag;
import net.adaptivebox.global.GlobalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalFile {
    private static int counter = -1;

    public static File createTempDir(String prefix, String directory) {
        String tempDir;
        File f = null;
        boolean isCreated = false;
        do {
            if (counter == -1) {
                counter = new Random().nextInt() & 0xFFFF;
            }
            ++counter;
            if (prefix == null) {
                throw new NullPointerException();
            }
            if (prefix.length() >= 3) continue;
            throw new IllegalArgumentException("Prefix string too short");
        } while (!(isCreated = (f = new File(tempDir = directory == null ? prefix + counter : GlobalFile.getFileLocation(directory, prefix + counter))).mkdir()));
        return f;
    }

    public static void addStringToFile(String inStr, String fileStr) throws Exception {
        RandomAccessFile raFile = new RandomAccessFile(fileStr, "rw");
        raFile.seek(raFile.length());
        raFile.writeBytes(inStr);
        raFile.close();
    }

    public static Object loadObjectFromFile(String fileName) throws Exception {
        FileInputStream fis = new FileInputStream(fileName);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public static void saveObjectToFile(String fileName, Object obj) throws Exception {
        FileOutputStream ostream = new FileOutputStream(fileName);
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(obj);
        p.flush();
        ostream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStringToFile(String inStr, String fileStr) throws Exception {
        new File(new File(fileStr).getParent()).mkdirs();
        FileOutputStream pspOutputStream = null;
        try {
            pspOutputStream = new FileOutputStream(new File(fileStr));
            pspOutputStream.write(inStr.getBytes());
        }
        finally {
            if (pspOutputStream != null) {
                pspOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(String fileStr) throws Exception {
        String getStr = null;
        FileInputStream pspInputStream = null;
        try {
            pspInputStream = new FileInputStream(fileStr);
            byte[] pspFileBuffer = new byte[pspInputStream.available()];
            pspInputStream.read(pspFileBuffer);
            getStr = new String(pspFileBuffer);
        }
        finally {
            if (pspInputStream != null) {
                pspInputStream.close();
            }
        }
        return getStr;
    }

    public static ArrayList<ArrayList<Double>> getCurveDataFromFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inStream = null;
        BufferedReader inReader = null;
        try {
            inStream = new FileInputStream(file);
            inReader = new BufferedReader(new InputStreamReader(inStream));
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<Double> xaxes = new ArrayList<Double>(1);
        ArrayList<Double> yaxes = new ArrayList<Double>(1);
        try {
            boolean start = false;
            block8: while (inReader.ready()) {
                StringTokenizer st = new StringTokenizer(inReader.readLine());
                while (!st.hasMoreTokens()) {
                    if (!inReader.ready()) continue block8;
                    st = new StringTokenizer(inReader.readLine());
                }
                String s = st.nextToken();
                if (!start && !s.startsWith("@")) continue;
                if (!start) {
                    start = true;
                    continue;
                }
                if (s.startsWith("#") || s.startsWith("$") || s.startsWith("/")) continue;
                Double xaxis = null;
                Double yaxis = null;
                try {
                    xaxis = Double.valueOf(s);
                    xaxes.add(xaxis);
                }
                catch (NumberFormatException e) {
                    inReader.close();
                    inStream.close();
                    return null;
                }
                s = st.nextToken();
                try {
                    yaxis = Double.valueOf(s);
                    yaxes.add(yaxis);
                }
                catch (NumberFormatException e) {
                    inReader.close();
                    inStream.close();
                    return null;
                }
            }
            inReader.close();
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<ArrayList<Double>> curveData = new ArrayList<ArrayList<Double>>(2);
        curveData.add(xaxes);
        curveData.add(yaxes);
        return curveData;
    }

    public static String getFileLocation(String dir, String fileName) {
        String realDir = dir;
        while (realDir.length() > 0 && (realDir.endsWith("/") || realDir.endsWith("\\"))) {
            realDir = dir.substring(0, dir.length() - 1);
        }
        return realDir + BasicTag.FILE_SEP_TAG + fileName;
    }

    public static String getFileName(String nameBody, String suffix) {
        if (suffix == null || suffix.trim().length() == 0) {
            return nameBody;
        }
        String fileName = nameBody;
        if (nameBody.endsWith(".")) {
            return fileName + suffix;
        }
        return nameBody + "." + suffix;
    }

    public static String getFileLocation(String dir, String fileNameBody, String fileNameSuffix) {
        String filename = GlobalFile.getFileName(fileNameBody, fileNameSuffix);
        return GlobalFile.getFileLocation(dir, filename);
    }

    public static void clear(String fileStr) throws Exception {
        File file = new File(fileStr);
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] fileNames = file.list();
        if (fileNames == null) {
            return;
        }
        for (int i = 0; i < fileNames.length; ++i) {
            String newFileName = GlobalFile.getFileLocation(fileStr, fileNames[i]);
            GlobalFile.clear(newFileName);
        }
        file.delete();
    }

    public static String getFilePrefix(String fileStr) {
        int index = fileStr.lastIndexOf(".");
        if (index == -1) {
            index = fileStr.length();
        }
        return fileStr.substring(0, index);
    }

    public static String getFileSuffix(String fileStr) {
        String[] subNames = GlobalString.tokenize(fileStr, ".");
        int subNameLen = subNames.length;
        if (subNameLen == 1) {
            return "";
        }
        return subNames[subNameLen - 1];
    }

    public static String createTempImageFile(String origFile) throws Exception {
        return GlobalFile.createTempImageFile(origFile, "img", ".inf");
    }

    public static String createTempImageFile(String origFile, String prefix, String suffix) throws Exception {
        File outputFile = GlobalFile.createTempFile(prefix, suffix);
        outputFile.deleteOnExit();
        GlobalFile.copyFile(outputFile.getAbsolutePath(), origFile);
        return outputFile.getAbsolutePath();
    }

    public static void copyFile(String imgFile, String origFile) throws Exception {
        String fileContent = GlobalFile.getStringFromFile(origFile);
        GlobalFile.saveStringToFile(fileContent, imgFile);
    }

    public static File createTempFile(String prefix, String suffix) throws Exception {
        String realSuffix = suffix;
        if (!realSuffix.startsWith(".")) {
            realSuffix = "." + suffix;
        }
        return File.createTempFile(prefix, realSuffix);
    }
}

