/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Point;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SheetSettings
implements OfficeConstants {
    private Document settings = null;
    private String sheetName;
    private int cursorX = 0;
    private int cursorY = 0;
    private int splitTypeX;
    private int splitTypeY;
    private int splitPointX = 0;
    private int splitPointY = 0;
    private int posLeft = 0;
    private int posTop = 0;
    private int paneNumber = 2;
    private static final int SPLIT = 1;
    private static final int FREEZE = 2;

    public SheetSettings() {
    }

    public SheetSettings(Node root) {
        this.readNode(root);
    }

    public SheetSettings(String name) {
        this.sheetName = name;
    }

    public void setCursor(Point activeCell) {
        this.cursorX = (int)activeCell.getX();
        this.cursorY = (int)activeCell.getY();
    }

    public Point getCursor() {
        return new Point(this.cursorX, this.cursorY);
    }

    public void setFreeze(Point splitPoint) {
        this.splitTypeX = 2;
        this.splitTypeY = 2;
        this.splitPointX = (int)splitPoint.getX();
        this.splitPointY = (int)splitPoint.getY();
    }

    public void setSplit(Point splitPoint) {
        this.splitTypeX = 1;
        this.splitTypeY = 1;
        this.splitPointX = (int)splitPoint.getX();
        this.splitPointY = (int)splitPoint.getY();
    }

    public Point getSplit() {
        return new Point(this.splitPointX, this.splitPointY);
    }

    public Point getSplitType() {
        return new Point(this.splitTypeX, this.splitTypeY);
    }

    public int getLeft() {
        return this.posLeft;
    }

    public int getTop() {
        return this.posTop;
    }

    public int getPaneNumber() {
        return this.paneNumber;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void setPaneNumber(int paneNumber) {
        this.paneNumber = paneNumber;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    private void addConfigItem(Node root, String attribute, String type, String value) {
        Element configItem = this.settings.createElement("config:config-item");
        configItem.setAttribute("config:name", attribute);
        configItem.setAttribute("config:type", type);
        configItem.appendChild(this.settings.createTextNode(value));
        root.appendChild(configItem);
    }

    public void writeNode(Document settings, Node root) {
        this.settings = settings;
        Element configItemMapEntry = settings.createElement("config:config-item-map-entry");
        configItemMapEntry.setAttribute("config:name", this.getSheetName());
        this.addConfigItem(configItemMapEntry, "CursorPositionX", "int", Integer.toString(this.cursorX));
        this.addConfigItem(configItemMapEntry, "CursorPositionY", "int", Integer.toString(this.cursorY));
        String splitMode = Integer.toString(this.splitTypeX);
        if (this.splitPointX == 0) {
            splitMode = "0";
        }
        this.addConfigItem(configItemMapEntry, "HorizontalSplitMode", "short", splitMode);
        splitMode = Integer.toString(this.splitTypeY);
        if (this.splitPointY == 0) {
            splitMode = "0";
        }
        this.addConfigItem(configItemMapEntry, "VerticalSplitMode", "short", splitMode);
        this.addConfigItem(configItemMapEntry, "HorizontalSplitPosition", "int", Integer.toString(this.splitPointX));
        this.addConfigItem(configItemMapEntry, "VerticalSplitPosition", "int", Integer.toString(this.splitPointY));
        this.addConfigItem(configItemMapEntry, "ActiveSplitRange", "short", Integer.toString(this.paneNumber));
        this.addConfigItem(configItemMapEntry, "PositionLeft", "int", "0");
        this.addConfigItem(configItemMapEntry, "PositionRight", "int", Integer.toString(this.posLeft));
        this.addConfigItem(configItemMapEntry, "PositionTop", "int", "0");
        this.addConfigItem(configItemMapEntry, "PositionBottom", "int", Integer.toString(this.posTop));
        root.appendChild(configItemMapEntry);
    }

    private void addAttribute(String name, String value) {
        if (name.equals("CursorPositionX")) {
            this.cursorX = Integer.parseInt(value);
        } else if (name.equals("CursorPositionY")) {
            this.cursorY = Integer.parseInt(value);
        } else if (name.equals("HorizontalSplitPosition")) {
            this.splitPointX = Integer.parseInt(value);
        } else if (name.equals("VerticalSplitPosition")) {
            this.splitPointY = Integer.parseInt(value);
        } else if (name.equals("ActiveSplitRange")) {
            this.paneNumber = Integer.parseInt(value);
        } else if (name.equals("PositionRight")) {
            this.posLeft = Integer.parseInt(value);
        } else if (name.equals("PositionBottom")) {
            this.posTop = Integer.parseInt(value);
        } else if (name.equals("HorizontalSplitMode")) {
            this.splitTypeX = Integer.parseInt(value);
        } else if (name.equals("VerticalSplitMode")) {
            this.splitTypeY = Integer.parseInt(value);
        }
    }

    private void readNode(Node root) {
        NamedNodeMap sheetAtt = root.getAttributes();
        Node sheetNameNode = sheetAtt.getNamedItem("config:name");
        this.sheetName = sheetNameNode.getNodeValue();
        if (root.hasChildNodes()) {
            NodeList nodeList = root.getChildNodes();
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                String nodeName;
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1 || !(nodeName = child.getNodeName()).equals("config:config-item")) continue;
                NamedNodeMap cellAtt = child.getAttributes();
                Node configNameNode = cellAtt.getNamedItem("config:name");
                String name = configNameNode.getNodeValue();
                NodeList nodeList2 = child.getChildNodes();
                int len2 = nodeList2.getLength();
                String s = "";
                for (int j = 0; j < len2; ++j) {
                    Node child2 = nodeList2.item(j);
                    if (child2.getNodeType() != 3) continue;
                    s = child2.getNodeValue();
                }
                this.addAttribute(name, s);
            }
        }
    }
}

