/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Color;

public class Format
implements Cloneable {
    public static final int RIGHT_ALIGN = 1;
    public static final int CENTER_ALIGN = 2;
    public static final int LEFT_ALIGN = 3;
    public static final int TOP_ALIGN = 1;
    public static final int MIDDLE_ALIGN = 2;
    public static final int BOTTOM_ALIGN = 3;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int SUPERSCRIPT = 16;
    public static final int SUBSCRIPT = 32;
    public static final int LEFT_BORDER = 64;
    public static final int RIGHT_BORDER = 128;
    public static final int TOP_BORDER = 256;
    public static final int BOTTOM_BORDER = 512;
    public static final int WORD_WRAP = 1024;
    private int align;
    private int vertAlign;
    private String category;
    private String value;
    private String formatSpecifier;
    private int decimalPlaces;
    private String fontName;
    private int sizeInPoints;
    private Color foreground;
    private Color background;
    private int attributes = 0;
    private int mask = 0;

    public Format() {
        this.clearFormatting();
    }

    public Format(int attributes, int fontSize, String fontName) {
        this.attributes = attributes;
        this.sizeInPoints = fontSize;
        this.fontName = fontName;
    }

    public Format(Format fmt) {
        this.category = fmt.getCategory();
        this.value = fmt.getValue();
        this.formatSpecifier = fmt.getFormatSpecifier();
        this.decimalPlaces = fmt.getDecimalPlaces();
        this.attributes = fmt.attributes;
        this.mask = fmt.mask;
        this.fontName = fmt.getFontName();
        this.align = fmt.getAlign();
        this.vertAlign = fmt.getVertAlign();
        this.foreground = fmt.getForeground();
        this.background = fmt.getBackground();
        this.sizeInPoints = fmt.sizeInPoints;
    }

    public void clearFormatting() {
        this.category = "";
        this.value = "";
        this.formatSpecifier = "";
        this.decimalPlaces = 0;
        this.attributes = 0;
        this.mask = 0;
        this.sizeInPoints = 10;
        this.align = 3;
        this.vertAlign = 3;
        this.fontName = "";
        this.foreground = null;
        this.background = null;
    }

    public void setAttribute(int flags, boolean toggle) {
        this.mask |= flags;
        this.attributes = toggle ? (this.attributes |= flags) : (this.attributes &= ~flags);
    }

    public boolean getAttribute(int attribute) {
        if ((this.mask & attribute) == 0) {
            return false;
        }
        return (this.attributes & attribute) != 0;
    }

    public void setCategory(String newCategory) {
        this.category = newCategory;
    }

    public String getCategory() {
        return this.category;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public void setFormatSpecifier(String formatString) {
        this.formatSpecifier = formatString;
    }

    public String getFormatSpecifier() {
        return this.formatSpecifier;
    }

    public void setDecimalPlaces(int precision) {
        this.decimalPlaces = precision;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontSize(int fontSize) {
        this.sizeInPoints = fontSize;
    }

    public int getFontSize() {
        return this.sizeInPoints;
    }

    public void setVertAlign(int vertAlign) {
        this.vertAlign = vertAlign;
    }

    public int getVertAlign() {
        return this.vertAlign;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public int getAlign() {
        return this.align;
    }

    public void setForeground(Color c) {
        if (c != null) {
            this.foreground = new Color(c.getRGB());
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setBackground(Color c) {
        if (c != null) {
            this.background = new Color(c.getRGB());
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public String toString() {
        return "Value : " + this.getValue() + " Category : " + this.getCategory();
    }

    public boolean isDefault() {
        Format rhs = new Format();
        if (rhs.attributes != this.attributes) {
            return false;
        }
        if (this.foreground != rhs.foreground) {
            return false;
        }
        if (this.background != rhs.background) {
            return false;
        }
        if (rhs.align != this.align) {
            return false;
        }
        return rhs.vertAlign == this.vertAlign;
    }

    public boolean isSubset(Format rhs) {
        if (rhs.getClass() != this.getClass()) {
            return false;
        }
        if (rhs.attributes != this.attributes) {
            return false;
        }
        if (rhs.sizeInPoints != 0 && this.sizeInPoints != rhs.sizeInPoints) {
            return false;
        }
        if (this.fontName == null ? rhs.fontName != null : !this.fontName.equals(rhs.fontName)) {
            return false;
        }
        if (this.foreground != rhs.foreground) {
            return false;
        }
        if (this.background != rhs.background) {
            return false;
        }
        if (rhs.align != this.align) {
            return false;
        }
        return rhs.vertAlign == this.vertAlign;
    }
}

