/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.io.IOException;
import org.openoffice.xmerge.util.Resources;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class OfficeDocumentException
extends IOException {
    private StringBuffer message = null;

    public OfficeDocumentException(SAXException e) {
        super(e.toString());
        Exception ex;
        this.message = new StringBuffer();
        if (e instanceof SAXParseException) {
            String msgParseError = Resources.getInstance().getString("PARSE_ERROR");
            String msgLine = Resources.getInstance().getString("LINE");
            String msgColumn = Resources.getInstance().getString("COLUMN");
            String msgPublicId = Resources.getInstance().getString("PUBLIC_ID");
            String msgSystemId = Resources.getInstance().getString("SYSTEM_ID");
            SAXParseException spe = (SAXParseException)e;
            this.message.append(msgParseError);
            this.message.append(": ");
            this.message.append(msgLine);
            this.message.append(": ");
            this.message.append(spe.getLineNumber());
            this.message.append(", ");
            this.message.append(msgColumn);
            this.message.append(": ");
            this.message.append(spe.getColumnNumber());
            this.message.append(", ");
            this.message.append(msgSystemId);
            this.message.append(": ");
            this.message.append(spe.getSystemId());
            this.message.append(", ");
            this.message.append(msgPublicId);
            this.message.append(": ");
            this.message.append(spe.getPublicId());
            this.message.append("\n");
        }
        if ((ex = e.getException()) != null) {
            this.message.append(ex.getMessage());
        }
    }

    public OfficeDocumentException(String s) {
        super(s);
    }

    public OfficeDocumentException(Exception e) {
        super(e.getMessage());
    }

    public String getMessage() {
        return this.message.toString() + super.getMessage();
    }
}

