/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder.layout;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XLayoutConstrains;
import com.sun.star.awt.XUnitConversion;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.Property;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XFixedLine;
import com.sun.star.report.XFixedText;
import com.sun.star.report.XFormattedField;
import com.sun.star.report.XGroup;
import com.sun.star.report.XGroups;
import com.sun.star.report.XImageControl;
import com.sun.star.report.XReportComponent;
import com.sun.star.report.XReportControlModel;
import com.sun.star.report.XReportDefinition;
import com.sun.star.report.XSection;
import com.sun.star.style.XStyle;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloneable;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.PropertySetHelper;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.report.IReportBuilderLayouter;
import com.sun.star.wizards.report.IReportDefinitionReadAccess;
import com.sun.star.wizards.reportbuilder.layout.DesignTemplate;
import com.sun.star.wizards.reportbuilder.layout.SectionEmptyObject;
import com.sun.star.wizards.reportbuilder.layout.SectionObject;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ReportBuilderLayouter
implements IReportBuilderLayouter {
    private IReportDefinitionReadAccess m_xReportDefinitionReadAccess;
    private final Resource m_aResource;
    private String[][] m_aSortNames;
    int m_nLeftIndent = -1;
    int m_nRightIndent = -1;
    int m_nPageWidth = -1;
    protected XMultiServiceFactory m_xMSF;
    protected int m_aCommandType;
    protected String m_sTableName;
    protected String[] m_aGroupNames;
    protected String[] m_aFieldNames;
    protected String[] m_aFieldTitleNames;
    protected int[] m_aFieldWidths;
    protected int[] m_aFieldTypes;
    private DesignTemplate m_xDesignTemplate = null;
    XFixedText m_aFixedTextHelper = null;
    HashMap<String, Integer> m_aLabelWidthMap;

    public void dispose() {
        this.closeDesignTemplate();
        this.m_xReportDefinitionReadAccess = null;
    }

    protected ReportBuilderLayouter(IReportDefinitionReadAccess _xDefinitionAccess, Resource _aResource) {
        this.m_xReportDefinitionReadAccess = _xDefinitionAccess;
        this.m_aResource = _aResource;
    }

    public XReportDefinition getReportDefinition() {
        return this.m_xReportDefinitionReadAccess.getReportDefinition();
    }

    private XMultiServiceFactory getGlobalMSF() {
        return this.m_xReportDefinitionReadAccess.getGlobalMSF();
    }

    public synchronized void layout() {
        try {
            this.clearReportHeader();
            this.insertReportHeader();
            this.clearReportFooter();
            this.insertReportFooter();
            this.clearPageHeader();
            this.insertPageHeader();
            this.clearPageFooter();
            this.insertPageFooter();
            this.clearGroups();
            int lastGroupPostion = this.insertGroups();
            this.clearDetails();
            this.insertDetailFieldTitles(lastGroupPostion);
            this.insertDetailFields();
        }
        catch (ArrayIndexOutOfBoundsException lastGroupPostion) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void clearGroups() {
        XGroups xGroups = this.getReportDefinition().getGroups();
        while (xGroups.hasElements()) {
            try {
                xGroups.removeByIndex(0);
            }
            catch (com.sun.star.uno.Exception ex) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void emptySection(XSection _xSectionToClear) {
        if (_xSectionToClear == null) {
            return;
        }
        while (_xSectionToClear.hasElements()) {
            try {
                Object aObj = _xSectionToClear.getByIndex(0);
                XShape aShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)aObj);
                _xSectionToClear.remove(aShape);
            }
            catch (com.sun.star.uno.Exception ex) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void clearDetails() {
        XSection xSection = this.getReportDefinition().getDetail();
        this.emptySection(xSection);
    }

    protected int getLeftGroupIndent(int _nGroupCount) {
        int nIndent = 0;
        int MAX_INDENT = 2;
        nIndent = _nGroupCount <= 2 ? _nGroupCount * 500 : 1000;
        return nIndent;
    }

    protected int getLeftPageIndent() {
        if (this.m_nLeftIndent < 0) {
            this.m_nLeftIndent = this.getFromPageStyles("LeftMargin", 2000);
        }
        return this.m_nLeftIndent;
    }

    protected int getRightPageIndent() {
        if (this.m_nRightIndent < 0) {
            this.m_nRightIndent = this.getFromPageStyles("RightMargin", 2000);
        }
        return this.m_nRightIndent;
    }

    private XStyle getUsedStyle(String _sStyleName) {
        XStyle aUsedStyle = null;
        XNameAccess xNameAccess = this.getReportDefinition().getStyleFamilies();
        try {
            Object aPageStylesObj = xNameAccess.getByName(_sStyleName);
            XNameAccess xContainer = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)aPageStylesObj);
            String[] aElementNames = xContainer.getElementNames();
            for (int i = 0; i < aElementNames.length; ++i) {
                String sName = aElementNames[i];
                Object aObj = xContainer.getByName(sName);
                XStyle xStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)aObj);
                if (!xStyle.isInUse()) continue;
                aUsedStyle = xStyle;
                break;
            }
        }
        catch (com.sun.star.uno.Exception ex) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return aUsedStyle;
    }

    protected int getFromPageStyles(String _sStyleName, int _nDefault) {
        int nValue = _nDefault;
        XStyle xStyle = this.getUsedStyle("PageStyles");
        if (xStyle != null) {
            PropertySetHelper aHelper = new PropertySetHelper(xStyle);
            nValue = aHelper.getPropertyValueAsInteger(_sStyleName, nValue);
        }
        return nValue;
    }

    protected void setToPageStyles(String _sStyleName, Object _aObj) {
        XStyle xStyle = this.getUsedStyle("PageStyles");
        if (xStyle != null) {
            PropertySetHelper aHelper = new PropertySetHelper(xStyle);
            aHelper.setPropertyValueDontThrow(_sStyleName, _aObj);
        }
    }

    protected int getPageWidth() {
        if (this.m_nPageWidth < 0) {
            this.m_nPageWidth = this.getFromPageStyles(PropertyNames.PROPERTY_WIDTH, 21000);
        }
        return this.m_nPageWidth;
    }

    public void insertGroupNames(String[] _aGroupNames) {
        this.m_aGroupNames = _aGroupNames;
    }

    public void insertSortingNames(String[][] _aSortFieldNames) {
        this.m_aSortNames = _aSortFieldNames;
    }

    protected void copyGroupProperties(int _nGroup) {
        if (this.getDesignTemplate() != null) {
            try {
                XGroup xForeignGroup;
                XSection xForeignGroupSection;
                XGroups xForeignGroups = this.getDesignTemplate().getGroups();
                if (_nGroup < xForeignGroups.getCount() && (xForeignGroupSection = (xForeignGroup = (XGroup)UnoRuntime.queryInterface(XGroup.class, (Object)xForeignGroups.getByIndex(_nGroup))).getHeader()) != null) {
                    XGroups xGroups = this.getReportDefinition().getGroups();
                    Object aGroup = xGroups.getByIndex(_nGroup);
                    XGroup xGroup = (XGroup)UnoRuntime.queryInterface(XGroup.class, (Object)aGroup);
                    XSection xGroupSection = xGroup.getHeader();
                    this.copyProperties(xForeignGroupSection, xGroupSection);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected int insertGroups() {
        XGroups xGroups = this.getReportDefinition().getGroups();
        int lastGroupPosition = -1;
        if (this.m_aGroupNames != null) {
            int nLeftPageIndent = this.getLeftPageIndent();
            int nLabelWidth = this.getMaxLabelWidth();
            int nUsablePageWidth = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - this.getLeftGroupIndent(this.getCountOfGroups());
            int nFieldWidth = nUsablePageWidth - nLabelWidth;
            XGroup aLastGroup = null;
            for (int i = 0; i < this.m_aGroupNames.length; ++i) {
                XGroup xGroup;
                lastGroupPosition = i;
                aLastGroup = xGroup = xGroups.createGroup();
                xGroup.setExpression(this.m_aGroupNames[i]);
                xGroup.setHeaderOn(true);
                try {
                    int nCount = xGroups.getCount();
                    xGroups.insertByIndex(nCount, (Object)xGroup);
                    XSection xGroupSection = xGroup.getHeader();
                    this.copyGroupProperties(nCount);
                    Rectangle aRect = new Rectangle();
                    aRect.X = nLeftPageIndent + this.getLeftGroupIndent(i);
                    SectionObject aSO = this.getDesignTemplate().getGroupLabel(i);
                    aRect = this.insertLabel(xGroupSection, this.getTitleFromFieldName(this.m_aGroupNames[i]), aRect, nLabelWidth, aSO);
                    String sGroupName = this.convertToFieldName(this.m_aGroupNames[i]);
                    aSO = this.getDesignTemplate().getGroupTextField(i);
                    aRect = this.insertFormattedField(xGroupSection, sGroupName, aRect, nFieldWidth, aSO);
                    int height = aRect.Height;
                    aRect.X = nLeftPageIndent + this.getLeftGroupIndent(i);
                    aRect.Y = aRect.Height;
                    int nLineWidth = this.getPageWidth() - this.getRightPageIndent() - aRect.X;
                    int nLineHeight = 250;
                    this.insertHorizontalLine(xGroupSection, aRect, nLineWidth, 250);
                    xGroupSection.setHeight(height + 250);
                    continue;
                }
                catch (com.sun.star.uno.Exception ex) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (aLastGroup != null) {
                this.doNotBreakInTable(aLastGroup);
            }
        }
        if (this.m_aSortNames != null) {
            for (String[] sortFieldName : this.m_aSortNames) {
                try {
                    XGroup xGroup = xGroups.createGroup();
                    xGroup.setExpression(sortFieldName[0]);
                    xGroup.setSortAscending(PropertyNames.ASC.equals(sortFieldName[1]));
                    xGroup.setHeaderOn(false);
                    int nCount = xGroups.getCount();
                    xGroups.insertByIndex(nCount, (Object)xGroup);
                }
                catch (Exception ex) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return lastGroupPosition;
    }

    public void insertFieldTitles(String[] _aFieldTitleNames) {
        this.m_aFieldTitleNames = _aFieldTitleNames;
    }

    protected String getTitleFromFieldName(String _sField) {
        for (int i = 0; i < this.m_aFieldNames.length; ++i) {
            if (!this.m_aFieldNames[i].equals(_sField)) continue;
            return this.m_aFieldTitleNames[i];
        }
        return PropertyNames.EMPTY_STRING;
    }

    protected int getTypeFromFieldName(String _sField) {
        for (int i = 0; i < this.m_aFieldNames.length; ++i) {
            if (!this.m_aFieldNames[i].equals(_sField)) continue;
            return this.m_aFieldTypes[i];
        }
        return 0;
    }

    protected boolean listContains(String[] _aList, String _aValue) {
        for (int i = 0; i < _aList.length; ++i) {
            if (!_aList[i].equals(_aValue)) continue;
            return true;
        }
        return false;
    }

    protected String[] getNamesWithoutGroupNames(String[] _aList, String[] _aGetResultFrom) {
        if (_aList == null) {
            return new String[0];
        }
        if (this.getCountOfGroups() == 0) {
            if (_aGetResultFrom != null) {
                return _aGetResultFrom;
            }
            return _aList;
        }
        int nNewLength = _aList.length - this.getCountOfGroups();
        String[] aNewList = new String[nNewLength];
        int j = 0;
        for (int i = 0; i < _aList.length; ++i) {
            String sField = _aList[i];
            if (this.listContains(this.m_aGroupNames, sField)) continue;
            aNewList[j++] = _aGetResultFrom != null ? _aGetResultFrom[i] : sField;
            if (j == nNewLength) break;
        }
        return aNewList;
    }

    protected int calculateFieldWidth(int _nLeftIndent, int _nFieldCount) {
        int nWidth = 3000;
        if (_nFieldCount > 0) {
            nWidth = (this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - _nLeftIndent) / _nFieldCount;
        }
        return nWidth;
    }

    protected String[] getFieldTitleNames() {
        return this.getNamesWithoutGroupNames(this.m_aFieldNames, this.m_aFieldTitleNames);
    }

    protected abstract void insertDetailFieldTitles(int var1);

    public void insertFieldNames(String[] _aFieldNames) {
        this.m_aFieldNames = _aFieldNames;
    }

    public void insertFieldTypes(int[] _aFieldTypes) {
        this.m_aFieldTypes = _aFieldTypes;
    }

    public void insertFieldWidths(int[] _aFieldWidths) {
        this.m_aFieldWidths = _aFieldWidths;
    }

    protected int getCountOfGroups() {
        return this.m_aGroupNames == null ? 0 : this.m_aGroupNames.length;
    }

    protected String[] getFieldNames() {
        return this.getNamesWithoutGroupNames(this.m_aFieldNames, null);
    }

    protected abstract void insertDetailFields();

    protected void copyDetailProperties() {
        if (this.getDesignTemplate() != null) {
            try {
                XSection xForeignSection = this.getDesignTemplate().getDetail();
                if (xForeignSection != null) {
                    XSection xSection = this.getReportDefinition().getDetail();
                    this.copyProperties(xForeignSection, xSection);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected Rectangle insertLabel(XSection _xSection, String _sLabel, Rectangle _aRect, int _nWidth, SectionObject _aSO) {
        if (_xSection != null) {
            try {
                Object aFixedText = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FixedText");
                XFixedText xFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)aFixedText);
                int nHeight = 500;
                if (_aSO != null) {
                    if (_aSO instanceof SectionEmptyObject) {
                        float fCharWeight = _aSO.getCharWeight(100.0f);
                        if (fCharWeight > 0.1f) {
                            xFixedText.setCharWeight(fCharWeight);
                        }
                    } else {
                        FontDescriptor aFD = _aSO.getFontDescriptor();
                        if (aFD != null) {
                            xFixedText.setFontDescriptor(aFD);
                            this.copyProperties(_aSO.getParent(), xFixedText);
                        }
                        nHeight = _aSO.getHeight(500);
                    }
                }
                xFixedText.setLabel(_sLabel);
                xFixedText.setPositionX(_aRect.X);
                xFixedText.setPositionY(_aRect.Y);
                xFixedText.setWidth(_nWidth);
                _aRect.X += _nWidth;
                xFixedText.setHeight(nHeight);
                _xSection.add((XShape)xFixedText);
            }
            catch (com.sun.star.uno.Exception ex) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return _aRect;
    }

    protected String convertToFieldName(String _sElementName) {
        StringBuffer aDataField = new StringBuffer(32);
        aDataField.append("field:[").append(_sElementName).append(']');
        return aDataField.toString();
    }

    protected String convertFromFieldName(String _sName) {
        if (_sName.startsWith("field:[")) {
            int nCloseBrace = _sName.lastIndexOf(93);
            return _sName.substring(7, nCloseBrace).trim();
        }
        return _sName;
    }

    protected Rectangle insertFormattedField(XSection _xSection, String _sFormattedfield, Rectangle _aRect, int _nWidth, SectionObject _aSO) {
        return this.insertFormattedField(_xSection, _sFormattedfield, _aRect, _nWidth, _aSO, (short)0);
    }

    protected Rectangle insertFormattedField(XSection _xSection, String _sFormattedfield, Rectangle _aRect, int _nWidth, SectionObject _aSO, short _nAlignment) {
        block14: {
            if (_xSection != null) {
                try {
                    Object aField;
                    int nHeight = 500;
                    int nType = this.getTypeFromFieldName(this.convertFromFieldName(_sFormattedfield));
                    if (nType == -2 || nType == -3 || nType == -4) {
                        aField = this.getMSFofReportDefinition().createInstance("com.sun.star.report.ImageControl");
                        nHeight = 4000;
                    } else {
                        aField = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FormattedField");
                        nHeight = 500;
                        if (nType == -1) {
                            nHeight = 4000;
                        }
                    }
                    _aRect.Height = nHeight;
                    XReportControlModel xReportControlModel = (XReportControlModel)UnoRuntime.queryInterface(XReportControlModel.class, (Object)aField);
                    if (xReportControlModel == null) break block14;
                    xReportControlModel.setDataField(_sFormattedfield);
                    if (_aSO != null) {
                        FontDescriptor aFD = _aSO.getFontDescriptor();
                        if (aFD != null) {
                            xReportControlModel.setFontDescriptor(aFD);
                            this.copyProperties(_aSO.getParent(), xReportControlModel);
                        }
                        nHeight = _aSO.getHeight(nHeight);
                    }
                    xReportControlModel.setPositionX(_aRect.X);
                    xReportControlModel.setPositionY(_aRect.Y);
                    xReportControlModel.setWidth(_nWidth);
                    _aRect.X += _nWidth;
                    xReportControlModel.setHeight(nHeight);
                    if (nType == -2 || nType == -3 || nType == -4) {
                        XImageControl xImageControl = (XImageControl)UnoRuntime.queryInterface(XImageControl.class, (Object)xReportControlModel);
                        if (xImageControl != null) {
                            xImageControl.setScaleMode((short)1);
                        }
                    } else {
                        try {
                            xReportControlModel.setParaAdjust(_nAlignment);
                        }
                        catch (UnknownPropertyException ex) {
                            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (_sFormattedfield.equals("rpt:now()")) {
                        XFormattedField xFormattedField = (XFormattedField)UnoRuntime.queryInterface(XFormattedField.class, (Object)xReportControlModel);
                        XNumberFormatsSupplier x = xFormattedField.getFormatsSupplier();
                        XNumberFormats xFormats = x.getNumberFormats();
                        XNumberFormatTypes x3 = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)xFormats);
                        java.util.Locale.getDefault();
                        Locale aLocale = new Locale();
                        aLocale.Country = java.util.Locale.getDefault().getCountry();
                        aLocale.Language = java.util.Locale.getDefault().getLanguage();
                        int nFormat = x3.getStandardFormat((short)2, aLocale);
                        xFormattedField.setFormatKey(nFormat);
                    }
                    _xSection.add((XShape)xReportControlModel);
                }
                catch (com.sun.star.uno.Exception ex) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return _aRect;
    }

    public void setTableName(int _aType, String _sTableName) {
        this.m_aCommandType = _aType;
        this.m_sTableName = _sTableName;
        this.getReportDefinition().setCommandType(_aType);
        this.getReportDefinition().setCommand(_sTableName);
    }

    protected XMultiServiceFactory getMSFofReportDefinition() {
        if (this.m_xMSF == null) {
            this.m_xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.getReportDefinition());
        }
        return this.m_xMSF;
    }

    protected Rectangle insertVerticalLine(XSection _xSection, Rectangle _aRect, int _nWidth, int _nHeight) {
        return this.insertLine(_xSection, _aRect, _nWidth, _nHeight, 1);
    }

    protected Rectangle insertHorizontalLine(XSection _xSection, Rectangle _aRect, int _nWidth, int _nHeight) {
        return this.insertLine(_xSection, _aRect, _nWidth, _nHeight, 0);
    }

    protected Rectangle insertLine(XSection _xSection, Rectangle _aRect, int _nWidth, int _nHeight, int _nOrientation) {
        if (_xSection != null) {
            try {
                Object aFixedLine = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FixedLine");
                XFixedLine xFixedLine = (XFixedLine)UnoRuntime.queryInterface(XFixedLine.class, (Object)aFixedLine);
                xFixedLine.setOrientation(_nOrientation);
                xFixedLine.setLineWidth(8);
                xFixedLine.setPositionX(_aRect.X);
                xFixedLine.setPositionY(_aRect.Y);
                xFixedLine.setWidth(_nWidth);
                _aRect.X += _nWidth;
                xFixedLine.setHeight(_nHeight);
                _xSection.add((XShape)xFixedLine);
            }
            catch (com.sun.star.uno.Exception ex) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return _aRect;
    }

    protected void clearReportHeader() {
        try {
            if (this.getReportDefinition().getReportHeaderOn()) {
                XSection xSection = this.getReportDefinition().getReportHeader();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException ex) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void insertReportHeader() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getReportHeaderOn()) {
                try {
                    XSection xForeignSection = this.getDesignTemplate().getReportHeader();
                    if (xForeignSection != null) {
                        this.getReportDefinition().setReportHeaderOn(true);
                        XSection xSection = this.getReportDefinition().getReportHeader();
                        this.copySection(xForeignSection, xSection);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
                }
            } else {
                this.getReportDefinition().setReportHeaderOn(false);
            }
        }
    }

    protected void clearReportFooter() {
        try {
            if (this.getReportDefinition().getReportFooterOn()) {
                XSection xSection = this.getReportDefinition().getReportFooter();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException e) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    protected void insertReportFooter() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getReportFooterOn()) {
                try {
                    XSection xForeignSection = this.getDesignTemplate().getReportFooter();
                    if (xForeignSection != null) {
                        this.getReportDefinition().setReportFooterOn(true);
                        XSection xSection = this.getReportDefinition().getReportFooter();
                        this.copySection(xForeignSection, xSection);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
                }
            } else {
                this.getReportDefinition().setReportFooterOn(false);
            }
        }
    }

    protected void clearPageHeader() {
        try {
            if (this.getReportDefinition().getPageHeaderOn()) {
                XSection xSection = this.getReportDefinition().getPageHeader();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException e) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    protected void clearPageFooter() {
        try {
            if (this.getReportDefinition().getPageFooterOn()) {
                XSection xSection = this.getReportDefinition().getPageFooter();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException e) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void setPageOrientation(int _nOrientation) {
        int nWidth = this.getFromPageStyles(PropertyNames.PROPERTY_WIDTH, 0);
        int nHeight = this.getFromPageStyles(PropertyNames.PROPERTY_HEIGHT, 0);
        if (30 == _nOrientation) {
            this.setToPageStyles("IsLandscape", Boolean.TRUE);
            if (nWidth < nHeight) {
                this.setToPageStyles(PropertyNames.PROPERTY_WIDTH, nHeight);
                this.setToPageStyles(PropertyNames.PROPERTY_HEIGHT, nWidth);
            }
        } else {
            this.setToPageStyles("IsLandscape", Boolean.FALSE);
            if (nHeight < nWidth) {
                this.setToPageStyles(PropertyNames.PROPERTY_WIDTH, nHeight);
                this.setToPageStyles(PropertyNames.PROPERTY_HEIGHT, nWidth);
            }
        }
        this.m_nPageWidth = -1;
    }

    Size getPreferredSize(String _sText, FontDescriptor _aFont) {
        Size aSizeMM_100TH = new Size(0, 0);
        try {
            Object aFixedTextModel = this.getGlobalMSF().createInstance("com.sun.star.awt.UnoControlFixedTextModel");
            XControlModel xFixedTextModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)aFixedTextModel);
            PropertySetHelper aPropertySetHelper = new PropertySetHelper(xFixedTextModel);
            aPropertySetHelper.setPropertyValueDontThrow(PropertyNames.FONT_DESCRIPTOR, _aFont);
            Object aUnoCtrlFixedText = this.getGlobalMSF().createInstance("com.sun.star.awt.UnoControlFixedText");
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)aUnoCtrlFixedText);
            xWindow.setVisible(false);
            XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)aUnoCtrlFixedText);
            xControl.setModel(xFixedTextModel);
            com.sun.star.awt.XFixedText xFixedText = (com.sun.star.awt.XFixedText)UnoRuntime.queryInterface(com.sun.star.awt.XFixedText.class, (Object)aUnoCtrlFixedText);
            xFixedText.setText(_sText);
            XLayoutConstrains xLayoutConstraints = (XLayoutConstrains)UnoRuntime.queryInterface(XLayoutConstrains.class, (Object)aUnoCtrlFixedText);
            Size aSizeInPixel = xLayoutConstraints.getPreferredSize();
            XWindowPeer xPeerOfReportDefinition = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.getReportDefinition().getCurrentController().getFrame().getComponentWindow());
            xControl.createPeer(null, xPeerOfReportDefinition);
            XWindowPeer x = xControl.getPeer();
            XUnitConversion xConversion = (XUnitConversion)UnoRuntime.queryInterface(XUnitConversion.class, (Object)x);
            aSizeMM_100TH = xConversion.convertSizeToLogic(aSizeInPixel, (short)0);
            XComponent xFixedTextDeleter = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xFixedText);
            xFixedTextDeleter.dispose();
            XComponent xFixedTextModelDeleter = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)aFixedTextModel);
            xFixedTextModelDeleter.dispose();
        }
        catch (Exception e) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
        }
        return aSizeMM_100TH;
    }

    protected String getTableName() {
        if (this.m_sTableName != null) {
            return this.m_sTableName;
        }
        return PropertyNames.EMPTY_STRING;
    }

    protected String getUserNameFromConfiguration() {
        String sFirstName = PropertyNames.EMPTY_STRING;
        String sLastName = PropertyNames.EMPTY_STRING;
        try {
            Object oProdNameAccess = Configuration.getConfigurationRoot(this.getGlobalMSF(), "org.openoffice.UserProfile/Data", false);
            sFirstName = (String)Helper.getUnoObjectbyName(oProdNameAccess, "givenname");
            sLastName = (String)Helper.getUnoObjectbyName(oProdNameAccess, "sn");
        }
        catch (Exception e) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
        }
        return sFirstName + PropertyNames.SPACE + sLastName;
    }

    private void copyProperties(Object _aFrom, Object _aTo) {
        XPropertySet xFrom = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_aFrom);
        XPropertySet xTo = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_aTo);
        XPropertySetInfo xForeignPropInfo = xFrom.getPropertySetInfo();
        XPropertySetInfo xSectionPropInfo = xTo.getPropertySetInfo();
        Property[] aAllProperties = xForeignPropInfo.getProperties();
        for (int i = 0; i < aAllProperties.length; ++i) {
            String sPropertyName = aAllProperties[i].Name;
            if (!xSectionPropInfo.hasPropertyByName(sPropertyName)) continue;
            try {
                Property aDestProp = xForeignPropInfo.getPropertyByName(sPropertyName);
                if ((aDestProp.Attributes & 0x10) != 0) continue;
                xTo.setPropertyValue(sPropertyName, xFrom.getPropertyValue(sPropertyName));
                continue;
            }
            catch (Exception e) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    private void copySection(XSection _xFromSection, XSection _xToSection) {
        this.copyProperties(_xFromSection, _xToSection);
        try {
            XEnumeration xEnum = _xFromSection.createEnumeration();
            while (xEnum.hasMoreElements()) {
                XCloneable aClone;
                Object aEnumObj = xEnum.nextElement();
                XReportComponent aComponent = (XReportComponent)UnoRuntime.queryInterface(XReportComponent.class, (Object)aEnumObj);
                if (aComponent == null || (aClone = aComponent.createClone()) == null) continue;
                XShape aShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)aClone);
                this.copyProperties(aComponent, aClone);
                _xToSection.add(aShape);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    protected void insertPageHeader() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getPageHeaderOn()) {
                try {
                    XSection xForeignSection = this.getDesignTemplate().getPageHeader();
                    if (xForeignSection != null) {
                        this.getReportDefinition().setPageHeaderOn(true);
                        XSection xSection = this.getReportDefinition().getPageHeader();
                        this.copySection(xForeignSection, xSection);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
                }
            } else {
                this.getReportDefinition().setPageHeaderOn(false);
            }
        } else {
            if (this.getReportDefinition() == null) {
                return;
            }
            String sTitleTitle = this.getResource().getResText(2486);
            String sTitle = this.getTableName();
            String sAuthorTitle = this.getResource().getResText(2487);
            String sAuthor = this.getUserNameFromConfiguration();
            String sDateTitle = this.getResource().getResText(2488);
            String sDate = "rpt:now()";
            try {
                this.getReportDefinition().setPageHeaderOn(true);
                XSection xSection = null;
                xSection = this.getReportDefinition().getPageHeader();
                Rectangle aRect = new Rectangle();
                aRect.X = this.getLeftPageIndent();
                SectionObject aSOLabel = SectionEmptyObject.create();
                aSOLabel.setFontToBold();
                aRect.Y = aSOLabel.getHeight(500);
                int nWidth = 3000;
                aRect = this.insertLabel(xSection, sTitleTitle, aRect, 3000, aSOLabel);
                int nTitleWidth = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - 3000;
                aRect = this.insertLabel(xSection, sTitle, aRect, nTitleWidth, aSOLabel);
                aRect.Y += aSOLabel.getHeight(500) + 250;
                aRect.X = this.getLeftPageIndent();
                aRect = this.insertLabel(xSection, sAuthorTitle, aRect, 3000, aSOLabel);
                aRect = this.insertLabel(xSection, sAuthor, aRect, nTitleWidth, aSOLabel);
                aRect.Y += aSOLabel.getHeight(500);
                aRect.X = this.getLeftPageIndent();
                aRect = this.insertLabel(xSection, sDateTitle, aRect, 3000, aSOLabel);
                aRect = this.insertFormattedField(xSection, "rpt:now()", aRect, nTitleWidth, aSOLabel);
                aRect.Y += aSOLabel.getHeight(500) + 250;
                aRect.X = this.getLeftPageIndent();
                int nLineWidth = this.getPageWidth() - this.getRightPageIndent() - aRect.X;
                int nLineHeight = 250;
                this.insertHorizontalLine(xSection, aRect, nLineWidth, 250);
                aRect.Y += 250;
                xSection.setHeight(aRect.Y);
            }
            catch (com.sun.star.uno.Exception e) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    protected void insertPageFooter() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getPageFooterOn()) {
                try {
                    XSection xForeignSection = this.getDesignTemplate().getPageFooter();
                    if (xForeignSection != null) {
                        this.getReportDefinition().setPageFooterOn(true);
                        XSection xSection = this.getReportDefinition().getPageFooter();
                        this.copySection(xForeignSection, xSection);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
                }
            } else {
                this.getReportDefinition().setPageFooterOn(false);
            }
        } else {
            if (this.getReportDefinition() == null) {
                return;
            }
            String sPageOf = this.getResource().getResText(2489);
            String sSurroundDoubleQuotes = "\"" + sPageOf + "\"";
            String sPageNumber = sSurroundDoubleQuotes.replaceAll("#page#", "\" & PageNumber() & \"");
            String sPageCount = sPageNumber.replaceAll("#count#", "\" & PageCount() & \"");
            String sNoLastUnusedQuotes = sPageCount.replaceAll(" & \\\"\\\"", PropertyNames.EMPTY_STRING);
            String sNoFirstUnusedQuotes = sNoLastUnusedQuotes.replaceAll("\\\"\\\" & ", PropertyNames.EMPTY_STRING);
            int nUsablePageWidth = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent();
            try {
                this.getReportDefinition().setPageFooterOn(true);
                XSection xSection = null;
                xSection = this.getReportDefinition().getPageFooter();
                Rectangle aRect = new Rectangle();
                aRect.X = this.getLeftPageIndent();
                int nLineWidth = this.getPageWidth() - this.getRightPageIndent() - aRect.X;
                int nLineHeight = 250;
                this.insertHorizontalLine(xSection, aRect, nLineWidth, 250);
                aRect.Y += 250;
                aRect.Y += 500;
                aRect.X = this.getLeftPageIndent();
                aRect = this.insertFormattedField(xSection, "rpt:" + sNoFirstUnusedQuotes, aRect, nUsablePageWidth, null, (short)1);
                aRect.Y += 750;
                xSection.setHeight(aRect.Y);
            }
            catch (Exception e) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    protected Resource getResource() {
        return this.m_aResource;
    }

    public void initializeData(IReportBuilderLayouter _aOther) {
        if (_aOther instanceof ReportBuilderLayouter) {
            ReportBuilderLayouter aOther = (ReportBuilderLayouter)_aOther;
            this.m_aCommandType = aOther.m_aCommandType;
            this.m_sTableName = aOther.m_sTableName;
            this.m_aGroupNames = aOther.m_aGroupNames;
            this.m_aFieldNames = aOther.m_aFieldNames;
            this.m_aFieldTitleNames = aOther.m_aFieldTitleNames;
            this.m_aFieldWidths = aOther.m_aFieldWidths;
            this.m_aFieldTypes = aOther.m_aFieldTypes;
            this.m_xDesignTemplate = aOther.m_xDesignTemplate;
            this.m_nPageWidth = -1;
        }
    }

    protected int getMaxLabelWidth() {
        int i;
        int nWidth = 0;
        String[] aFieldTitles = this.m_aFieldTitleNames;
        for (i = 0; i < aFieldTitles.length; ++i) {
            String sLabel = aFieldTitles[i];
            nWidth = Math.max(nWidth, this.getLabelWidth(sLabel));
        }
        for (i = 0; i < this.m_aGroupNames.length; ++i) {
            String sGroupName = this.m_aGroupNames[i];
            SectionObject a = this.getDesignTemplate().getGroupLabel(i);
            FontDescriptor aFD = a.getFontDescriptor();
            nWidth = Math.max(nWidth, this.getLabelWidth(sGroupName, aFD));
        }
        nWidth = nWidth == 0 ? 3000 : (nWidth += 500);
        return nWidth;
    }

    protected int getLabelWidth(String _sLabel) {
        return this.getLabelWidth(_sLabel, 0.0f, 0.0f);
    }

    protected int getLabelWidth(String _sLabel, FontDescriptor _aFD) {
        float fCharWeight = 0.0f;
        float fCharHeight = 0.0f;
        if (_aFD != null) {
            fCharWeight = _aFD.Weight;
            fCharHeight = _aFD.Height;
        }
        return this.getLabelWidth(_sLabel, fCharWeight, fCharHeight);
    }

    protected int getLabelWidth(String _sLabel, float _nCharWeight, float _nCharHeight) {
        StringBuffer aKey;
        String sKey;
        int nWidth = 0;
        if (this.m_aLabelWidthMap == null) {
            this.m_aLabelWidthMap = new HashMap();
        }
        if (this.m_aLabelWidthMap.containsKey(sKey = (aKey = new StringBuffer(40)).append(_sLabel).append(_nCharWeight).append(_nCharHeight).toString())) {
            Integer aWidth;
            Integer aIntegerWidth = aWidth = this.m_aLabelWidthMap.get(sKey);
            nWidth = aIntegerWidth;
        } else {
            try {
                if (this.m_aFixedTextHelper == null) {
                    Object aFixedText = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FixedText");
                    this.m_aFixedTextHelper = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)aFixedText);
                }
                this.m_aFixedTextHelper.setLabel(_sLabel);
                if (_nCharWeight > 0.1f) {
                    this.m_aFixedTextHelper.setCharWeight(_nCharWeight);
                }
                if (_nCharHeight > 0.1f) {
                    this.m_aFixedTextHelper.setCharHeight(_nCharHeight);
                }
                FontDescriptor xFont = this.m_aFixedTextHelper.getFontDescriptor();
                Size aSize = this.getPreferredSize(_sLabel, xFont);
                nWidth = aSize.Width;
                this.m_aLabelWidthMap.put(sKey, nWidth);
            }
            catch (com.sun.star.uno.Exception e) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        return nWidth;
    }

    protected void doNotBreakInTable(Object _xSectionOrGroup) {
        PropertySetHelper aHelper = new PropertySetHelper(_xSectionOrGroup);
        aHelper.setPropertyValueDontThrow("KeepTogether", Boolean.TRUE);
    }

    protected DesignTemplate getDesignTemplate() {
        if (this.m_xDesignTemplate == null) {
            String sDefaultHeaderLayout = this.m_xReportDefinitionReadAccess.getDefaultHeaderLayout();
            this.loadAndSetBackgroundTemplate(sDefaultHeaderLayout);
        }
        return this.m_xDesignTemplate;
    }

    private void closeDesignTemplate() {
        if (this.m_xDesignTemplate != null) {
            this.m_xDesignTemplate.close();
            this.m_xDesignTemplate = null;
        }
    }

    public void loadAndSetBackgroundTemplate(String LayoutTemplatePath) {
        this.closeDesignTemplate();
        String sName = FileAccess.getFilename(LayoutTemplatePath);
        if (!sName.equalsIgnoreCase("default.otr_") && !LayoutTemplatePath.equals("DefaultLayoutOfHeaders")) {
            XMultiServiceFactory xMSF = this.getGlobalMSF();
            this.m_xDesignTemplate = DesignTemplate.create(xMSF, LayoutTemplatePath);
        }
    }
}

