/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.beans.Property;
import com.sun.star.comp.Calc.NLPSolver.ResourceManager;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.resource.MissingResourceException;
import com.sun.star.uno.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfo<PropType> {
    private Property m_property = new Property();
    private PropType m_value;
    private String m_description;

    public Property getProperty() {
        return this.m_property;
    }

    public PropType getValue() {
        return this.m_value;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (this.m_property.Type == Type.LONG) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            this.m_value = value;
        } else if (this.m_property.Type == Type.DOUBLE) {
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException();
            }
            this.m_value = value;
        } else if (this.m_property.Type == Type.BOOLEAN) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            this.m_value = value;
        }
    }

    public PropertyInfo(String name, PropType value, String description) {
        this(name, value, 0, description);
    }

    private PropertyInfo(String name, PropType value, short attributes, String description) {
        this.m_property.Name = name;
        this.m_property.Attributes = attributes;
        this.m_property.Handle = -1;
        if (value instanceof Integer) {
            this.m_property.Type = Type.LONG;
        } else if (value instanceof Double) {
            this.m_property.Type = Type.DOUBLE;
        } else if (value instanceof Boolean) {
            this.m_property.Type = Type.BOOLEAN;
        }
        this.m_value = value;
        this.m_description = description;
    }

    public void localize(ResourceManager resourceManager) {
        try {
            this.m_description = resourceManager.getLocalizedString("Properties." + this.m_property.Name);
            System.out.println("Localised description to " + this.m_description);
        }
        catch (MissingResourceException ex) {
            System.out.println("No properties file !");
        }
    }
}

