/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.awt.XComboBox;
import com.sun.star.awt.XListBox;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.event.UnoDataAware;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListModelBinder
implements ListDataListener {
    private final XListBox unoList;
    private final Object unoListModel;
    private ListModel listModel;
    private final Renderer renderer = new Renderer(){

        public String render(Object item) {
            if (item == null) {
                return PropertyNames.EMPTY_STRING;
            }
            return item.toString();
        }
    };

    public ListModelBinder(Object unoListBox, ListModel listModel_) {
        this.unoList = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)unoListBox);
        this.unoListModel = UnoDataAware.getModel(unoListBox);
        this.setListModel(listModel_);
    }

    public void setListModel(ListModel newListModel) {
        if (this.listModel != null) {
            this.listModel.removeListDataListener(this);
        }
        this.listModel = newListModel;
        this.listModel.addListDataListener(this);
    }

    public void contentsChanged(ListDataEvent lde) {
        short[] selected = this.getSelectedItems();
        for (short i = (short)lde.getIndex0(); i <= lde.getIndex1(); i = (short)(i + 1)) {
            this.update(i);
        }
        this.setSelectedItems(selected);
    }

    protected void update(short i) {
        this.remove(i, i);
        this.insert(i);
    }

    protected void remove(short i1, short i2) {
        this.unoList.removeItems(i1, (short)(i2 - i1 + 1));
    }

    protected void insert(short i) {
        this.unoList.addItem(this.getItemString(i), i);
    }

    protected String getItemString(short i) {
        return this.getItemString(this.listModel.getElementAt(i));
    }

    protected String getItemString(Object item) {
        return this.renderer.render(item);
    }

    protected short[] getSelectedItems() {
        return (short[])Helper.getUnoPropertyValue(this.unoListModel, PropertyNames.SELECTED_ITEMS);
    }

    protected void setSelectedItems(short[] selected) {
        Helper.setUnoPropertyValue(this.unoListModel, PropertyNames.SELECTED_ITEMS, selected);
    }

    public void intervalAdded(ListDataEvent lde) {
        for (short i = (short)lde.getIndex0(); i <= lde.getIndex1(); i = (short)(i + 1)) {
            this.insert(i);
        }
    }

    public void intervalRemoved(ListDataEvent lde) {
        this.remove((short)lde.getIndex0(), (short)lde.getIndex1());
    }

    public static void fillList(Object list, Object[] items, Renderer renderer) {
        XListBox xlist = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)list);
        Helper.setUnoPropertyValue(UnoDataAware.getModel(list), PropertyNames.STRING_ITEM_LIST, new String[0]);
        for (short i = 0; i < items.length; i = (short)((short)(i + 1))) {
            if (items[i] == null) continue;
            xlist.addItem(renderer != null ? renderer.render(items[i]) : items[i].toString(), i);
        }
    }

    public static void fillComboBox(Object list, Object[] items, Renderer renderer) {
        XComboBox xComboBox = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)list);
        Helper.setUnoPropertyValue(UnoDataAware.getModel(list), PropertyNames.STRING_ITEM_LIST, new String[0]);
        for (short i = 0; i < items.length; i = (short)((short)(i + 1))) {
            if (items[i] == null) continue;
            xComboBox.addItem(renderer != null ? renderer.render(items[i]) : items[i].toString(), i);
        }
    }

    public static interface Renderer {
        public String render(Object var1);
    }
}

