/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.uno.Any;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.event.DataAware;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAwareFields {
    private static final String TRUE = "true";

    public static DataAware.Value getFieldValueFor(Object owner, String fieldname, Object value) {
        try {
            Field f = owner.getClass().getField(fieldname);
            Class<?> c = f.getType();
            Class<?> c2 = value.getClass();
            if (c.equals(Boolean.TYPE)) {
                return new BooleanFieldValue(f, c2);
            }
            if (c.equals(Integer.TYPE)) {
                return new IntFieldValue(f, c2);
            }
            if (c.equals(Double.TYPE)) {
                return new DoubleFieldValue(f, c2);
            }
            if (c.equals(String.class) && c2.equals(Integer.class)) {
                return new ConvertedStringValue(f, c2);
            }
            return new SimpleFieldValue(f);
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static double toDouble(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof short[]) {
            return ((short[])value).length == 0 ? 0.0 : (double)((short[])value)[0];
        }
        throw new IllegalArgumentException("Can't convert value to double." + value.getClass().getName());
    }

    private static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return value.equals(TRUE);
        }
        if (value instanceof short[]) {
            return ((short[])value).length != 0 && ((short[])value)[0] != 0;
        }
        throw new IllegalArgumentException("Can't convert value to boolean." + value.getClass().getName());
    }

    private static int toInt(boolean b) {
        return b ? 1 : 0;
    }

    private static short[] toShortArray(double i) {
        return new short[]{(short)i};
    }

    private static Number toNumber(double i, Class<?> c) {
        if (c.equals(Integer.class)) {
            return (int)i;
        }
        if (c.equals(Short.class)) {
            return (short)i;
        }
        if (c.equals(Double.class)) {
            return new Double(i);
        }
        throw new IllegalArgumentException("Cannot convert to the given Number type.");
    }

    private static class SimpleFieldValue
    extends FieldValue {
        public SimpleFieldValue(Field f) {
            super(f);
        }

        public Object get(Object target) {
            try {
                if (target == null) {
                    if (this.field.getType().equals(String.class)) {
                        return PropertyNames.EMPTY_STRING;
                    }
                    if (this.field.getType().equals(Short.class)) {
                        return (short)0;
                    }
                    if (this.field.getType().equals(Integer.class)) {
                        return 0;
                    }
                    if (this.field.getType().equals(short[].class)) {
                        return new short[0];
                    }
                    return null;
                }
                return this.field.get(target);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public void set(Object value, Object target) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertedStringValue
    extends FieldValue {
        private final Class<?> convertTo;

        public ConvertedStringValue(Field f, Class<?> convertTo_) {
            super(f);
            this.convertTo = convertTo_;
        }

        @Override
        public Object get(Object target) {
            try {
                String s = (String)this.field.get(target);
                if (this.convertTo.equals(Boolean.class)) {
                    return s != null && !s.equals(PropertyNames.EMPTY_STRING) && s.equals(DataAwareFields.TRUE) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (this.convertTo.equals(Integer.class)) {
                    if (s == null || s.equals(PropertyNames.EMPTY_STRING)) {
                        return Any.VOID;
                    }
                    return Integer.valueOf(s);
                }
                if (this.convertTo.equals(Double.class)) {
                    if (s == null || s.equals(PropertyNames.EMPTY_STRING)) {
                        return Any.VOID;
                    }
                    return new Double(s);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object value, Object target) {
            try {
                this.field.set(target, value == null || value.equals(Any.VOID) ? PropertyNames.EMPTY_STRING : value.toString());
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleFieldValue
    extends FieldValue {
        private final Class<?> convertTo;

        public DoubleFieldValue(Field f, Class<?> convertTo_) {
            super(f);
            this.convertTo = convertTo_;
        }

        @Override
        public Object get(Object target) {
            try {
                double d = this.field.getDouble(target);
                if (this.convertTo.equals(Boolean.class)) {
                    return d != 0.0 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(d, this.convertTo);
                }
                if (this.convertTo.equals(String.class)) {
                    return String.valueOf(d);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(d);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object value, Object target) {
            try {
                this.field.setDouble(target, DataAwareFields.toDouble(value));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntFieldValue
    extends FieldValue {
        private final Class<?> convertTo;

        public IntFieldValue(Field f, Class<?> convertTo_) {
            super(f);
            this.convertTo = convertTo_;
        }

        @Override
        public Object get(Object target) {
            try {
                int i = this.field.getInt(target);
                if (this.convertTo.equals(Boolean.class)) {
                    return i != 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(i, this.convertTo);
                }
                if (this.convertTo.equals(String.class)) {
                    return String.valueOf(i);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(i);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object value, Object target) {
            try {
                this.field.setInt(target, (int)DataAwareFields.toDouble(value));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanFieldValue
    extends FieldValue {
        private final Class<?> convertTo;

        public BooleanFieldValue(Field f, Class<?> convertTo_) {
            super(f);
            this.convertTo = convertTo_;
        }

        @Override
        public Object get(Object target) {
            try {
                boolean b = this.field.getBoolean(target);
                if (this.convertTo.equals(Boolean.class)) {
                    return b ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(b ? 1.0 : 0.0, this.convertTo);
                }
                if (this.convertTo.equals(String.class)) {
                    return String.valueOf(b);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(DataAwareFields.toInt(b));
                }
                throw new IllegalArgumentException("Cannot convert boolean value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public void set(Object value, Object target) {
            try {
                this.field.setBoolean(target, DataAwareFields.toBoolean(value));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FieldValue
    implements DataAware.Value {
        Field field;

        public FieldValue(Field field_) {
            this.field = field_;
        }

        @Override
        public boolean isAssignable(Class<?> type) {
            return this.field.getDeclaringClass().isAssignableFrom(type);
        }
    }
}

