/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.wizards.common.PropertyNames;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataAware {
    protected Object dataObject;
    protected Value value;

    protected DataAware(Object dataObject_, Value value_) {
        this.dataObject = dataObject_;
        this.value = value_;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object obj, boolean updateUI) {
        if (obj != null && !this.value.isAssignable(obj.getClass())) {
            throw new ClassCastException("can not cast new DataObject to original Class");
        }
        this.dataObject = obj;
        if (updateUI) {
            this.updateUI();
        }
    }

    protected void setToData(Object newValue) {
        this.value.set(newValue, this.getDataObject());
    }

    protected Object getFromData() {
        return this.value.get(this.getDataObject());
    }

    protected abstract void setToUI(Object var1);

    protected abstract Object getFromUI();

    public void updateUI() {
        Object ui;
        Object data = this.getFromData();
        if (!this.equals(data, ui = this.getFromUI())) {
            try {
                this.setToUI(data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.enableControls(data);
    }

    protected void enableControls(Object currentValue) {
    }

    public void updateData() {
        Object ui;
        Object data = this.getFromData();
        if (!this.equals(data, ui = this.getFromUI())) {
            this.setToData(ui);
        }
        this.enableControls(ui);
    }

    protected boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass().isArray()) {
            if (b.getClass().isArray()) {
                return Arrays.equals((short[])a, (short[])b);
            }
            return false;
        }
        return a.equals(b);
    }

    public static void updateUI(Collection<DataAware> dataAwares) {
        Iterator<DataAware> i = dataAwares.iterator();
        while (i.hasNext()) {
            i.next().updateUI();
        }
    }

    public static void updateData(Collection<DataAware> dataAwares) {
        Iterator<DataAware> i = dataAwares.iterator();
        while (i.hasNext()) {
            i.next().updateData();
        }
    }

    public static void setDataObject(Collection<DataAware> dataAwares, Object dataObject, boolean updateUI) {
        Iterator<DataAware> i = dataAwares.iterator();
        while (i.hasNext()) {
            i.next().setDataObject(dataObject, updateUI);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyValue
    implements Value {
        private final Method getMethod;
        private final Method setMethod;

        public PropertyValue(String propertyName, Object propertyOwner) {
            this.getMethod = this.createGetMethod(propertyName, propertyOwner);
            this.setMethod = this.createSetMethod(propertyName, propertyOwner, this.getMethod.getReturnType());
        }

        protected Method createGetMethod(String propName, Object obj) {
            Method m = null;
            try {
                m = obj.getClass().getMethod("get" + propName, new Class[0]);
            }
            catch (NoSuchMethodException ex1) {
                throw new IllegalArgumentException("get" + propName + "() method does not exist on " + obj.getClass().getName());
            }
            return m;
        }

        @Override
        public Object get(Object target) {
            block7: {
                try {
                    return this.getMethod.invoke(target, new Object[0]);
                }
                catch (IllegalAccessException ex1) {
                    ex1.printStackTrace();
                }
                catch (InvocationTargetException ex2) {
                    ex2.printStackTrace();
                }
                catch (NullPointerException npe) {
                    if (this.getMethod.getReturnType().equals(String.class)) {
                        return PropertyNames.EMPTY_STRING;
                    }
                    if (this.getMethod.getReturnType().equals(Short.class)) {
                        return (short)0;
                    }
                    if (this.getMethod.getReturnType().equals(Integer.class)) {
                        return 0;
                    }
                    if (!this.getMethod.getReturnType().equals(short[].class)) break block7;
                    return new short[0];
                }
            }
            return null;
        }

        protected Method createSetMethod(String propName, Object obj, Class<?> paramClass) {
            Method m = null;
            try {
                m = obj.getClass().getMethod("set" + propName, paramClass);
            }
            catch (NoSuchMethodException ex1) {
                throw new IllegalArgumentException("set" + propName + "(" + this.getMethod.getReturnType().getName() + ") method does not exist on " + obj.getClass().getName());
            }
            return m;
        }

        @Override
        public void set(Object value, Object target) {
            try {
                this.setMethod.invoke(target, value);
            }
            catch (IllegalAccessException ex1) {
                ex1.printStackTrace();
            }
            catch (InvocationTargetException ex2) {
                ex2.printStackTrace();
            }
        }

        @Override
        public boolean isAssignable(Class<?> type) {
            return this.getMethod.getDeclaringClass().isAssignableFrom(type) && this.setMethod.getDeclaringClass().isAssignableFrom(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Value {
        public Object get(Object var1);

        public void set(Object var1, Object var2);

        public boolean isAssignable(Class<?> var1);
    }

    public static interface Listener {
        public void eventPerformed(Object var1);
    }
}

