/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.awt.XControl;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.ui.event.MethodInvocation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class AbstractListener {
    private final HashMap<String, MethodInvocation> mHashtable = new HashMap();

    public void add(String componentName, String eventName, String methodName, Object target) {
        try {
            this.add(componentName, eventName, new MethodInvocation(methodName, target));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(String componentName, String eventName, MethodInvocation mi) {
        this.mHashtable.put(componentName + eventName, mi);
    }

    public MethodInvocation get(String componentName, String eventName) {
        return this.mHashtable.get(componentName + eventName);
    }

    public Object invoke(String componentName, String eventName, Object param) {
        try {
            MethodInvocation mi = this.get(componentName, eventName);
            if (mi != null) {
                return mi.invoke(param);
            }
            return null;
        }
        catch (InvocationTargetException ite) {
            System.out.println("=======================================================");
            System.out.println("=== Note: An Exception was thrown which should have ===");
            System.out.println("=== caused a crash. I caught it. Please report this ===");
            System.out.println("=== to https://www.libreoffice.org/get-help/bug/    ===");
            System.out.println("=======================================================");
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("=======================================================");
            System.out.println("=== Note: An Exception was thrown which should have ===");
            System.out.println("=== caused a crash. I caught it. Please report this ===");
            System.out.println("=== to https://www.libreoffice.org/get-help/bug/    ===");
            System.out.println("=======================================================");
            ex.printStackTrace();
        }
        return null;
    }

    public static String getEventSourceName(EventObject eventObject) {
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)eventObject.Source);
        return (String)Helper.getUnoPropertyValue(xControl.getModel(), PropertyNames.PROPERTY_NAME, String.class);
    }
}

