/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.XTextComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.XPathSelectionListener;

public class PathSelection {
    UnoDialog2 CurUnoDialog;
    XMultiServiceFactory xMSF;
    int iDialogType;
    int iTransferMode;
    public String sDefaultDirectory = PropertyNames.EMPTY_STRING;
    public String sDefaultName = PropertyNames.EMPTY_STRING;
    public String sDefaultFilter = PropertyNames.EMPTY_STRING;
    public boolean usedPathPicker = false;
    public XPathSelectionListener xAction;
    public XTextComponent xSaveTextBox;

    public PathSelection(XMultiServiceFactory xMSF, UnoDialog2 CurUnoDialog, int TransferMode2, int DialogType) {
        this.CurUnoDialog = CurUnoDialog;
        this.xMSF = xMSF;
        this.iDialogType = DialogType;
        this.iTransferMode = TransferMode2;
    }

    public void insert(int DialogStep, int XPos, int YPos, int Width, short CurTabIndex, String LabelText, boolean Enabled, String TxtHelpURL, String BtnHelpURL) {
        this.CurUnoDialog.insertControlModel("com.sun.star.awt.UnoControlFixedTextModel", "lblSaveAs", new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{Enabled, 8, LabelText, XPos, YPos, DialogStep, CurTabIndex, Width});
        this.xSaveTextBox = this.CurUnoDialog.insertTextField("txtSavePath", "callXPathSelectionListener", this, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{Enabled, 12, TxtHelpURL, XPos, YPos + 10, DialogStep, (short)(CurTabIndex + 1), Width - 26});
        this.CurUnoDialog.setControlProperty("txtSavePath", PropertyNames.PROPERTY_ENABLED, Boolean.FALSE);
        this.CurUnoDialog.insertButton("cmdSelectPath", "triggerPathPicker", this, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{Enabled, 14, BtnHelpURL, "...", XPos + Width - 16, YPos + 9, DialogStep, (short)(CurTabIndex + 2), 16});
    }

    public void addSelectionListener(XPathSelectionListener xAction) {
        this.xAction = xAction;
    }

    public String getSelectedPath() {
        return this.xSaveTextBox.getText();
    }

    public void initializePath() {
        try {
            FileAccess myFA = new FileAccess(this.xMSF);
            this.xSaveTextBox.setText(myFA.getPath(this.sDefaultDirectory + "/" + this.sDefaultName, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void triggerPathPicker() {
        try {
            block1 : switch (this.iTransferMode) {
                case 0: {
                    switch (this.iDialogType) {
                        case 0: {
                            break block1;
                        }
                        case 1: {
                            this.usedPathPicker = true;
                            SystemDialog myFilePickerDialog = SystemDialog.createStoreDialog(this.xMSF);
                            myFilePickerDialog.callStoreDialog(this.sDefaultDirectory, this.sDefaultName, this.sDefaultFilter);
                            String sStorePath = myFilePickerDialog.sStorePath;
                            if (sStorePath == null) break block1;
                            FileAccess myFA = new FileAccess(this.xMSF);
                            this.xSaveTextBox.setText(myFA.getPath(sStorePath, null));
                            this.sDefaultDirectory = FileAccess.getParentDir(sStorePath);
                            this.sDefaultName = FileAccess.getFilename(sStorePath);
                            break block1;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.iDialogType) {
                        case 0: {
                            break block1;
                        }
                        case 1: {
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callXPathSelectionListener() {
        if (this.xAction != null) {
            this.xAction.validatePath();
        }
    }

    public static class TransferMode {
        public static final int SAVE = 0;
        public static final int LOAD = 1;
    }

    public static class DialogTypes {
        public static final int FOLDER = 0;
        public static final int FILE = 1;
    }
}

