/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.XUpdatable;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class TextFieldHandler {
    public XTextFieldsSupplier xTextFieldsSupplier;
    private final XMultiServiceFactory xMSFDoc;

    public TextFieldHandler(XMultiServiceFactory xMSF, XTextDocument xTextDocument) {
        this.xMSFDoc = xMSF;
        this.xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)xTextDocument);
    }

    public void refreshTextFields() {
        XRefreshable xUp = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)this.xTextFieldsSupplier.getTextFields());
        xUp.refresh();
    }

    public String getUserFieldContent(XTextCursor xTextCursor) {
        try {
            XTextRange xTextRange = xTextCursor.getEnd();
            Object oTextField = Helper.getUnoPropertyValue(xTextRange, "TextField");
            if (AnyConverter.isVoid((Object)oTextField)) {
                return PropertyNames.EMPTY_STRING;
            }
            XDependentTextField xDependent = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)oTextField);
            XPropertySet xMaster = xDependent.getTextFieldMaster();
            return (String)xMaster.getPropertyValue("Content");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
    }

    public void insertUserField(XTextCursor xTextCursor, String FieldName, String FieldTitle) {
        try {
            XInterface xField = (XInterface)this.xMSFDoc.createInstance("com.sun.star.text.TextField.User");
            XDependentTextField xDepField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)xField);
            XTextContent xFieldContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xField);
            if (this.xTextFieldsSupplier.getTextFieldMasters().hasByName("com.sun.star.text.FieldMaster.User." + FieldName)) {
                Object oMaster = this.xTextFieldsSupplier.getTextFieldMasters().getByName("com.sun.star.text.FieldMaster.User." + FieldName);
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)oMaster);
                xComponent.dispose();
            }
            XPropertySet xPSet = this.createUserField(FieldName, FieldTitle);
            xDepField.attachTextFieldMaster(xPSet);
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, xFieldContent, false);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public XPropertySet createUserField(String FieldName, String FieldTitle) throws Exception {
        Object oMaster = this.xMSFDoc.createInstance("com.sun.star.text.FieldMaster.User");
        XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oMaster);
        xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)FieldName);
        xPSet.setPropertyValue("Content", (Object)FieldTitle);
        return xPSet;
    }

    private XDependentTextField[] getTextFieldsByProperty(String _PropertyName, Object _aPropertyValue, String _TypeName) {
        try {
            ArrayList<XDependentTextField> xDependentVector = new ArrayList<XDependentTextField>();
            if (this.xTextFieldsSupplier.getTextFields().hasElements()) {
                XEnumeration xEnum = this.xTextFieldsSupplier.getTextFields().createEnumeration();
                while (xEnum.hasMoreElements()) {
                    Object oTextField = xEnum.nextElement();
                    XDependentTextField xDependent = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)oTextField);
                    XPropertySet xPropertySet = xDependent.getTextFieldMaster();
                    if (!xPropertySet.getPropertySetInfo().hasPropertyByName(_PropertyName)) continue;
                    Object oValue = xPropertySet.getPropertyValue(_PropertyName);
                    if (AnyConverter.isString((Object)oValue)) {
                        String sValue;
                        if (!_TypeName.equals("String") || !(sValue = AnyConverter.toString((Object)oValue)).equals(_aPropertyValue)) continue;
                        xDependentVector.add(xDependent);
                        continue;
                    }
                    if (!AnyConverter.isShort((Object)oValue) || !_TypeName.equals("Short")) continue;
                    short iShortParam = (Short)_aPropertyValue;
                    short ishortValue = AnyConverter.toShort((Object)oValue);
                    if (ishortValue != iShortParam) continue;
                    xDependentVector.add(xDependent);
                }
            }
            if (xDependentVector.size() > 0) {
                XDependentTextField[] xDependentFields = new XDependentTextField[xDependentVector.size()];
                xDependentVector.toArray(xDependentFields);
                return xDependentFields;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public void changeUserFieldContent(String _FieldName, String _FieldContent) {
        try {
            XDependentTextField[] xDependentTextFields = this.getTextFieldsByProperty(PropertyNames.PROPERTY_NAME, _FieldName, "String");
            if (xDependentTextFields != null) {
                for (int i = 0; i < xDependentTextFields.length; ++i) {
                    xDependentTextFields[i].getTextFieldMaster().setPropertyValue("Content", (Object)_FieldContent);
                }
                this.refreshTextFields();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void updateDocInfoFields() {
        try {
            XEnumeration xEnum = this.xTextFieldsSupplier.getTextFields().createEnumeration();
            while (xEnum.hasMoreElements()) {
                XUpdatable xUp;
                Object oTextField = xEnum.nextElement();
                XServiceInfo xSI = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)oTextField);
                if (xSI.supportsService("com.sun.star.text.TextField.ExtendedUser")) {
                    xUp = (XUpdatable)UnoRuntime.queryInterface(XUpdatable.class, (Object)oTextField);
                    xUp.update();
                }
                if (!xSI.supportsService("com.sun.star.text.TextField.User")) continue;
                xUp = (XUpdatable)UnoRuntime.queryInterface(XUpdatable.class, (Object)oTextField);
                xUp.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDateFields() {
        try {
            XEnumeration xEnum = this.xTextFieldsSupplier.getTextFields().createEnumeration();
            GregorianCalendar cal = new GregorianCalendar();
            DateTime dt = new DateTime();
            dt.Day = (short)cal.get(5);
            dt.Year = (short)cal.get(1);
            dt.Month = (short)cal.get(2);
            dt.Month = (short)(dt.Month + 1);
            while (xEnum.hasMoreElements()) {
                Object oTextField = xEnum.nextElement();
                XServiceInfo xSI = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)oTextField);
                if (!xSI.supportsService("com.sun.star.text.TextField.DateTime")) continue;
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oTextField);
                xPSet.setPropertyValue("IsFixed", (Object)Boolean.FALSE);
                xPSet.setPropertyValue("DateTimeValue", (Object)dt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fixDateFields(boolean _bSetFixed) {
        try {
            XEnumeration xEnum = this.xTextFieldsSupplier.getTextFields().createEnumeration();
            while (xEnum.hasMoreElements()) {
                Object oTextField = xEnum.nextElement();
                XServiceInfo xSI = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)oTextField);
                if (!xSI.supportsService("com.sun.star.text.TextField.DateTime")) continue;
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oTextField);
                xPSet.setPropertyValue("IsFixed", (Object)_bSetFixed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeUserFieldByContent(String _FieldContent) {
        XDependentTextField[] xDependentTextFields = this.getTextFieldsByProperty("Content", _FieldContent, "String");
        if (xDependentTextFields != null) {
            for (int i = 0; i < xDependentTextFields.length; ++i) {
                xDependentTextFields[i].dispose();
            }
        }
    }

    public void changeExtendedUserFieldContent(short UserDataPart, String _FieldContent) {
        try {
            XDependentTextField[] xDependentTextFields = this.getTextFieldsByProperty("UserDataType", UserDataPart, "Short");
            if (xDependentTextFields != null) {
                for (int i = 0; i < xDependentTextFields.length; ++i) {
                    xDependentTextFields[i].getTextFieldMaster().setPropertyValue("Content", (Object)_FieldContent);
                }
            }
            this.refreshTextFields();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

