/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;

public class TimeStampControl
extends DatabaseControl {
    DatabaseControl oDateControl;
    DatabaseControl oTimeControl;
    Resource oResource;
    XShapes xGroupShapes = null;
    double nreldatewidth;
    double nreltimewidth;
    int nTimeWidth;
    int nDBWidth;
    int nDateWidth;

    public TimeStampControl(Resource _oResource, FormHandler _oFormHandler, XNameContainer _xFormName, String _curFieldName, Point _aPoint) {
        super(_oFormHandler, "com.sun.star.drawing.ShapeCollection", _aPoint);
        this.oResource = _oResource;
        this.oDateControl = new DatabaseControl(this.oFormHandler, _xFormName, _curFieldName, 91, this.aPoint);
        int nDBHeight = this.oDateControl.getControlHeight();
        this.nDateWidth = this.oDateControl.getPreferredWidth();
        this.oDateControl.setSize(new Size(this.nDateWidth, nDBHeight));
        Point aTimePoint = new Point(this.aPoint.X + 10 + this.nDateWidth, this.aPoint.Y);
        this.oTimeControl = new DatabaseControl(this.oFormHandler, _xFormName, _curFieldName, 92, aTimePoint);
        this.nTimeWidth = this.oTimeControl.getPreferredWidth();
        this.oTimeControl.setSize(new Size(this.nTimeWidth, nDBHeight));
        this.nDBWidth = this.nDateWidth + this.nTimeWidth + 10;
        this.xShapes.add(this.oDateControl.xShape);
        this.xShapes.add(this.oTimeControl.xShape);
        this.xShape = _oFormHandler.xShapeGrouper.group(this.xShapes);
        this.xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)this.xShape);
        this.nreldatewidth = 1.0 / ((double)this.getSize().Width / (double)this.nDateWidth);
        this.nreltimewidth = 1.0 - this.nreldatewidth;
    }

    public XPropertySet getControlofGroupShapeByIndex(int _i) {
        try {
            if (_i < this.xShapes.getCount()) {
                Object oControl = this.xShapes.getByIndex(_i);
                XControlShape xControlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)oControl);
                return (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlShape.getControl());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public TimeStampControl(Resource _oResource, GridControl _oGridControl, FieldColumn _curfieldcolumn) {
        super(_oGridControl, _curfieldcolumn);
        this.oResource = _oResource;
        String sDateAppendix = this.oResource.getResText(2288);
        String sTimeAppendix = this.oResource.getResText(2289);
        this.oDateControl = new DatabaseControl(_oGridControl, _curfieldcolumn, 91, _curfieldcolumn.getFieldTitle() + PropertyNames.SPACE + sDateAppendix);
        this.oTimeControl = new DatabaseControl(_oGridControl, _curfieldcolumn, 92, _curfieldcolumn.getFieldTitle() + PropertyNames.SPACE + sTimeAppendix);
    }

    public void setPropertyValue(String _sPropertyName, Object _aPropertyValue) throws Exception {
        this.oDateControl.setPropertyValue(_sPropertyName, _aPropertyValue);
        this.oTimeControl.setPropertyValue(_sPropertyName, _aPropertyValue);
    }

    public int getPreferredWidth() {
        return this.nDBWidth;
    }

    public void setSize(Size _aSize) {
        try {
            int ndatewidth = (int)(this.nreldatewidth * (double)_aSize.Width);
            int ntimewidth = (int)(this.nreltimewidth * (double)_aSize.Width);
            this.oDateControl.xShape.setSize(new Size(ndatewidth, _aSize.Height));
            this.oTimeControl.xShape.setSize(new Size(ntimewidth, _aSize.Height));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(System.err);
        }
    }

    public Size getSize() {
        int ncontrolwidth = this.oDateControl.xShape.getSize().Width + this.oTimeControl.xShape.getSize().Width;
        return new Size(ncontrolwidth, this.oDateControl.xShape.getSize().Height);
    }

    public int getControlType() {
        return 8;
    }
}

