/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.document.XEventsSupplier;
import com.sun.star.document.XTypeDetection;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.XCellRange;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.SystemDialog;

public class OfficeDocument {
    private XWindowPeer xWindowPeer;

    public OfficeDocument(XMultiServiceFactory _xMSF) {
    }

    public static void attachEventCall(XComponent xComponent, String EventName, String EventType, String EventURL) {
        try {
            XEventsSupplier xEventssSuppl = (XEventsSupplier)UnoRuntime.queryInterface(XEventsSupplier.class, (Object)xComponent);
            PropertyValue[] oEventProperties = new PropertyValue[2];
            oEventProperties[0] = new PropertyValue();
            oEventProperties[0].Name = "EventType";
            oEventProperties[0].Value = EventType;
            oEventProperties[1] = new PropertyValue();
            oEventProperties[1].Name = "Script";
            oEventProperties[1].Value = EventURL;
            xEventssSuppl.getEvents().replaceByName(EventName, (Object)oEventProperties);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void dispose(XMultiServiceFactory xMSF, XComponent xComponent) {
        try {
            if (xComponent != null) {
                XModifiable xModified = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)xComponent);
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
                XFrame xFrame = xModel.getCurrentController().getFrame();
                if (xModified.isModified()) {
                    xModified.setModified(false);
                }
                Desktop.dispatchURL(xMSF, ".uno:CloseDoc", xFrame);
            }
        }
        catch (PropertyVetoException exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static Object createNewDocument(XFrame frame, String sDocumentType, boolean preview, boolean readonly) {
        PropertyValue[] loadValues = new PropertyValue[2];
        loadValues[0] = new PropertyValue();
        loadValues[0].Name = PropertyNames.READ_ONLY;
        loadValues[0].Value = readonly ? Boolean.TRUE : Boolean.FALSE;
        loadValues[1] = new PropertyValue();
        loadValues[1].Name = "Preview";
        loadValues[1].Value = preview ? Boolean.TRUE : Boolean.FALSE;
        Object oDocument = null;
        XComponentLoader xComponentLoader = null;
        String sURL = "private:factory/" + sDocumentType;
        try {
            xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)frame);
            XComponent xComponent = xComponentLoader.loadComponentFromURL(sURL, "_self", 0, loadValues);
            if (sDocumentType.equals("swriter")) {
                oDocument = UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            } else if (sDocumentType.equals("scalc")) {
                oDocument = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return oDocument;
    }

    public static XFrame createNewFrame(XMultiServiceFactory xMSF, XTerminateListener listener) {
        return OfficeDocument.createNewFrame(xMSF, listener, "_blank");
    }

    public static XFrame createNewFrame(XMultiServiceFactory xMSF, XTerminateListener listener, String FrameName) {
        XFrame xFrame = null;
        if (FrameName.equalsIgnoreCase("WIZARD_LIVE_PREVIEW")) {
            xFrame = OfficeDocument.createNewPreviewFrame(xMSF, listener);
        } else {
            XFrame xF = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)Desktop.getDesktop(xMSF));
            xFrame = xF.findFrame(FrameName, 0);
            if (listener != null) {
                XFramesSupplier xFS = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xF);
                XFrames xFF = xFS.getFrames();
                xFF.remove(xFrame);
                XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xF);
                xDesktop.addTerminateListener(listener);
            }
        }
        return xFrame;
    }

    public static XFrame createNewPreviewFrame(XMultiServiceFactory xMSF, XTerminateListener listener) {
        XToolkit xToolkit = null;
        try {
            xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xMSF.createInstance("com.sun.star.awt.Toolkit"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WindowDescriptor aDescriptor = new WindowDescriptor();
        aDescriptor.Type = WindowClass.TOP;
        aDescriptor.WindowServiceName = "window";
        aDescriptor.ParentIndex = (short)-1;
        aDescriptor.Parent = null;
        aDescriptor.Bounds = new Rectangle(10, 10, 640, 480);
        aDescriptor.WindowAttributes = 524400;
        XWindowPeer xPeer = null;
        try {
            xPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xToolkit.createWindow(aDescriptor));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xPeer);
        XFrame xFrame = null;
        try {
            xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)xMSF.createInstance("com.sun.star.frame.Frame"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        xFrame.initialize(xWindow);
        if (listener != null) {
            Desktop.getDesktop(xMSF).addTerminateListener(listener);
        }
        return xFrame;
    }

    public static Object load(XInterface xInterface, String sURL, String sFrame, PropertyValue[] xValues) {
        Object oDocument = null;
        XComponentLoader xComponentLoader = null;
        try {
            xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xInterface);
            XComponent xComponent = xComponentLoader.loadComponentFromURL(sURL, sFrame, 0, xValues);
            XServiceInfo xComponentService = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
            if (xComponentService.supportsService("com.sun.star.text.TextDocument")) {
                oDocument = UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return oDocument;
    }

    public static boolean store(XMultiServiceFactory xMSF, XComponent xComponent, String StorePath, String FilterName, boolean bStoreToUrl) {
        try {
            PropertyValue[] oStoreProperties;
            XStorable xStoreable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
            if (FilterName.length() > 0) {
                oStoreProperties = new PropertyValue[2];
                oStoreProperties[0] = new PropertyValue();
                oStoreProperties[0].Name = "FilterName";
                oStoreProperties[0].Value = FilterName;
                oStoreProperties[1] = new PropertyValue();
                oStoreProperties[1].Name = "InteractionHandler";
                oStoreProperties[1].Value = UnoRuntime.queryInterface(XInteractionHandler.class, (Object)xMSF.createInstance("com.sun.star.comp.uui.UUIInteractionHandler"));
            } else {
                oStoreProperties = new PropertyValue[]{};
            }
            if (bStoreToUrl) {
                xStoreable.storeToURL(StorePath, oStoreProperties);
            } else {
                xStoreable.storeAsURL(StorePath, oStoreProperties);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public static boolean close(XComponent xComponent) {
        boolean bState = false;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        if (xModel != null) {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xModel);
            if (xCloseable != null) {
                try {
                    xCloseable.close(true);
                    bState = true;
                }
                catch (CloseVetoException exCloseVeto) {
                    System.out.println("could not close doc");
                    bState = false;
                }
            } else {
                XComponent xDisposeable = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xModel);
                xDisposeable.dispose();
                bState = true;
            }
        }
        return bState;
    }

    public static void ArraytoCellRange(Object[][] datalist, Object oTable, int xpos, int ypos) {
        try {
            int colcount;
            int rowcount = datalist.length;
            if (rowcount > 0 && (colcount = datalist[0].length) > 0) {
                XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)oTable);
                XCellRange xNewRange = xCellRange.getCellRangeByPosition(xpos, ypos, colcount + xpos - 1, rowcount + ypos - 1);
                XCellRangeData xDataArray = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)xNewRange);
                xDataArray.setDataArray(datalist);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PropertyValue[] getFileMediaDecriptor(XMultiServiceFactory xmsf, String url) throws Exception {
        Object typeDetect = xmsf.createInstance("com.sun.star.document.TypeDetection");
        PropertyValue[][] mediaDescr = new PropertyValue[1][1];
        mediaDescr[0][0] = new PropertyValue();
        mediaDescr[0][0].Name = PropertyNames.URL;
        mediaDescr[0][0].Value = url;
        String type = ((XTypeDetection)UnoRuntime.queryInterface(XTypeDetection.class, (Object)typeDetect)).queryTypeByDescriptor(mediaDescr, true);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)typeDetect);
        if (type.equals(PropertyNames.EMPTY_STRING)) {
            return null;
        }
        return (PropertyValue[])xNameAccess.getByName(type);
    }

    public static PropertyValue[] getTypeMediaDescriptor(XMultiServiceFactory xmsf, String type) throws Exception {
        Object typeDetect = xmsf.createInstance("com.sun.star.document.TypeDetection");
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)typeDetect);
        return (PropertyValue[])xNameAccess.getByName(type);
    }

    public static int getSlideCount(Object model) {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)model);
        return xDrawPagesSupplier.getDrawPages().getCount();
    }

    public static XDocumentProperties getDocumentProperties(Object document) {
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)document);
        return xDocumentPropertiesSupplier.getDocumentProperties();
    }

    public static int showMessageBox(XMultiServiceFactory xMSF, String windowServiceName, int windowAttribute, String MessageText) {
        return SystemDialog.showMessageBox(xMSF, windowServiceName, windowAttribute, MessageText);
    }

    public XWindowPeer getWindowPeer() {
        return this.xWindowPeer;
    }

    public void setWindowPeer(XWindowPeer windowPeer) {
        this.xWindowPeer = windowPeer;
    }
}

