/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShapes;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;

public class DatabaseControl
extends Control {
    private int m_nFieldType;
    private static long m_nLongMax = 0L;

    public DatabaseControl(GridControl _oGridControl, FieldColumn _curfieldcolumn) {
        if (_curfieldcolumn.getFieldType() != 93) {
            this.createGridColumn(_oGridControl, _curfieldcolumn, _curfieldcolumn.getFieldType(), _curfieldcolumn.getFieldTitle());
        }
    }

    public DatabaseControl(GridControl _oGridControl, FieldColumn _curfieldcolumn, int _fieldtype, String _columntitle) {
        this.createGridColumn(_oGridControl, _curfieldcolumn, _fieldtype, _columntitle);
    }

    protected int getFieldType() {
        return this.m_nFieldType;
    }

    private void createGridColumn(GridControl _oGridControl, FieldColumn _curfieldcolumn, int _fieldtype, String _columntitle) {
        try {
            this.m_nFieldType = _fieldtype;
            String sFieldName = _curfieldcolumn.getFieldName();
            String sUniqueName = Desktop.getUniqueName(_oGridControl.xNameAccess, sFieldName);
            String sGridColumnName = this.getGridColumnName();
            XPropertySet xPropColumn = _oGridControl.xGridColumnFactory.createColumn(sGridColumnName);
            xPropColumn.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sUniqueName);
            boolean bHidden = false;
            if (_fieldtype == -4) {
                bHidden = true;
            }
            xPropColumn.setPropertyValue("Hidden", (Object)bHidden);
            xPropColumn.setPropertyValue("DataField", (Object)sFieldName);
            xPropColumn.setPropertyValue(PropertyNames.PROPERTY_LABEL, (Object)_columntitle);
            xPropColumn.setPropertyValue(PropertyNames.PROPERTY_WIDTH, (Object)0);
            XPropertySetInfo xPSI = xPropColumn.getPropertySetInfo();
            if (xPSI.hasPropertyByName("MouseWheelBehavior")) {
                xPropColumn.setPropertyValue("MouseWheelBehavior", (Object)0);
            }
            this.setNumericLimits();
            _oGridControl.xNameContainer.insertByName(sFieldName, (Object)xPropColumn);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public DatabaseControl(FormHandler _oFormHandler, String _sServiceName, Point _aPoint) {
        super(_oFormHandler, _sServiceName, _aPoint);
    }

    public DatabaseControl(FormHandler _oFormHandler, XNameContainer _xFormName, String _curFieldName, int _fieldtype, Point _aPoint) {
        super(_oFormHandler, _xFormName, _oFormHandler.getControlType(_fieldtype), _curFieldName, _aPoint, null);
        try {
            this.m_nFieldType = _fieldtype;
            Helper.setUnoPropertyValue(this.xControlModel, "DataField", _curFieldName);
            this.setNumericLimits();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public DatabaseControl(FormHandler _oFormHandler, XShapes _xGroupShapes, XNameContainer _xFormName, String _curFieldName, int _fieldtype, Point _aPoint) {
        super(_oFormHandler, _xGroupShapes, _xFormName, _oFormHandler.getControlType(_fieldtype), _aPoint, null);
        try {
            this.m_nFieldType = _fieldtype;
            Helper.setUnoPropertyValue(this.xControlModel, "DataField", _curFieldName);
            this.setNumericLimits();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private String getGridColumnName() {
        for (int i = 0; i < FormHandler.oControlData.length; ++i) {
            if (FormHandler.oControlData[i].DataType != this.getFieldType()) continue;
            return FormHandler.oControlData[i].GridColumnName;
        }
        return PropertyNames.EMPTY_STRING;
    }

    public int getControlHeight() {
        if (this.getControlType() == 7) {
            return this.oFormHandler.getControlReferenceHeight() * 4;
        }
        if (this.getFieldType() == -1) {
            return this.oFormHandler.getControlReferenceHeight() * 4;
        }
        if (this.getControlType() == 2) {
            return super.getPreferredHeight();
        }
        return this.oFormHandler.getControlReferenceHeight();
    }

    public int getControlWidth() {
        if (this.getControlType() == 7) {
            return 2 * this.getControlHeight();
        }
        if (this.getFieldType() == -1) {
            return 2 * this.getControlHeight();
        }
        return this.getPreferredWidth();
    }

    public static long getLongMax() {
        if (m_nLongMax == 0L) {
            // empty if block
        }
        return m_nLongMax;
    }

    public void setNumericLimits() {
        try {
            if (this.getControlType() == 5) {
                this.xPropertySet.setPropertyValue("TreatAsNumber", (Object)Boolean.TRUE);
                switch (this.getFieldType()) {
                    case -5: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(9.223372036854776E18));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-9.223372036854776E18));
                        break;
                    }
                    case 4: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(2.147483647E9));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-2.147483648E9));
                        break;
                    }
                    case 5: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(32767.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-32768.0));
                        break;
                    }
                    case -6: {
                        this.xPropertySet.setPropertyValue("EffectiveMax", (Object)new Double(127.0));
                        this.xPropertySet.setPropertyValue("EffectiveMin", (Object)new Double(-128.0));
                        break;
                    }
                }
            } else if (this.getControlType() == 7) {
                this.xPropertySet.setPropertyValue("ScaleMode", (Object)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

