/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.ui.WizardDialog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DatabaseObjectWizard
extends WizardDialog {
    protected final PropertyValue[] m_wizardContext;
    protected final XDatabaseDocumentUI m_docUI;
    protected final XFrame m_frame;

    protected DatabaseObjectWizard(XMultiServiceFactory i_orb, int i_helpIDBase, PropertyValue[] i_wizardContext) {
        super(i_orb, i_helpIDBase);
        this.m_wizardContext = i_wizardContext;
        NamedValueCollection wizardContext = new NamedValueCollection(this.m_wizardContext);
        this.m_docUI = wizardContext.queryOrDefault("DocumentUI", null, XDatabaseDocumentUI.class);
        if (this.m_docUI != null) {
            XController docController = (XController)UnoRuntime.queryInterface(XController.class, (Object)this.m_docUI);
            this.m_frame = docController.getFrame();
        } else {
            XFrame parentFrame = wizardContext.queryOrDefault("ParentFrame", null, XFrame.class);
            this.m_frame = parentFrame != null ? parentFrame : Desktop.getActiveFrame(this.xMSF);
        }
    }

    protected final void loadSubComponent(int i_type, String i_name, boolean i_forEditing) {
        try {
            if (this.m_docUI != null) {
                this.m_docUI.loadComponent(i_type, i_name, i_forEditing);
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchElementException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected static void executeWizardFromCommandLine(String[] i_args, String i_className) {
        String[] settings = new String[]{null, null, null};
        boolean IDX_PIPE_NAME = false;
        boolean IDX_LOCATION = true;
        int IDX_DSN = 2;
        boolean failure = false;
        int settingsIndex = -1;
        for (int i = 0; i < i_args.length; ++i) {
            if (settingsIndex >= 0) {
                settings[settingsIndex] = i_args[i];
                settingsIndex = -1;
                continue;
            }
            if (i_args[i].equals("--pipe-name")) {
                settingsIndex = 0;
                continue;
            }
            if (i_args[i].equals("--database-location")) {
                settingsIndex = 1;
                continue;
            }
            if (i_args[i].equals("--data-source-name")) {
                settingsIndex = 2;
                continue;
            }
            failure = true;
        }
        if (settings[0] == null) {
            failure = true;
        }
        if (settings[2] == null && settings[1] == null) {
            failure = true;
        }
        if (failure) {
            System.err.println("supported arguments: ");
            System.err.println("  --pipe-name <name>           : specifies the name of the pipe to connect to the running OOo instance");
            System.err.println("  --database-location <url>    : specifies the URL of the database document to work with");
            System.err.println("  --data-source-name <name>    : specifies the name of the data source to work with");
            return;
        }
        String ConnectStr = "uno:pipe,name=" + settings[0] + ";urp;StarOffice.ServiceManager";
        try {
            XMultiServiceFactory serviceFactory = Desktop.connect(ConnectStr);
            if (serviceFactory != null) {
                PropertyValue[] curproperties = new PropertyValue[]{settings[1] != null ? Properties.createProperty("DatabaseLocation", settings[1]) : Properties.createProperty("DataSourceName", settings[2])};
                Class<?> wizardClass = Class.forName(i_className);
                Constructor<?> ctor = wizardClass.getConstructor(XMultiServiceFactory.class, PropertyValue[].class);
                Method invokeMethod = wizardClass.getMethod("start", new Class[0]);
                Object wizardInstance = ctor.newInstance(serviceFactory, curproperties);
                invokeMethod.invoke(wizardInstance, new Object[0]);
            }
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
    }
}

