/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;

public class CommandName {
    protected CommandMetaData oCommandMetaData;
    protected String CatalogName = PropertyNames.EMPTY_STRING;
    protected String SchemaName = PropertyNames.EMPTY_STRING;
    protected String TableName = PropertyNames.EMPTY_STRING;
    protected String DisplayName = PropertyNames.EMPTY_STRING;
    protected String ComposedName = PropertyNames.EMPTY_STRING;
    protected String AliasName = PropertyNames.EMPTY_STRING;
    protected boolean bCatalogAtStart;
    protected String sCatalogSep;
    protected String sIdentifierQuote;
    protected boolean baddQuotation = true;

    public CommandName(CommandMetaData _CommandMetaData, String _DisplayName) {
        this.oCommandMetaData = _CommandMetaData;
        this.setComposedCommandName(_DisplayName);
    }

    public CommandName(CommandMetaData _CommandMetaData, String _CatalogName, String _SchemaName, String _TableName, boolean _baddQuotation) {
        try {
            this.baddQuotation = _baddQuotation;
            this.oCommandMetaData = _CommandMetaData;
            if (_CatalogName != null && this.oCommandMetaData.xDBMetaData.supportsCatalogsInTableDefinitions() && !_CatalogName.equals(PropertyNames.EMPTY_STRING)) {
                this.CatalogName = _CatalogName;
            }
            if (_SchemaName != null && this.oCommandMetaData.xDBMetaData.supportsSchemasInTableDefinitions() && !_SchemaName.equals(PropertyNames.EMPTY_STRING)) {
                this.SchemaName = _SchemaName;
            }
            if (_TableName != null && !_TableName.equals(PropertyNames.EMPTY_STRING)) {
                this.TableName = _TableName;
            }
            this.setComposedCommandName();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }

    private void setComposedCommandName(String _DisplayName) {
        try {
            int iIndex;
            if (!this.setMetaDataAttributes()) {
                return;
            }
            this.DisplayName = _DisplayName;
            if (this.oCommandMetaData.xDBMetaData.supportsCatalogsInDataManipulation() && (iIndex = _DisplayName.indexOf(this.sCatalogSep)) >= 0) {
                if (this.bCatalogAtStart) {
                    this.CatalogName = _DisplayName.substring(0, iIndex);
                    _DisplayName = _DisplayName.substring(iIndex + 1, _DisplayName.length());
                } else {
                    this.CatalogName = _DisplayName.substring(iIndex + 1, _DisplayName.length());
                    _DisplayName = _DisplayName.substring(0, iIndex);
                }
            }
            if (this.oCommandMetaData.xDBMetaData.supportsSchemasInDataManipulation()) {
                String[] NameList = new String[]{};
                NameList = JavaTools.ArrayoutofString(_DisplayName, ".");
                if (NameList.length > 1) {
                    this.SchemaName = NameList[0];
                    this.TableName = NameList[1];
                } else {
                    this.TableName = _DisplayName;
                }
            } else {
                this.TableName = _DisplayName;
            }
            this.setComposedCommandName();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setComposedCommandName() {
        if (this.setMetaDataAttributes()) {
            if (this.CatalogName != null && !this.CatalogName.equals(PropertyNames.EMPTY_STRING) && this.bCatalogAtStart) {
                this.ComposedName = this.quoteName(this.CatalogName) + this.sCatalogSep;
            }
            if (this.SchemaName != null && !this.SchemaName.equals(PropertyNames.EMPTY_STRING)) {
                this.ComposedName = this.ComposedName + this.quoteName(this.SchemaName) + ".";
            }
            this.ComposedName = this.ComposedName.equals(PropertyNames.EMPTY_STRING) ? this.quoteName(this.TableName) : this.ComposedName + this.quoteName(this.TableName);
            if (!this.bCatalogAtStart && this.CatalogName != null && !this.CatalogName.equals(PropertyNames.EMPTY_STRING)) {
                this.ComposedName = this.ComposedName + this.sCatalogSep + this.quoteName(this.CatalogName);
            }
        }
    }

    private boolean setMetaDataAttributes() {
        try {
            this.bCatalogAtStart = this.oCommandMetaData.xDBMetaData.isCatalogAtStart();
            this.sCatalogSep = this.oCommandMetaData.xDBMetaData.getCatalogSeparator();
            this.sIdentifierQuote = this.oCommandMetaData.xDBMetaData.getIdentifierQuoteString();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public String quoteName(String _sName) {
        if (this.baddQuotation) {
            return CommandName.quoteName(_sName, this.oCommandMetaData.getIdentifierQuote());
        }
        return _sName;
    }

    public static String quoteName(String sName, String _sIdentifierQuote) {
        if (sName == null) {
            sName = PropertyNames.EMPTY_STRING;
        }
        return _sIdentifierQuote + sName + _sIdentifierQuote;
    }

    public void setAliasName(String _AliasName) {
        this.AliasName = _AliasName;
    }

    public String getAliasName() {
        return this.AliasName;
    }

    public String getCatalogName() {
        return this.CatalogName;
    }

    public String getComposedName() {
        return this.ComposedName;
    }

    public String getDisplayName() {
        return this.DisplayName;
    }

    public String getSchemaName() {
        return this.SchemaName;
    }

    public String getTableName() {
        return this.TableName;
    }

    public CommandMetaData getCommandMetaData() {
        return this.oCommandMetaData;
    }
}

