/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XKeysSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.CommandName;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMetaData
extends DBMetaData {
    public Map<String, String> FieldTitleSet = new HashMap<String, String>();
    public String[] m_aAllFieldNames = new String[0];
    public FieldColumn[] FieldColumns = new FieldColumn[0];
    public String[] GroupFieldNames = new String[0];
    private String[][] SortFieldNames = new String[0][];
    private String[] RecordFieldNames = new String[0];
    public String[][] AggregateFieldNames = new String[0][];
    public String[] NumericFieldNames = new String[0];
    public String[] NonAggregateFieldNames;
    private int CommandType;
    private String Command;
    boolean bCatalogAtStart = true;
    String sCatalogSep = PropertyNames.EMPTY_STRING;
    String sIdentifierQuote = PropertyNames.EMPTY_STRING;
    boolean bCommandComposerAttributesalreadyRetrieved = false;
    private XIndexAccess xIndexKeys;

    public CommandMetaData(XMultiServiceFactory xMSF, Locale _aLocale, NumberFormatter oNumberFormatter) {
        super(xMSF, _aLocale, oNumberFormatter);
    }

    public CommandMetaData(XMultiServiceFactory xMSF) {
        super(xMSF);
    }

    public void initializeFieldColumns(boolean _bgetDefaultValue, String _CommandName, String[] _FieldNames) {
        this.setCommandName(_CommandName);
        this.FieldColumns = new FieldColumn[_FieldNames.length];
        for (int i = 0; i < _FieldNames.length; ++i) {
            this.FieldColumns[i] = new FieldColumn(this, _FieldNames[i], this.getCommandName(), false);
        }
    }

    public void initializeFieldColumns(String[] _FieldNames, XNameAccess _xColumns) {
        this.FieldColumns = new FieldColumn[_FieldNames.length];
        for (int i = 0; i < _FieldNames.length; ++i) {
            this.FieldColumns[i] = new FieldColumn(this, _xColumns, _FieldNames[i]);
        }
    }

    public void initializeFieldColumns(String[] _FieldNames, String _CommandName) {
        this.setCommandName(_CommandName);
        this.FieldColumns = new FieldColumn[_FieldNames.length];
        for (int i = 0; i < _FieldNames.length; ++i) {
            this.FieldColumns[i] = new FieldColumn(this, _FieldNames[i], _CommandName, false);
            if (this.FieldTitleSet == null || !this.FieldTitleSet.containsKey(_FieldNames[i])) continue;
            this.FieldColumns[i].setFieldTitle(this.FieldTitleSet.get(_FieldNames[i]));
            if (this.FieldColumns[i].getFieldTitle() != null) continue;
            this.FieldColumns[i].setFieldTitle(_FieldNames[i]);
            this.FieldTitleSet.put(_FieldNames[i], _FieldNames[i]);
        }
    }

    public Map<String, String> getFieldTitleSet() {
        return this.FieldTitleSet;
    }

    public XPropertySet getColumnObjectByFieldName(String _FieldName, boolean _bgetByDisplayName) {
        try {
            FieldColumn CurFieldColumn = null;
            CurFieldColumn = _bgetByDisplayName ? this.getFieldColumnByDisplayName(_FieldName) : this.getFieldColumnByFieldName(_FieldName);
            String CurCommandName = CurFieldColumn.getCommandName();
            DBMetaData.CommandObject oCommand = this.getTableByName(CurCommandName);
            Object oColumn = oCommand.getColumns().getByName(CurFieldColumn.getFieldName());
            return (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oColumn);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void prependSortFieldNames(String[] _fieldnames) {
        int i;
        ArrayList<String[]> aSortFields = new ArrayList<String[]>();
        for (i = 0; i < _fieldnames.length; ++i) {
            int index = JavaTools.FieldInTable(this.SortFieldNames, _fieldnames[i]);
            String[] sSortFieldName = new String[]{_fieldnames[i], index > -1 ? this.SortFieldNames[index][1] : PropertyNames.ASC};
            aSortFields.add(sSortFieldName);
        }
        for (i = 0; i < this.SortFieldNames.length; ++i) {
            if (JavaTools.FieldInList(_fieldnames, this.SortFieldNames[i][0]) != -1) continue;
            aSortFields.add(this.SortFieldNames[i]);
        }
        this.SortFieldNames = new String[aSortFields.size()][2];
        aSortFields.toArray((T[])this.SortFieldNames);
    }

    public String[][] getSortFieldNames() {
        return this.SortFieldNames;
    }

    public void setSortFieldNames(String[][] aNewListList) {
        this.SortFieldNames = aNewListList;
    }

    public FieldColumn getFieldColumn(String _FieldName, String _CommandName) {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            if (!this.FieldColumns[i].getFieldName().equals(_FieldName) || !this.FieldColumns[i].getCommandName().equals(_CommandName)) continue;
            return this.FieldColumns[i];
        }
        return null;
    }

    public FieldColumn getFieldColumnByFieldName(String _FieldName) {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            String sCompound;
            String sFieldName = this.FieldColumns[i].getFieldName();
            if (sFieldName.equals(_FieldName)) {
                return this.FieldColumns[i];
            }
            if (_FieldName.indexOf(46) != -1 || !sFieldName.equals(sCompound = this.Command + "." + _FieldName)) continue;
            return this.FieldColumns[i];
        }
        throw new RuntimeException();
    }

    public FieldColumn getFieldColumnByDisplayName(String _DisplayName) {
        String identifierQuote = this.getIdentifierQuote();
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            String sCompound;
            String sDisplayName = this.FieldColumns[i].getDisplayFieldName();
            if (sDisplayName.equals(_DisplayName)) {
                return this.FieldColumns[i];
            }
            if (_DisplayName.indexOf(46) == -1 && sDisplayName.equals(sCompound = this.Command + "." + _DisplayName)) {
                return this.FieldColumns[i];
            }
            String quotedName = CommandName.quoteName(this.FieldColumns[i].getCommandName(), identifierQuote) + '.' + CommandName.quoteName(this.FieldColumns[i].getFieldName(), identifierQuote);
            if (!quotedName.equals(_DisplayName)) continue;
            return this.FieldColumns[i];
        }
        throw new RuntimeException();
    }

    public FieldColumn getFieldColumnByTitle(String _FieldTitle) {
        int i;
        for (i = 0; i < this.FieldColumns.length; ++i) {
            if (!this.FieldColumns[i].getFieldTitle().equals(_FieldTitle)) continue;
            return this.FieldColumns[i];
        }
        for (i = 0; i < this.FieldColumns.length; ++i) {
            if (!this.FieldColumns[i].getFieldName().equals(_FieldTitle)) continue;
            return this.FieldColumns[i];
        }
        throw new RuntimeException();
    }

    public boolean getFieldNamesOfCommand(String _commandname, int _commandtype, boolean _bAppendMode) {
        try {
            ArrayList<String> ResultFieldNames = new ArrayList<String>(10);
            DBMetaData.CommandObject oCommand = this.getCommandByName(_commandname, _commandtype);
            String[] FieldNames = oCommand.getColumns().getElementNames();
            if (FieldNames.length > 0) {
                for (int n = 0; n < FieldNames.length; ++n) {
                    String sFieldName = FieldNames[n];
                    Object oField = oCommand.getColumns().getByName(sFieldName);
                    int iType = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(oField, "Type"));
                    if (JavaTools.FieldInIntTable(this.WidthList, iType) >= 0) {
                        ResultFieldNames.add(sFieldName);
                        continue;
                    }
                    if (JavaTools.FieldInIntTable(BinaryTypes, iType) < 0) continue;
                    ResultFieldNames.add(sFieldName);
                }
                this.m_aAllFieldNames = new String[ResultFieldNames.size()];
                this.m_aAllFieldNames = ResultFieldNames.toArray(this.m_aAllFieldNames);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        Resource oResource = new Resource(this.xMSF, "dbw");
        String sMsgNoFieldsFromCommand = oResource.getResText(1045);
        sMsgNoFieldsFromCommand = JavaTools.replaceSubString(sMsgNoFieldsFromCommand, _commandname, "%NAME");
        this.showMessageBox("ErrorBox", 0x400000, sMsgNoFieldsFromCommand);
        return false;
    }

    public String[] getOrderableColumns(String[] _fieldnames) {
        ArrayList<String> aOrderableColumns = new ArrayList<String>();
        for (int i = 0; i < _fieldnames.length; ++i) {
            FieldColumn ofieldcolumn = this.getFieldColumnByFieldName(_fieldnames[i]);
            if (!this.getDBDataTypeInspector().isColumnOrderable(ofieldcolumn.getXColumnPropertySet())) continue;
            aOrderableColumns.add(_fieldnames[i]);
        }
        String[] sretfieldnames = new String[aOrderableColumns.size()];
        return aOrderableColumns.toArray(sretfieldnames);
    }

    public String getCommandName() {
        return this.Command;
    }

    public void setCommandName(String _command) {
        this.Command = _command;
    }

    public int getCommandType() {
        return this.CommandType;
    }

    public void setCommandType(int _commandType) {
        this.CommandType = _commandType;
    }

    public boolean isnumeric(FieldColumn _oFieldColumn) {
        try {
            DBMetaData.CommandObject oTable = super.getTableByName(_oFieldColumn.getCommandName());
            Object oField = oTable.getColumns().getByName(_oFieldColumn.getFieldName());
            int iType = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(oField, "Type"));
            int ifound = Arrays.binarySearch(NumericTypes, iType);
            if (ifound < NumericTypes.length && ifound > 0) {
                return NumericTypes[ifound] == iType;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public String[] setNumericFields() {
        try {
            ArrayList<String> numericfieldsvector = new ArrayList<String>();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (!this.isnumeric(this.FieldColumns[i])) continue;
                numericfieldsvector.add(this.FieldColumns[i].getDisplayFieldName());
            }
            this.NumericFieldNames = new String[numericfieldsvector.size()];
            numericfieldsvector.toArray(this.NumericFieldNames);
            return this.NumericFieldNames;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return new String[0];
        }
    }

    public String[] getFieldNames(String[] _sDisplayFieldNames, String _sCommandName) {
        ArrayList<String> sFieldNamesVector = new ArrayList<String>();
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            if (!_sCommandName.equals(this.FieldColumns[i].getCommandName()) || JavaTools.FieldInList(_sDisplayFieldNames, this.FieldColumns[i].getDisplayFieldName()) <= -1) continue;
            sFieldNamesVector.add(this.FieldColumns[i].getFieldName());
        }
        String[] sFieldNames = new String[sFieldNamesVector.size()];
        sFieldNamesVector.toArray(sFieldNames);
        return sFieldNames;
    }

    public String[] getFieldNames() {
        String[] sFieldNames = new String[this.FieldColumns.length];
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            sFieldNames[i] = this.FieldColumns[i].getFieldName();
        }
        return sFieldNames;
    }

    public String[] getDisplayFieldNames() {
        String[] sDisplayFieldNames = new String[this.FieldColumns.length];
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            sDisplayFieldNames[i] = this.FieldColumns[i].getDisplayFieldName();
        }
        return sDisplayFieldNames;
    }

    public String[] setNonAggregateFieldNames() {
        try {
            ArrayList<String> nonaggregatefieldsvector = new ArrayList<String>();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (JavaTools.FieldInTable(this.AggregateFieldNames, this.FieldColumns[i].getDisplayFieldName()) != -1) continue;
                nonaggregatefieldsvector.add(this.FieldColumns[i].getDisplayFieldName());
            }
            this.NonAggregateFieldNames = new String[nonaggregatefieldsvector.size()];
            nonaggregatefieldsvector.toArray(this.NonAggregateFieldNames);
            return this.NonAggregateFieldNames;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return new String[0];
        }
    }

    public boolean hasNumericalFields(String[] _DisplayFieldNames) {
        if (_DisplayFieldNames != null && _DisplayFieldNames.length > 0) {
            for (int i = 0; i < _DisplayFieldNames.length; ++i) {
                if (!this.isnumeric(this.getFieldColumnByDisplayName(_DisplayFieldNames[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public String getFieldTitle(String FieldName) {
        String FieldTitle = FieldName;
        if (this.FieldTitleSet != null && (FieldTitle = this.FieldTitleSet.get(FieldName)) == null) {
            return FieldName;
        }
        return FieldTitle;
    }

    public void setFieldTitles(String[] sFieldTitles) {
        int nFieldColLength = this.FieldColumns.length;
        for (int i = 0; i < sFieldTitles.length; ++i) {
            if (i >= nFieldColLength) continue;
            this.FieldColumns[i].setFieldTitle(sFieldTitles[i]);
        }
    }

    public String[] getFieldTitles() {
        String[] sFieldTitles = new String[this.FieldColumns.length];
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            sFieldTitles[i] = this.FieldColumns[i].getFieldTitle();
        }
        return sFieldTitles;
    }

    public void setGroupFieldNames(String[] GroupFieldNames) {
        this.GroupFieldNames = GroupFieldNames;
    }

    public String[] getGroupFieldNames() {
        return this.GroupFieldNames;
    }

    public void createRecordFieldNames() {
        int TotFieldCount = this.FieldColumns.length;
        int GroupFieldCount = JavaTools.getArraylength(this.GroupFieldNames);
        this.RecordFieldNames = new String[TotFieldCount - GroupFieldCount];
        int a = 0;
        for (int i = 0; i < TotFieldCount; ++i) {
            String CurFieldName = this.FieldColumns[i].getFieldName();
            if (JavaTools.FieldInList(this.GroupFieldNames, CurFieldName) >= 0) continue;
            this.RecordFieldNames[a] = CurFieldName;
            ++a;
        }
    }

    public void setRecordFieldNames(String[] _aNewList) {
        this.RecordFieldNames = _aNewList;
    }

    public String[] getRecordFieldNames() {
        return this.RecordFieldNames;
    }

    public String getRecordFieldName(int i) {
        return this.RecordFieldNames[i];
    }

    public String[] getReferencedTables(String _stablename, int _ncommandtype) {
        String[] sTotReferencedTables = new String[]{};
        try {
            if (_ncommandtype == 0 && this.xDBMetaData.supportsIntegrityEnhancementFacility()) {
                ArrayList<String> TableVector = new ArrayList<String>();
                Object oTable = this.getTableNamesAsNameAccess().getByName(_stablename);
                XKeysSupplier xKeysSupplier = (XKeysSupplier)UnoRuntime.queryInterface(XKeysSupplier.class, (Object)oTable);
                this.xIndexKeys = xKeysSupplier.getKeys();
                for (int i = 0; i < this.xIndexKeys.getCount(); ++i) {
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xIndexKeys.getByIndex(i));
                    int curtype = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Type"));
                    if (curtype != 3) continue;
                    String sreftablename = AnyConverter.toString((Object)xPropertySet.getPropertyValue("ReferencedTable"));
                    if (!this.getTableNamesAsNameAccess().hasByName(sreftablename)) continue;
                    TableVector.add(sreftablename);
                }
                if (TableVector.size() > 0) {
                    sTotReferencedTables = new String[TableVector.size()];
                    TableVector.toArray(sTotReferencedTables);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return sTotReferencedTables;
    }

    public String[][] getKeyColumns(String _sreferencedtablename) {
        String[][] skeycolumnnames = null;
        try {
            for (int i = 0; i < this.xIndexKeys.getCount(); ++i) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xIndexKeys.getByIndex(i));
                int curtype = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Type"));
                if (curtype != 3) continue;
                String scurreftablename = AnyConverter.toString((Object)xPropertySet.getPropertyValue("ReferencedTable"));
                if (!this.getTableNamesAsNameAccess().hasByName(scurreftablename) || !scurreftablename.equals(_sreferencedtablename)) continue;
                XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)xPropertySet);
                String[] smastercolnames = xColumnsSupplier.getColumns().getElementNames();
                skeycolumnnames = new String[2][smastercolnames.length];
                skeycolumnnames[0] = smastercolnames;
                skeycolumnnames[1] = new String[smastercolnames.length];
                for (int n = 0; n < smastercolnames.length; ++n) {
                    XPropertySet xcolPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xColumnsSupplier.getColumns().getByName(smastercolnames[n]));
                    skeycolumnnames[1][n] = AnyConverter.toString((Object)xcolPropertySet.getPropertyValue("RelatedColumn"));
                }
                return skeycolumnnames;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skeycolumnnames;
    }

    public void openFormDocument(boolean _bReadOnly) {
    }

    public void setCommandComposingAttributes() {
        try {
            this.sCatalogSep = this.xDBMetaData.getCatalogSeparator();
            this.sIdentifierQuote = this.xDBMetaData.getIdentifierQuoteString();
            this.bCommandComposerAttributesalreadyRetrieved = true;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean isCatalogAtStart() {
        if (!this.bCommandComposerAttributesalreadyRetrieved) {
            this.setCommandComposingAttributes();
        }
        return this.bCatalogAtStart;
    }

    public String getCatalogSeparator() {
        if (!this.bCommandComposerAttributesalreadyRetrieved) {
            this.setCommandComposingAttributes();
        }
        return this.sCatalogSep;
    }

    public String getIdentifierQuote() {
        if (!this.bCommandComposerAttributesalreadyRetrieved) {
            this.setCommandComposingAttributes();
        }
        return this.sIdentifierQuote;
    }
}

