/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.Property;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.GlobalTransferCommandArgument;
import com.sun.star.ucb.OpenCommandArgument2;
import com.sun.star.ucb.TransferCommandOperation;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.ucb.XContentIdentifier;
import com.sun.star.ucb.XContentIdentifierFactory;
import com.sun.star.ucb.XContentProvider;
import com.sun.star.ucb.XDynamicResultSet;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.PropertyNames;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCB {
    private final Object ucb;
    private final FileAccess fa;

    public UCB(XMultiServiceFactory xmsf) throws Exception {
        this.ucb = xmsf.createInstanceWithArguments("com.sun.star.ucb.UniversalContentBroker", new Object[0]);
        this.fa = new FileAccess(xmsf);
    }

    public void deleteDirContent(String dir) throws Exception {
        if (!this.fa.exists(dir, true)) {
            return;
        }
        List<String> l = this.listFiles(dir, null);
        for (int i = 0; i < l.size(); ++i) {
            this.delete(FileAccess.connectURLs(dir, l.get(i)));
        }
    }

    public void delete(String filename) throws Exception {
        this.executeCommand(this.getContent(filename), "delete", Boolean.TRUE);
    }

    public void copy(String sourceDir, String targetDir) throws Exception {
        this.copy(sourceDir, targetDir, (Verifier)null);
    }

    public void copy(String sourceDir, String targetDir, Verifier verifier) throws Exception {
        List<String> files = this.listFiles(sourceDir, verifier);
        for (int i = 0; i < files.size(); ++i) {
            this.copy(sourceDir, files.get(i), targetDir);
        }
    }

    public void copy(String sourceDir, String filename, String targetDir, String targetName) throws Exception {
        if (!this.fa.exists(targetDir, true)) {
            this.fa.fileAccess.createFolder(targetDir);
        }
        this.executeCommand(this.ucb, "globalTransfer", this.copyArg(sourceDir, filename, targetDir, targetName));
    }

    @Deprecated
    public void copy(String sourceDir, String filename, String targetDir) throws Exception {
        this.copy(sourceDir, filename, targetDir, PropertyNames.EMPTY_STRING);
    }

    public GlobalTransferCommandArgument copyArg(String sourceDir, String sourceFilename, String targetDir, String targetFilename) {
        GlobalTransferCommandArgument aArg = new GlobalTransferCommandArgument();
        aArg.Operation = TransferCommandOperation.COPY;
        aArg.SourceURL = this.fa.getURL(sourceDir, sourceFilename);
        aArg.TargetURL = targetDir;
        aArg.NewTitle = targetFilename;
        aArg.NameClash = 1;
        return aArg;
    }

    public Object executeCommand(Object xContent, String aCommandName, Object aArgument) throws CommandAbortedException, com.sun.star.uno.Exception {
        XCommandProcessor xCmdProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)xContent);
        Command aCommand = new Command();
        aCommand.Name = aCommandName;
        aCommand.Handle = -1;
        aCommand.Argument = aArgument;
        return xCmdProcessor.execute(aCommand, 0, null);
    }

    public List<String> listFiles(String path, Verifier verifier) throws Exception {
        Object xContent = this.getContent(path);
        OpenCommandArgument2 aArg = new OpenCommandArgument2();
        aArg.Mode = 0;
        aArg.Priority = 32768;
        aArg.Properties = new Property[]{new Property()};
        aArg.Properties[0].Name = PropertyNames.PROPERTY_TITLE;
        aArg.Properties[0].Handle = -1;
        XDynamicResultSet xSet = (XDynamicResultSet)UnoRuntime.queryInterface(XDynamicResultSet.class, (Object)this.executeCommand(xContent, "open", aArg));
        XResultSet xResultSet = xSet.getStaticResultSet();
        ArrayList<String> files = new ArrayList<String>();
        if (xResultSet.first()) {
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)xResultSet);
            do {
                String aTitle;
                if ((aTitle = xRow.getString(1)).length() == 0 && xRow.wasNull()) continue;
                files.add(aTitle);
            } while (xResultSet.next());
        }
        if (verifier != null) {
            for (int i = 0; i < files.size(); ++i) {
                if (verifier.verify(files.get(i))) continue;
                files.remove(i--);
            }
        }
        return files;
    }

    public Object getContentProperty(Object content, String propName, Class<?> type) throws Exception {
        Property[] pv = new Property[]{new Property()};
        pv[0].Name = propName;
        pv[0].Handle = -1;
        Object row = this.executeCommand(content, "getPropertyValues", pv);
        XRow xrow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)row);
        if (type.equals(String.class)) {
            return xrow.getString(1);
        }
        if (type.equals(Boolean.class)) {
            return xrow.getBoolean(1) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type.equals(Integer.class)) {
            return xrow.getInt(1);
        }
        if (type.equals(Short.class)) {
            return xrow.getShort(1);
        }
        return null;
    }

    public Object getContent(String path) throws Exception {
        XContentIdentifier id = ((XContentIdentifierFactory)UnoRuntime.queryInterface(XContentIdentifierFactory.class, (Object)this.ucb)).createContentIdentifier(path);
        return ((XContentProvider)UnoRuntime.queryInterface(XContentProvider.class, (Object)this.ucb)).queryContent(id);
    }

    public static interface Verifier {
        public boolean verify(Object var1);
    }
}

