/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.ui.dialogs.XFilePicker;
import com.sun.star.ui.dialogs.XFilePickerControlAccess;
import com.sun.star.ui.dialogs.XFilterManager;
import com.sun.star.ui.dialogs.XFolderPicker2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XStringSubstitution;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Resource;

public class SystemDialog {
    Object systemDialog;
    XFilePicker xFilePicker;
    XFolderPicker2 xFolderPicker;
    XFilterManager xFilterManager;
    XInitialization xInitialize;
    XExecutableDialog xExecutable;
    XComponent xComponent;
    XFilePickerControlAccess xFilePickerControlAccess;
    XMultiServiceFactory xMSF;
    public XStringSubstitution xStringSubstitution;
    public String sStorePath;

    public SystemDialog(XMultiServiceFactory xMSF, String ServiceName, short type) {
        try {
            this.xMSF = xMSF;
            this.systemDialog = xMSF.createInstance(ServiceName);
            this.xFilePicker = (XFilePicker)UnoRuntime.queryInterface(XFilePicker.class, (Object)this.systemDialog);
            this.xFolderPicker = (XFolderPicker2)UnoRuntime.queryInterface(XFolderPicker2.class, (Object)this.systemDialog);
            this.xFilterManager = (XFilterManager)UnoRuntime.queryInterface(XFilterManager.class, (Object)this.systemDialog);
            this.xInitialize = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)this.systemDialog);
            this.xExecutable = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)this.systemDialog);
            this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.systemDialog);
            this.xFilePickerControlAccess = (XFilePickerControlAccess)UnoRuntime.queryInterface(XFilePickerControlAccess.class, (Object)this.systemDialog);
            this.xStringSubstitution = SystemDialog.createStringSubstitution(xMSF);
            Object[] listAny = new Short[]{type};
            if (this.xInitialize != null) {
                this.xInitialize.initialize(listAny);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    public static SystemDialog createStoreDialog(XMultiServiceFactory xmsf) {
        return new SystemDialog(xmsf, "com.sun.star.ui.dialogs.FilePicker", 10);
    }

    public static SystemDialog createOpenDialog(XMultiServiceFactory xmsf) {
        return new SystemDialog(xmsf, "com.sun.star.ui.dialogs.FilePicker", 0);
    }

    public static SystemDialog createFolderDialog(XMultiServiceFactory xmsf) {
        return new SystemDialog(xmsf, "com.sun.star.ui.dialogs.FolderPicker", 0);
    }

    public static SystemDialog createOfficeFolderDialog(XMultiServiceFactory xmsf) {
        return new SystemDialog(xmsf, "com.sun.star.ui.dialogs.OfficeFolderPicker", 0);
    }

    private String subst(String path) {
        try {
            return this.xStringSubstitution.substituteVariables(path, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return path;
        }
    }

    public String callStoreDialog(String DisplayDirectory, String DefaultName, String sDocuType) {
        String sExtension = DefaultName.substring(DefaultName.length() - 3, DefaultName.length());
        this.addFilterToDialog(sExtension, sDocuType, true);
        return this.callStoreDialog(DisplayDirectory, DefaultName);
    }

    public String callStoreDialog(String displayDir, String defaultName) {
        this.sStorePath = null;
        try {
            this.xFilePickerControlAccess.setValue((short)100, (short)0, (Object)Boolean.TRUE);
            this.xFilePicker.setDefaultName(defaultName);
            this.xFilePicker.setDisplayDirectory(this.subst(displayDir));
            if (this.execute(this.xExecutable)) {
                String[] sPathList = this.xFilePicker.getFiles();
                this.sStorePath = sPathList[0];
            }
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        return this.sStorePath;
    }

    public String callFolderDialog(String title, String description, String displayDir) {
        try {
            this.xFolderPicker.setDisplayDirectory(this.subst(displayDir));
        }
        catch (IllegalArgumentException iae) {
            throw new java.lang.IllegalArgumentException(iae);
        }
        this.xFolderPicker.setTitle(title);
        this.xFolderPicker.setDescription(description);
        if (this.execute((XExecutableDialog)this.xFolderPicker)) {
            return this.xFolderPicker.getDirectory();
        }
        return null;
    }

    private boolean execute(XExecutableDialog execDialog) {
        return execDialog.execute() == 1;
    }

    public String[] callOpenDialog(boolean multiSelect, String displayDirectory) {
        try {
            this.xFilePicker.setMultiSelectionMode(multiSelect);
            this.xFilePicker.setDisplayDirectory(this.subst(displayDirectory));
            if (this.execute(this.xExecutable)) {
                return this.xFilePicker.getFiles();
            }
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void addFilterToDialog(String sExtension, String filterName, boolean setToDefault) {
        try {
            String uiName = this.getFilterUIName(filterName);
            String pattern = "*." + sExtension;
            this.addFilter(uiName, pattern, setToDefault);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void addFilter(String uiName, String pattern, boolean setToDefault) {
        try {
            this.xFilterManager.appendFilter(uiName, pattern);
            if (setToDefault) {
                this.xFilterManager.setCurrentFilter(uiName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getFilterUIName(String filterName) {
        String prodName = Configuration.getProductName(this.xMSF);
        String[][] s = new String[][]{{this.getFilterUIName_(filterName)}};
        s[0][0] = JavaTools.replaceSubString(s[0][0], prodName, "%productname%");
        return s[0][0];
    }

    private String getFilterUIName_(String filterName) {
        try {
            Object oFactory = this.xMSF.createInstance("com.sun.star.document.FilterFactory");
            Object oObject = Helper.getUnoObjectbyName(oFactory, filterName);
            Object oArrayObject = AnyConverter.toArray((Object)oObject);
            for (PropertyValue aValue : (PropertyValue[])oArrayObject) {
                if (aValue == null || !aValue.Name.equals("UIName")) continue;
                return AnyConverter.toString((Object)aValue.Value);
            }
            throw new NullPointerException("UIName property not found for Filter " + filterName);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static int showErrorBox(XMultiServiceFactory xMSF, String ResName, String ResPrefix, int ResID, String AddTag, String AddString) {
        String ProductName = Configuration.getProductName(xMSF);
        Resource oResource = new Resource(xMSF, ResPrefix);
        String sErrorMessage = oResource.getResText(ResID);
        sErrorMessage = JavaTools.replaceSubString(sErrorMessage, ProductName, "%PRODUCTNAME");
        sErrorMessage = JavaTools.replaceSubString(sErrorMessage, String.valueOf('\r'), "<BR>");
        sErrorMessage = JavaTools.replaceSubString(sErrorMessage, AddString, AddTag);
        return SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sErrorMessage);
    }

    public static int showErrorBox(XMultiServiceFactory xMSF, String ResName, String ResPrefix, int ResID) {
        String ProductName = Configuration.getProductName(xMSF);
        Resource oResource = new Resource(xMSF, ResPrefix);
        String sErrorMessage = oResource.getResText(ResID);
        sErrorMessage = JavaTools.replaceSubString(sErrorMessage, ProductName, "%PRODUCTNAME");
        sErrorMessage = JavaTools.replaceSubString(sErrorMessage, String.valueOf('\r'), "<BR>");
        return SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sErrorMessage);
    }

    public static int showMessageBox(XMultiServiceFactory xMSF, String windowServiceName, int windowAttribute, String MessageText) {
        int iMessage = 0;
        try {
            if (MessageText == null) {
                return 0;
            }
            XFrame xFrame = Desktop.getActiveFrame(xMSF);
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xFrame.getComponentWindow());
            return SystemDialog.showMessageBox(xMSF, xWindowPeer, windowServiceName, windowAttribute, MessageText);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return iMessage;
        }
    }

    public static int showMessageBox(XMultiServiceFactory xMSF, XWindowPeer peer, String windowServiceName, int windowAttribute, String MessageText) {
        if (peer == null) {
            return SystemDialog.showMessageBox(xMSF, windowServiceName, windowAttribute, MessageText);
        }
        int iMessage = 0;
        try {
            XInterface xAWTToolkit = (XInterface)xMSF.createInstance("com.sun.star.awt.Toolkit");
            XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xAWTToolkit);
            WindowDescriptor oDescriptor = new WindowDescriptor();
            oDescriptor.WindowServiceName = windowServiceName;
            oDescriptor.Parent = peer;
            oDescriptor.Type = WindowClass.MODALTOP;
            oDescriptor.WindowAttributes = windowAttribute;
            XWindowPeer xMsgPeer = xToolkit.createWindow(oDescriptor);
            XMessageBox xMsgbox = (XMessageBox)UnoRuntime.queryInterface(XMessageBox.class, (Object)xMsgPeer);
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xMsgbox);
            xMsgbox.setMessageText(MessageText);
            iMessage = xMsgbox.execute();
            xComponent.dispose();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return iMessage;
    }

    public static XStringSubstitution createStringSubstitution(XMultiServiceFactory xMSF) {
        Object xPathSubst = null;
        try {
            xPathSubst = xMSF.createInstance("com.sun.star.util.PathSubstitution");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace();
        }
        if (xPathSubst != null) {
            return (XStringSubstitution)UnoRuntime.queryInterface(XStringSubstitution.class, (Object)xPathSubst);
        }
        return null;
    }
}

