/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.wizards.common.DebugHelper;
import com.sun.star.wizards.common.PropertyNames;

public class NumericalHelper {
    public static final int UNKNOWN_TYPE = Short.MIN_VALUE;
    public static final int BYTE_TYPE = 0;
    public static final int SHORT_TYPE = 1;
    public static final int INT_TYPE = 2;
    public static final int LONG_TYPE = 3;
    public static final int FLOAT_TYPE = 4;
    public static final int DOUBLE_TYPE = 5;
    public static final int CHAR_TYPE = 6;
    public static final int STRING_TYPE = -1;
    public static final int BOOLEAN_TYPE = -2;
    public static final int SEQUENCE_TYPE = -3;
    public static final int ASCII_VALUE_0 = 48;
    public static final int ASCII_VALUE_A = 65;
    public static final int COUNT_CHARS_IN_ALPHABET = 26;
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int ASCII_LETTER_A_OFFSET = 55;

    private NumericalHelper() {
    }

    public static int getType(Object obj) {
        try {
            TypeObject aTypeObject = NumericalHelper.getTypeObject(obj);
            return aTypeObject.iType;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Short.MIN_VALUE;
        }
    }

    public static byte toByte(Object aValue) throws IllegalArgumentException {
        int retValue = 0;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = (byte)NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = (byte)NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = (byte)NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = (byte)NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = (byte)NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (byte)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Byte.parseByte((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to byte: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return (byte)retValue;
    }

    public static char toChar(Object aValue) throws IllegalArgumentException {
        int retValue = '\u0000';
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 0: {
                retValue = (char)NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 1: {
                retValue = (char)NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = (char)NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = (char)NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = (char)NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (char)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    String s = (String)aTypeObject.aValue;
                    if (s.length() > 0) {
                        retValue = s.charAt(0);
                        break;
                    }
                    retValue = 0;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to char: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? 65535 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return (char)retValue;
    }

    public static short toShort(Object aValue) throws IllegalArgumentException {
        int retValue = 0;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = (byte)NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = (short)NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = (short)NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = (short)NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (short)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Short.parseShort((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to short: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return (short)retValue;
    }

    public static boolean isValidAndNumerical(Object aValue) throws IllegalArgumentException {
        if (aValue != null && !AnyConverter.isVoid((Object)aValue)) {
            return NumericalHelper.isNumerical(aValue);
        }
        return false;
    }

    public static boolean isValidAndBoolean(Object aValue) throws IllegalArgumentException {
        if (aValue != null && !AnyConverter.isVoid((Object)aValue)) {
            int nType = AnyConverter.getType((Object)aValue).getTypeClass().getValue();
            return nType == 2;
        }
        return false;
    }

    public static boolean isValid(Object aValue) {
        return aValue != null && !AnyConverter.isVoid((Object)aValue);
    }

    public static boolean isNumerical(Object aValue) {
        try {
            TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
            switch (aTypeObject.iType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isRealNumber(Object _aValue) {
        return NumericalHelper.isNumerical(_aValue);
    }

    public static boolean isInteger(Object aValue) throws IllegalArgumentException {
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringArray(Object aValue) {
        try {
            NumericalHelper.toStringArray(aValue);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isIntegerArray(Object aValue) {
        try {
            NumericalHelper.toIntArray(aValue);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static int toInt(Object aValue) throws IllegalArgumentException {
        int retValue = 0;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = (int)NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = (int)NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (int)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Integer.parseInt((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to int: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static long toLong(Object aValue) throws IllegalArgumentException {
        long retValue = 0L;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = (long)NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (long)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Long.parseLong((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to short: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1L : 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static float toFloat(Object aValue) throws IllegalArgumentException {
        float retValue = 0.0f;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (float)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Float.parseFloat((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to short: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1.0f : 0.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static double toDouble(Object aValue) throws IllegalArgumentException {
        double retValue = 0.0;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Float.parseFloat((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to short: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1.0 : 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static String toString(Object aValue) throws IllegalArgumentException {
        String retValue = null;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case -2: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                retValue = aTypeObject.aValue.toString();
                break;
            }
            case -1: {
                retValue = (String)aTypeObject.aValue;
                break;
            }
            case -3: {
                retValue = new String(NumericalHelper.toByteArray(aValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static boolean toBoolean(Object aValue) throws IllegalArgumentException {
        boolean retValue = true;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = (Byte)aTypeObject.aValue != 0;
                break;
            }
            case 6: {
                retValue = ((Character)aTypeObject.aValue).charValue() != '\u0000';
                break;
            }
            case 1: {
                retValue = (Short)aTypeObject.aValue != 0;
                break;
            }
            case 2: {
                retValue = (Integer)aTypeObject.aValue != 0;
                break;
            }
            case 3: {
                retValue = (Long)aTypeObject.aValue != 0L;
                break;
            }
            case 4: {
                retValue = ((Float)aTypeObject.aValue).floatValue() != 0.0f;
                break;
            }
            case 5: {
                retValue = (Double)aTypeObject.aValue != 0.0;
                break;
            }
            case -1: {
                try {
                    retValue = Boolean.parseBoolean((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to short: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = (Boolean)aTypeObject.aValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static int[] toIntArray(Object anArrayValue) throws IllegalArgumentException {
        int[] retValue = null;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(anArrayValue);
        if (aTypeObject.iType == -3) {
            Object[] obj = NumericalHelper.convertSequenceToObjectArray(aTypeObject);
            retValue = new int[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                retValue[i] = NumericalHelper.toInt(obj[i]);
            }
        } else {
            retValue = new int[]{NumericalHelper.toInt(anArrayValue)};
        }
        return retValue;
    }

    public static byte[] toByteArray(Object anArrayValue) throws IllegalArgumentException {
        byte[] retValue = null;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(anArrayValue);
        if (aTypeObject.iType == -3) {
            Object[] obj = NumericalHelper.convertSequenceToObjectArray(aTypeObject);
            retValue = new byte[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                retValue[i] = NumericalHelper.toByte(obj[i]);
            }
        } else {
            retValue = new byte[]{NumericalHelper.toByte(anArrayValue)};
        }
        return retValue;
    }

    public static short[] toShortArray(Object anArrayValue) throws IllegalArgumentException {
        short[] retValue = null;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(anArrayValue);
        if (aTypeObject.iType == -3) {
            Object[] obj = NumericalHelper.convertSequenceToObjectArray(aTypeObject);
            retValue = new short[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                retValue[i] = NumericalHelper.toShort(obj[i]);
            }
        } else {
            retValue = new short[]{NumericalHelper.toShort(anArrayValue)};
        }
        return retValue;
    }

    public static String[] toStringArray(Object anArrayValue) throws IllegalArgumentException {
        String[] retValue = null;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(anArrayValue);
        if (aTypeObject.iType == -3) {
            Object[] obj = NumericalHelper.convertSequenceToObjectArray(aTypeObject);
            retValue = new String[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                retValue[i] = NumericalHelper.toString(obj[i]);
            }
        } else {
            retValue = new String[]{NumericalHelper.toString(anArrayValue)};
        }
        return retValue;
    }

    public static int toInt(Object _aValue, int _ndefaultValue) throws Exception {
        int nreturn = _ndefaultValue;
        try {
            if (_aValue != null && !AnyConverter.isVoid((Object)_aValue)) {
                if (NumericalHelper.isInteger(_aValue)) {
                    nreturn = NumericalHelper.toInt(_aValue);
                } else {
                    DebugHelper.exception(1, PropertyNames.EMPTY_STRING);
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            DebugHelper.exception(1, PropertyNames.EMPTY_STRING);
        }
        return nreturn;
    }

    public static long toLong(Object aValue, long defaultValue) {
        try {
            return NumericalHelper.toLong(aValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static float toFloat(Object aValue, float defaultValue) {
        try {
            return NumericalHelper.toFloat(aValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static double toDouble(Object aValue, double defaultValue) {
        try {
            return NumericalHelper.toDouble(aValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static String toString(Object aValue, String defaultValue) {
        try {
            return NumericalHelper.toString(aValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static boolean toBoolean(Object aValue, boolean defaultValue) {
        try {
            return NumericalHelper.toBoolean(aValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static int[] toIntArray(Object anArrayValue, int[] defaultValue) {
        try {
            return NumericalHelper.toIntArray(anArrayValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static short[] toShortArray(Object anArrayValue, short[] defaultValue) {
        try {
            return NumericalHelper.toShortArray(anArrayValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static String[] toStringArray(Object anArrayValue, String[] defaultValue) {
        try {
            return NumericalHelper.toStringArray(anArrayValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    public static String getHexStringFromNumber(long number) {
        TransformNumToHex num = new TransformNumToHex(number);
        return num.getResult();
    }

    private static TypeObject getTypeObject(Object aValue) throws IllegalArgumentException {
        TypeObject aTypeObject = new TypeObject();
        if (aValue == null || AnyConverter.isVoid((Object)aValue)) {
            throw new IllegalArgumentException("Cannot convert a null object.");
        }
        int type = AnyConverter.getType((Object)aValue).getTypeClass().getValue();
        switch (type) {
            case 1: {
                aTypeObject.iType = 6;
                aTypeObject.aValue = new Character(AnyConverter.toChar((Object)aValue));
                break;
            }
            case 3: {
                aTypeObject.iType = 0;
                aTypeObject.aValue = AnyConverter.toByte((Object)aValue);
                break;
            }
            case 4: {
                aTypeObject.iType = 1;
                aTypeObject.aValue = AnyConverter.toShort((Object)aValue);
                break;
            }
            case 6: {
                aTypeObject.iType = 2;
                aTypeObject.aValue = AnyConverter.toInt((Object)aValue);
                break;
            }
            case 8: {
                aTypeObject.iType = 3;
                aTypeObject.aValue = AnyConverter.toLong((Object)aValue);
                break;
            }
            case 10: {
                aTypeObject.iType = 4;
                aTypeObject.aValue = new Float(AnyConverter.toFloat((Object)aValue));
                break;
            }
            case 11: {
                aTypeObject.iType = 5;
                aTypeObject.aValue = new Double(AnyConverter.toDouble((Object)aValue));
                break;
            }
            case 12: {
                aTypeObject.iType = -1;
                aTypeObject.aValue = AnyConverter.toString((Object)aValue);
                break;
            }
            case 2: {
                aTypeObject.iType = -2;
                aTypeObject.aValue = AnyConverter.toBoolean((Object)aValue);
                break;
            }
            case 20: {
                aTypeObject.iType = -3;
                aTypeObject.aValue = aValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return aTypeObject;
    }

    private static byte getByte(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 0) {
            throw new IllegalArgumentException("Given argument is not a byte type.");
        }
        return (Byte)typeObject.aValue;
    }

    private static char getChar(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 6) {
            throw new IllegalArgumentException("Given argument is not a char type.");
        }
        return ((Character)typeObject.aValue).charValue();
    }

    private static short getShort(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 1) {
            throw new IllegalArgumentException("Given argument is not a short type.");
        }
        return (Short)typeObject.aValue;
    }

    static int getInt(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 2) {
            throw new IllegalArgumentException("Given argument is not an int type.");
        }
        return (Integer)typeObject.aValue;
    }

    static float getFloat(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 4) {
            throw new IllegalArgumentException("Given argument is not a float type.");
        }
        return ((Float)typeObject.aValue).floatValue();
    }

    private static double getDouble(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 5) {
            throw new IllegalArgumentException("Given argument is not a double type.");
        }
        return (Double)typeObject.aValue;
    }

    private static long getLong(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 3) {
            throw new IllegalArgumentException("Given argument is not a long type.");
        }
        return (Long)typeObject.aValue;
    }

    private static boolean getBool(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != -2) {
            throw new IllegalArgumentException("Given argument is not a boolean type.");
        }
        return (Boolean)typeObject.aValue;
    }

    private static Object[] convertSequenceToObjectArray(TypeObject sourceObject) throws IllegalArgumentException {
        Object[] vals;
        Object array = sourceObject.aValue;
        Class<?> c = array.getClass();
        Object[] aShortVal = null;
        if (c.equals(byte[].class)) {
            vals = (byte[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = vals[i];
            }
        } else if (c.equals(short[].class)) {
            vals = (short[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = (short)vals[i];
            }
        } else if (c.equals(int[].class)) {
            vals = (int[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = (int)vals[i];
            }
        } else if (c.equals(long[].class)) {
            vals = (long[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = (long)vals[i];
            }
        } else if (c.equals(float[].class)) {
            vals = (float[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = new Float(vals[i]);
            }
        } else if (c.equals(double[].class)) {
            vals = (double[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = new Double(vals[i]);
            }
        } else if (c.equals(boolean[].class)) {
            vals = (boolean[])array;
            aShortVal = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                aShortVal[i] = vals[i];
            }
        }
        if (aShortVal == null) {
            try {
                aShortVal = (Object[])array;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException((Throwable)e, "Cannot convert unknown type " + array.getClass());
            }
        }
        return aShortVal;
    }

    public static boolean representsIntegerNumber(double _dblvalue) {
        double dblsecvalue = (int)_dblvalue;
        return Double.compare(_dblvalue, dblsecvalue) == 0;
    }

    public static double roundDouble(Double _Dblvalue, int _ndecimals) {
        return NumericalHelper.roundDouble((double)_Dblvalue, _ndecimals);
    }

    public static double roundDouble(double _dblvalue, int _ndecimals) {
        double dblfactor = Math.pow(10.0, _ndecimals);
        return (double)((int)(_dblvalue * dblfactor)) / dblfactor;
    }

    private static class TransformNumToHex {
        private final StringBuffer val = new StringBuffer();

        public TransformNumToHex(long number) {
            this.transform(number);
        }

        private void transform(long number) {
            int index = (int)(number % 16L);
            number /= 16L;
            if (index < 10) {
                this.val.insert(0, index);
            } else {
                this.val.insert(0, (char)(55 + index));
            }
            if (number > 0L) {
                this.transform(number);
            }
        }

        public String getResult() {
            return this.val.toString();
        }
    }

    private static class TypeObject {
        public int iType;
        public Object aValue;

        private TypeObject() {
        }
    }
}

