/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedValueCollection {
    private final HashMap<String, Object> m_values = new HashMap();

    public NamedValueCollection() {
    }

    public NamedValueCollection(PropertyValue[] i_values) {
        for (int i = 0; i < i_values.length; ++i) {
            this.m_values.put(i_values[i].Name, i_values[i].Value);
        }
    }

    public final void put(String i_name, Object i_value) {
        this.m_values.put(i_name, i_value);
    }

    public final <T> T getOrDefault(String i_key, T i_default) {
        if (this.m_values.containsKey(i_key)) {
            Object value = this.m_values.get(i_key);
            try {
                return (T)value;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return i_default;
    }

    public final <T extends XInterface> T queryOrDefault(String i_key, T i_default, Class<T> i_interfaceClass) {
        if (this.m_values.containsKey(i_key)) {
            Object value = this.m_values.get(i_key);
            return (T)((XInterface)UnoRuntime.queryInterface(i_interfaceClass, (Object)value));
        }
        return i_default;
    }

    public final boolean has(String i_key) {
        return this.m_values.containsKey(i_key);
    }

    public final PropertyValue[] getPropertyValues() {
        PropertyValue[] values = new PropertyValue[this.m_values.size()];
        Iterator<Map.Entry<String, Object>> iter = this.m_values.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            values[i++] = new PropertyValue(entry.getKey(), 0, entry.getValue(), PropertyState.DIRECT_VALUE);
        }
        return values;
    }
}

