/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lib.util.UrlToFileMapper;
import com.sun.star.util.DateTime;
import com.sun.star.wizards.common.PropertyNames;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTools {
    public static String[] copyStringArray(String[] FirstArray) {
        if (FirstArray != null) {
            String[] SecondArray = new String[FirstArray.length];
            System.arraycopy(FirstArray, 0, SecondArray, 0, FirstArray.length);
            return SecondArray;
        }
        return null;
    }

    public static Object[] initializeArray(Object[] olist, Object ovalue) {
        for (int i = 0; i < olist.length; ++i) {
            olist[i] = ovalue;
        }
        return olist;
    }

    public static Object[][] initializeMultiDimArray(Object[][] olist, Object[] ovalue) {
        for (int i = 0; i < olist.length; ++i) {
            olist[i] = ovalue;
        }
        return olist;
    }

    public static String[] ArrayOutOfMultiDimArray(String[][] _sMultiDimArray, int _index) {
        String[] sRetArray = null;
        if (_sMultiDimArray != null) {
            sRetArray = new String[_sMultiDimArray.length];
            for (int i = 0; i < _sMultiDimArray.length; ++i) {
                sRetArray[i] = _sMultiDimArray[i][_index];
            }
        }
        return sRetArray;
    }

    public static int[] initializeintArray(int FieldCount, int nValue) {
        int[] LocintArray = new int[FieldCount];
        for (int i = 0; i < LocintArray.length; ++i) {
            LocintArray[i] = nValue;
        }
        return LocintArray;
    }

    public static int[] IntegerTointList(List<Integer> _aIntegerVector) {
        int[] nintValues = null;
        if (_aIntegerVector.size() > 0) {
            int i = 0;
            nintValues = new int[_aIntegerVector.size()];
            for (Integer nIntegerValue : _aIntegerVector) {
                nintValues[i++] = nIntegerValue;
            }
        }
        return nintValues;
    }

    public static boolean[] BooleanTobooleanList(List<Boolean> _aBooleanVector) {
        boolean[] bbooleanValues = null;
        if (_aBooleanVector.size() > 0) {
            int i = 0;
            bbooleanValues = new boolean[_aBooleanVector.size()];
            for (Boolean bBooleanValue : _aBooleanVector) {
                bbooleanValues[i++] = bBooleanValue;
            }
        }
        return bbooleanValues;
    }

    public static String[] multiDimListToArray(String[][] multidimlist) {
        String[] retlist = new String[]{};
        retlist = new String[multidimlist.length];
        for (int i = 0; i < multidimlist.length; ++i) {
            retlist[i] = multidimlist[i][0];
        }
        return retlist;
    }

    public static String getlongestArrayItem(String[] StringArray) {
        String sLongestItem = PropertyNames.EMPTY_STRING;
        int iOldLength = 0;
        for (String str : StringArray) {
            int iCurLength = str.length();
            if (iCurLength <= iOldLength) continue;
            iOldLength = iCurLength;
            sLongestItem = str;
        }
        return sLongestItem;
    }

    public static String ArraytoString(String[] LocArray) {
        StringBuilder ResultString = new StringBuilder(PropertyNames.EMPTY_STRING);
        boolean bActive = false;
        for (String str : LocArray) {
            if (bActive) {
                ResultString.append(PropertyNames.SEMI_COLON);
            } else {
                bActive = true;
            }
            ResultString.append(str);
        }
        return ResultString.toString();
    }

    public static int FieldInList(String[] SearchList, String SearchString) {
        int retvalue = -1;
        for (int i = 0; i < SearchList.length; ++i) {
            if (!SearchList[i].equals(SearchString)) continue;
            retvalue = i;
            break;
        }
        return retvalue;
    }

    public static int FieldInList(String[] SearchList, String SearchString, int StartIndex) {
        int FieldLen = SearchList.length;
        int retvalue = -1;
        if (StartIndex < FieldLen) {
            for (int i = StartIndex; i < FieldLen; ++i) {
                if (!SearchList[i].equals(SearchString)) continue;
                retvalue = i;
                break;
            }
        }
        return retvalue;
    }

    public static int FieldInTable(String[][] SearchList, String SearchString) {
        int retvalue = -1;
        int FieldLen = SearchList.length;
        if (FieldLen > 0) {
            for (int i = 0; i < FieldLen; ++i) {
                if (SearchList[i][0] == null || !SearchList[i][0].equals(SearchString)) continue;
                retvalue = i;
                break;
            }
        }
        return retvalue;
    }

    public static int FieldInIntTable(int[][] SearchList, int SearchValue) {
        int retvalue = -1;
        for (int i = 0; i < SearchList.length; ++i) {
            if (SearchList[i][0] != SearchValue) continue;
            retvalue = i;
            break;
        }
        return retvalue;
    }

    public static int FieldInIntTable(int[] SearchList, int SearchValue, int _startindex) {
        int retvalue = -1;
        for (int i = _startindex; i < SearchList.length; ++i) {
            if (SearchList[i] != SearchValue) continue;
            retvalue = i;
            break;
        }
        return retvalue;
    }

    public static int FieldInIntTable(int[] SearchList, int SearchValue) {
        return JavaTools.FieldInIntTable(SearchList, SearchValue, 0);
    }

    public static int getArraylength(Object[] MyArray) {
        int FieldCount = 0;
        if (MyArray != null) {
            FieldCount = MyArray.length;
        }
        return FieldCount;
    }

    public static String[][] bubblesortList(String[][] SortList) {
        int SortCount = SortList[0].length;
        int DimCount = SortList.length;
        for (int s = 0; s < SortCount; ++s) {
            for (int t = 0; t < SortCount - s - 1; ++t) {
                if (SortList[0][t].compareTo(SortList[0][t + 1]) <= 0) continue;
                for (int k = 0; k < DimCount; ++k) {
                    String DisplayDummy = SortList[k][t];
                    SortList[k][t] = SortList[k][t + 1];
                    SortList[k][t + 1] = DisplayDummy;
                }
            }
        }
        return SortList;
    }

    public static String[] ArrayoutofString(String MainString, String Token) {
        String[] StringArray;
        if (!MainString.equals(PropertyNames.EMPTY_STRING)) {
            int iIndex;
            ArrayList<String> StringVector = new ArrayList<String>();
            do {
                if ((iIndex = MainString.indexOf(Token)) < 0) {
                    StringVector.add(MainString);
                    continue;
                }
                StringVector.add(MainString.substring(0, iIndex));
                MainString = MainString.substring(iIndex + 1, MainString.length());
            } while (iIndex >= 0);
            int FieldCount = StringVector.size();
            StringArray = new String[FieldCount];
            StringVector.toArray(StringArray);
        } else {
            StringArray = new String[]{};
        }
        return StringArray;
    }

    public static String replaceSubString(String MainString, String NewSubString, String OldSubString) {
        try {
            int NewIndex = 0;
            int OldIndex = 0;
            int NewSubLen = NewSubString.length();
            int OldSubLen = OldSubString.length();
            while (NewIndex != -1) {
                NewIndex = MainString.indexOf(OldSubString, OldIndex);
                if (NewIndex == -1) continue;
                MainString = MainString.substring(0, NewIndex) + NewSubString + MainString.substring(NewIndex + OldSubLen);
                OldIndex = NewIndex + NewSubLen;
            }
            return MainString;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String getFilenameOutOfPath(String sPath) {
        String[] Hierarchy = JavaTools.ArrayoutofString(sPath, "/");
        return Hierarchy[Hierarchy.length - 1];
    }

    public static String getFileDescription(String sPath) {
        String sFilename = JavaTools.getFilenameOutOfPath(sPath);
        String[] FilenameList = JavaTools.ArrayoutofString(sFilename, ".");
        StringBuilder FileDescription = new StringBuilder(PropertyNames.EMPTY_STRING);
        for (int i = 0; i < FilenameList.length - 1; ++i) {
            FileDescription.append(FilenameList[i]);
        }
        return FileDescription.toString();
    }

    public static String convertfromURLNotation(String _sURLPath) {
        String sPath = PropertyNames.EMPTY_STRING;
        try {
            URL oJavaURL = new URL(_sURLPath);
            File oFile = UrlToFileMapper.mapUrlToFile((URL)oJavaURL);
            sPath = oFile.getAbsolutePath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
        }
        return sPath;
    }

    public static DateTime getDateTime(long timeMillis) {
        Calendar cal = Calendar.getInstance();
        JavaTools.setTimeInMillis(cal, timeMillis);
        DateTime dt = new DateTime();
        dt.Year = (short)cal.get(1);
        dt.Day = (short)cal.get(5);
        dt.Month = (short)(cal.get(2) + 1);
        dt.Hours = (short)cal.get(10);
        dt.Minutes = (short)cal.get(12);
        dt.Seconds = (short)cal.get(13);
        dt.NanoSeconds = cal.get(14) * 1000000;
        return dt;
    }

    public static long getTimeInMillis(Calendar _calendar) {
        Date dDate = _calendar.getTime();
        return dDate.getTime();
    }

    public static void setTimeInMillis(Calendar _calendar, long _timemillis) {
        Date dDate = new Date();
        dDate.setTime(_timemillis);
        _calendar.setTime(dDate);
    }

    public static long getMillis(DateTime time) {
        Calendar cal = Calendar.getInstance();
        cal.set(time.Year, time.Month, time.Day, time.Hours, time.Minutes, time.Seconds);
        return JavaTools.getTimeInMillis(cal);
    }

    public static String[] removeOutdatedFields(String[] baselist, String[] _complist) {
        String[] retarray = new String[]{};
        if (baselist != null && _complist != null) {
            ArrayList<String> retvector = new ArrayList<String>();
            for (int i = 0; i < baselist.length; ++i) {
                if (JavaTools.FieldInList(_complist, baselist[i]) <= -1) continue;
                retvector.add(baselist[i]);
            }
            retarray = new String[retvector.size()];
            retvector.toArray(retarray);
        }
        return retarray;
    }

    public static String[][] removeOutdatedFields(String[][] baselist, String[] _complist, int _compindex) {
        String[][] retarray = new String[][]{};
        if (baselist != null && _complist != null && baselist.length > 0) {
            ArrayList<String[]> retvector = new ArrayList<String[]>();
            for (int i = 0; i < baselist.length; ++i) {
                String sValue = baselist[i][_compindex];
                if (JavaTools.FieldInList(_complist, sValue) == -1) continue;
                retvector.add(baselist[i]);
            }
            retarray = new String[retvector.size()][2];
            retvector.toArray((T[])retarray);
        }
        return retarray;
    }

    public static String[][] removeOutdatedFields(String[][] baselist, String[] _complist) {
        return JavaTools.removeOutdatedFields(baselist, _complist, 0);
    }

    public static PropertyValue[][] removeOutdatedFields(PropertyValue[][] baselist, String[] _complist) {
        if (baselist != null && _complist != null) {
            ArrayList<PropertyValue[]> firstdimvector = new ArrayList<PropertyValue[]>();
            for (int n = 0; n < baselist.length; ++n) {
                ArrayList<PropertyValue> secdimvector = new ArrayList<PropertyValue>();
                for (int m = 0; m < baselist[n].length; ++m) {
                    if (JavaTools.FieldInList(_complist, baselist[n][m].Name) <= -1) continue;
                    secdimvector.add(baselist[n][m]);
                }
                if (secdimvector.isEmpty()) continue;
                PropertyValue[] internalArray = new PropertyValue[secdimvector.size()];
                secdimvector.toArray(internalArray);
                firstdimvector.add(internalArray);
            }
            PropertyValue[][] retarray = new PropertyValue[firstdimvector.size()][];
            return (PropertyValue[][])firstdimvector.toArray((T[])retarray);
        }
        return new PropertyValue[0][];
    }

    public static int getDuplicateFieldIndex(String[][] _scomplist) {
        int retvalue = -1;
        if (_scomplist.length > 0) {
            int fieldcount = _scomplist[0].length;
            String[] sDescList = new String[fieldcount];
            for (int m = 0; m < fieldcount; ++m) {
                for (int n = 0; n < _scomplist.length; ++n) {
                    if (n == 0) {
                        sDescList[m] = "";
                    }
                    int n2 = m;
                    sDescList[n2] = sDescList[n2] + _scomplist[n][m];
                }
            }
            return JavaTools.getDuplicateFieldIndex(sDescList);
        }
        return retvalue;
    }

    public static int getDuplicateFieldIndex(String[] scomplist) {
        for (int n = 0; n < scomplist.length; ++n) {
            String scurvalue = scomplist[n];
            for (int m = n; m < scomplist.length; ++m) {
                if (m == n || !scurvalue.equals(scomplist[m])) continue;
                return m;
            }
        }
        return -1;
    }

    public static int getDuplicateFieldIndex(String[] _scomplist, String _fieldname) {
        int iduplicate = 0;
        for (int n = 0; n < _scomplist.length; ++n) {
            if (!_scomplist[n].equals(_fieldname) || ++iduplicate != 2) continue;
            return n;
        }
        return -1;
    }

    public static boolean isEqual(PropertyValue firstPropValue, PropertyValue secPropValue) {
        if (!firstPropValue.Name.equals(secPropValue.Name)) {
            return false;
        }
        if (!firstPropValue.Value.equals(secPropValue.Value)) {
            return false;
        }
        return firstPropValue.Handle == secPropValue.Handle;
    }

    public static int[] getDuplicateFieldIndex(PropertyValue[][] ocomplist) {
        for (int n = 0; n < ocomplist.length; ++n) {
            PropertyValue[] ocurValue = ocomplist[n];
            for (int m = n; m < ocurValue.length; ++m) {
                PropertyValue odetValue = ocurValue[m];
                for (int s = 0; s < ocurValue.length; ++s) {
                    if (s == m || !JavaTools.isEqual(odetValue, ocurValue[s])) continue;
                    return new int[]{n, s};
                }
            }
        }
        return new int[]{-1, -1};
    }

    public static String getSuffixNumber(String _sbasestring) {
        char b;
        int suffixcharcount = 0;
        for (int i = _sbasestring.length() - 1; i >= 0 && (b = _sbasestring.charAt(i)) >= '0' && b <= '9'; --i) {
            ++suffixcharcount;
        }
        int istart = _sbasestring.length() - suffixcharcount;
        return _sbasestring.substring(istart, _sbasestring.length());
    }

    public static String[] removefromList(String[] _sbaselist, String[] _sdellist) {
        ArrayList<String> tempbaselist = new ArrayList<String>();
        for (String _sbase : _sbaselist) {
            if (JavaTools.FieldInList(_sdellist, _sbase) != -1) continue;
            tempbaselist.add(_sbase);
        }
        String[] sretlist = new String[tempbaselist.size()];
        tempbaselist.toArray(sretlist);
        return sretlist;
    }

    public static boolean isSame(String sFirstString, String sSecondString) {
        boolean bissame = false;
        if (sFirstString == null) {
            bissame = sSecondString != null ? sSecondString.equals(PropertyNames.EMPTY_STRING) : true;
        } else if (sFirstString.equals(PropertyNames.EMPTY_STRING)) {
            bissame = sSecondString == null;
        } else if (sSecondString != null) {
            bissame = sFirstString.equals(sSecondString);
        }
        return bissame;
    }
}

