/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.Date;
import com.sun.star.util.DateTime;
import com.sun.star.util.XMacroExpander;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertySetHelper;
import java.lang.reflect.Array;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    private static long DAY_IN_MILLIS = 86400000L;

    public static long convertUnoDatetoInteger(Date DateValue) {
        Calendar oCal = Calendar.getInstance();
        oCal.set(DateValue.Year, DateValue.Month, DateValue.Day);
        java.util.Date dTime = oCal.getTime();
        long lTime = dTime.getTime();
        return lTime / 86400000L;
    }

    public static void setUnoPropertyValue(Object oUnoObject, String PropertyName, Object PropertyValue2) {
        try {
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject);
            if (!xPSet.getPropertySetInfo().hasPropertyByName(PropertyName)) {
                throw new IllegalArgumentException("No Such Property: '" + PropertyName + "'");
            }
            xPSet.setPropertyValue(PropertyName, PropertyValue2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static Object getUnoObjectbyName(Object oUnoObject, String ElementName) {
        try {
            XNameAccess xName = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oUnoObject);
            if (xName.hasByName(ElementName)) {
                return xName.getByName(ElementName);
            }
            throw new RuntimeException();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getPropertyValue(PropertyValue[] CurPropertyValue, String PropertyName) {
        int MaxCount = CurPropertyValue.length;
        for (int i = 0; i < MaxCount; ++i) {
            if (CurPropertyValue[i] == null || !CurPropertyValue[i].Name.equals(PropertyName)) continue;
            return CurPropertyValue[i].Value;
        }
        throw new RuntimeException();
    }

    public static Object getUnoPropertyValue(Object oUnoObject, String PropertyName, Class<?> xClass) {
        try {
            if (oUnoObject != null) {
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject);
                Object oObject = xPSet.getPropertyValue(PropertyName);
                if (AnyConverter.isVoid((Object)oObject)) {
                    return null;
                }
                return AnyConverter.toObject((Type)new Type(xClass), (Object)oObject);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getPropertyValuefromAny(Object[] CurPropertyValue, String PropertyName) {
        if (CurPropertyValue != null) {
            int MaxCount = CurPropertyValue.length;
            for (int i = 0; i < MaxCount; ++i) {
                PropertyValue aValue;
                if (CurPropertyValue[i] == null || (aValue = (PropertyValue)CurPropertyValue[i]) == null || !aValue.Name.equals(PropertyName)) continue;
                return aValue.Value;
            }
        }
        return null;
    }

    public static Object getPropertyValuefromAny(Object[] CurPropertyValue, String PropertyName, Class<?> xClass) {
        try {
            if (CurPropertyValue != null) {
                int MaxCount = CurPropertyValue.length;
                for (int i = 0; i < MaxCount; ++i) {
                    PropertyValue aValue;
                    if (CurPropertyValue[i] == null || (aValue = (PropertyValue)CurPropertyValue[i]) == null || !aValue.Name.equals(PropertyName)) continue;
                    return AnyConverter.toObject((Type)new Type(xClass), (Object)aValue.Value);
                }
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static Object getUnoPropertyValue(Object oUnoObject, String PropertyName) {
        try {
            if (oUnoObject != null) {
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject);
                return xPSet.getPropertyValue(PropertyName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static Object getUnoArrayPropertyValue(Object oUnoObject, String PropertyName) {
        try {
            XPropertySet xPSet;
            Object oObject;
            if (oUnoObject != null && AnyConverter.isArray((Object)(oObject = (xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject)).getPropertyValue(PropertyName)))) {
                return Helper.getArrayValue(oObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static Object getUnoStructValue(Object oUnoObject, String PropertyName) {
        try {
            XPropertySet xPSet;
            if (oUnoObject != null && (xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oUnoObject)).getPropertySetInfo().hasPropertyByName(PropertyName)) {
                return xPSet.getPropertyValue(PropertyName);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static void setUnoPropertyValues(Object oUnoObject, String[] PropertyNames2, Object[] PropertyValues) {
        try {
            XMultiPropertySet xMultiPSetLst = (XMultiPropertySet)UnoRuntime.queryInterface(XMultiPropertySet.class, (Object)oUnoObject);
            if (xMultiPSetLst != null) {
                xMultiPSetLst.setPropertyValues(PropertyNames2, PropertyValues);
            } else {
                for (int i = 0; i < PropertyNames2.length; ++i) {
                    Helper.setUnoPropertyValue(oUnoObject, PropertyNames2[i], PropertyValues[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static Object getArrayValue(Object oValue) {
        try {
            Object oPropList = AnyConverter.toArray((Object)oValue);
            int nlen = Array.getLength(oPropList);
            if (nlen == 0) {
                return null;
            }
            return oPropList;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static XComponentContext getComponentContext(XMultiServiceFactory _xMSF) {
        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_xMSF);
        PropertySetHelper aHelper = new PropertySetHelper(xProps);
        Object aDefaultContext = aHelper.getPropertyValueAsObject("DefaultContext");
        return (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)aDefaultContext);
    }

    public static XMacroExpander getMacroExpander(XMultiServiceFactory _xMSF) {
        XComponentContext xComponentContext = Helper.getComponentContext(_xMSF);
        Object aSingleton = xComponentContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander");
        return (XMacroExpander)UnoRuntime.queryInterface(XMacroExpander.class, (Object)aSingleton);
    }

    public static class DateUtils {
        private final long docNullTime;
        private final XNumberFormatter formatter;
        private final XNumberFormatsSupplier formatSupplier;
        private final Calendar calendar;

        public DateUtils(XMultiServiceFactory xmsf, Object document) throws Exception {
            XMultiServiceFactory docMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)document);
            Object defaults = docMSF.createInstance("com.sun.star.text.Defaults");
            Locale l = (Locale)Helper.getUnoStructValue(defaults, "CharLocale");
            java.util.Locale jl = new java.util.Locale(l.Language, l.Country, l.Variant);
            this.calendar = Calendar.getInstance(jl);
            this.formatSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)document);
            XPropertySet formatSettings = this.formatSupplier.getNumberFormatSettings();
            Date date = (Date)Helper.getUnoPropertyValue(formatSettings, "NullDate");
            this.calendar.set(date.Year, date.Month - 1, date.Day);
            this.docNullTime = this.getTimeInMillis();
            this.formatter = NumberFormatter.createNumberFormatter(xmsf, this.formatSupplier);
        }

        public int getFormat(short format) {
            return NumberFormatter.getNumberFormatterKey(this.formatSupplier, format);
        }

        public XNumberFormatter getFormatter() {
            return this.formatter;
        }

        private long getTimeInMillis() {
            java.util.Date dDate = this.calendar.getTime();
            return dDate.getTime();
        }

        public synchronized double getDocumentDateAsDouble(int date) {
            this.calendar.clear();
            this.calendar.set(date / 10000, date % 10000 / 100 - 1, date % 100);
            long date1 = this.getTimeInMillis();
            return (date1 - this.docNullTime) / DAY_IN_MILLIS + 1L;
        }

        public double getDocumentDateAsDouble(DateTime date) {
            return this.getDocumentDateAsDouble(date.Year * 10000 + date.Month * 100 + date.Day);
        }

        public synchronized double getDocumentDateAsDouble(long javaTimeInMillis) {
            this.calendar.clear();
            JavaTools.setTimeInMillis(this.calendar, javaTimeInMillis);
            long date1 = this.getTimeInMillis();
            return (date1 - this.docNullTime) / DAY_IN_MILLIS + 1L;
        }

        public String format(int formatIndex, int date) {
            return this.formatter.convertNumberToString(formatIndex, this.getDocumentDateAsDouble(date));
        }

        public String format(int formatIndex, DateTime date) {
            return this.formatter.convertNumberToString(formatIndex, this.getDocumentDateAsDouble(date));
        }

        public String format(int formatIndex, long javaTimeInMillis) {
            return this.formatter.convertNumberToString(formatIndex, this.getDocumentDateAsDouble(javaTimeInMillis));
        }
    }
}

