/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wizards.common.ConfigNode;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;

public abstract class Configuration {
    public static int getInt(String name, Object parent) throws Exception {
        Object o = Configuration.getNode(name, parent);
        if (AnyConverter.isVoid((Object)o)) {
            return 0;
        }
        return AnyConverter.toInt((Object)o);
    }

    public static short getShort(String name, Object parent) throws Exception {
        Object o = Configuration.getNode(name, parent);
        if (AnyConverter.isVoid((Object)o)) {
            return 0;
        }
        return AnyConverter.toShort((Object)o);
    }

    public static float getFloat(String name, Object parent) throws Exception {
        Object o = Configuration.getNode(name, parent);
        if (AnyConverter.isVoid((Object)o)) {
            return 0.0f;
        }
        return AnyConverter.toFloat((Object)o);
    }

    public static double getDouble(String name, Object parent) throws Exception {
        Object o = Configuration.getNode(name, parent);
        if (AnyConverter.isVoid((Object)o)) {
            return 0.0;
        }
        return AnyConverter.toDouble((Object)o);
    }

    public static String getString(String name, Object parent) throws Exception {
        Object o = Configuration.getNode(name, parent);
        if (AnyConverter.isVoid((Object)o)) {
            return PropertyNames.EMPTY_STRING;
        }
        return (String)o;
    }

    public static boolean getBoolean(String name, Object parent) throws Exception {
        Object o = Configuration.getNode(name, parent);
        if (AnyConverter.isVoid((Object)o)) {
            return false;
        }
        return AnyConverter.toBoolean((Object)o);
    }

    public static Object getNode(String name, Object parent) throws Exception {
        return ((XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)parent)).getByName(name);
    }

    public static void set(int value, String name, Object parent) throws Exception {
        Configuration.set((Object)value, name, parent);
    }

    public static void set(short value, String name, Object parent) throws Exception {
        Configuration.set((Object)value, name, parent);
    }

    public static void set(String value, String name, Object parent) throws Exception {
        Configuration.set((Object)value, name, parent);
    }

    public static void set(boolean value, String name, Object parent) throws Exception {
        if (value) {
            Configuration.set(Boolean.TRUE, name, parent);
        } else {
            Configuration.set(Boolean.FALSE, name, parent);
        }
    }

    public static void set(Object value, String name, Object parent) throws IllegalArgumentException, PropertyVetoException, UnknownPropertyException, WrappedTargetException {
        ((XHierarchicalPropertySet)UnoRuntime.queryInterface(XHierarchicalPropertySet.class, (Object)parent)).setHierarchicalPropertyValue(name, value);
    }

    public static Object getConfigurationNode(String name, Object parent) throws Exception {
        return ((XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)parent)).getByName(name);
    }

    public static Object getConfigurationRoot(XMultiServiceFactory xmsf, String sPath, boolean updateable) throws Exception {
        Object oConfigProvider = xmsf.createInstance("com.sun.star.configuration.ConfigurationProvider");
        XMultiServiceFactory confMsf = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oConfigProvider);
        String sView = updateable ? "com.sun.star.configuration.ConfigurationUpdateAccess" : "com.sun.star.configuration.ConfigurationAccess";
        Object[] args = new Object[updateable ? 2 : 1];
        PropertyValue aPathArgument = new PropertyValue();
        aPathArgument.Name = "nodepath";
        aPathArgument.Value = sPath;
        args[0] = aPathArgument;
        if (updateable) {
            PropertyValue aModeArgument = new PropertyValue();
            aModeArgument.Name = "lazywrite";
            aModeArgument.Value = Boolean.FALSE;
            args[1] = aModeArgument;
        }
        return confMsf.createInstanceWithArguments(sView, args);
    }

    public static String[] getChildrenNames(Object configView) {
        XNameAccess nameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configView);
        return nameAccess.getElementNames();
    }

    public static String getProductName(XMultiServiceFactory xMSF) {
        try {
            Object oProdNameAccess = Configuration.getConfigurationRoot(xMSF, "org.openoffice.Setup/Product", false);
            return (String)Helper.getUnoObjectbyName(oProdNameAccess, "ooName");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String getLocaleString(XMultiServiceFactory xMSF, String root, String key) {
        String sLocale = PropertyNames.EMPTY_STRING;
        try {
            Object oMasterKey = Configuration.getConfigurationRoot(xMSF, root, false);
            sLocale = (String)Helper.getUnoObjectbyName(oMasterKey, key);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (!(sLocale.length() != 0 || key.equals("Locale") && root.equals("org.openoffice.System/L10N/"))) {
            return Configuration.getLocaleString(xMSF, "org.openoffice.System/L10N/", "Locale");
        }
        return sLocale;
    }

    public static Locale getLocale(XMultiServiceFactory xMSF, String root, String key) {
        Locale aLocLocale = new Locale();
        String sLocale = Configuration.getLocaleString(xMSF, root, key);
        String[] sLocaleList = JavaTools.ArrayoutofString(sLocale, "-");
        aLocLocale.Language = sLocaleList[0];
        if (sLocaleList.length > 1) {
            aLocLocale.Country = sLocaleList[1];
        }
        return aLocLocale;
    }

    public static Locale getLocale(XMultiServiceFactory xMSF) {
        return Configuration.getLocale(xMSF, "org.openoffice.Setup/L10N/", "ooSetupSystemLocale");
    }

    public static Locale getUILocale(XMultiServiceFactory xMSF) {
        return Configuration.getLocale(xMSF, "org.openoffice.Setup/L10N/", "ooLocale");
    }

    public static String getLocaleString(XMultiServiceFactory xMSF) {
        return Configuration.getLocaleString(xMSF, "org.openoffice.Setup/L10N/", "ooSetupSystemLocale");
    }

    public static String getUILocaleString(XMultiServiceFactory xMSF) {
        return Configuration.getLocaleString(xMSF, "org.openoffice.Setup/L10N/", "ooLocale");
    }

    public static Object addConfigNode(Object configView, String name) throws WrappedTargetException, ElementExistException, NoSuchElementException, Exception {
        XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)configView);
        if (xNameContainer == null) {
            XNameReplace xNameReplace = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)configView);
            return xNameReplace.getByName(name);
        }
        XSingleServiceFactory xElementFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)configView);
        Object newNode = xElementFactory.createInstance();
        xNameContainer.insertByName(name, newNode);
        return newNode;
    }

    public static void removeNode(Object configView, String name) throws NoSuchElementException, WrappedTargetException {
        XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)configView);
        if (xNameContainer.hasByName(name)) {
            xNameContainer.removeByName(name);
        }
    }

    public static void commit(Object configView) throws WrappedTargetException {
        XChangesBatch xUpdateControl = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)configView);
        xUpdateControl.commitChanges();
    }

    public static void updateConfiguration(XMultiServiceFactory xmsf, String path, String name, ConfigNode node, Object param) throws Exception, ElementExistException, NoSuchElementException, WrappedTargetException {
        Object view = Configuration.getConfigurationRoot(xmsf, path, true);
        Configuration.addConfigNode(path, name);
        node.writeConfiguration(view, param);
        XChangesBatch xUpdateControl = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)view);
        xUpdateControl.commitChanges();
    }

    public static void removeNode(XMultiServiceFactory xmsf, String path, String name) throws Exception, ElementExistException, NoSuchElementException, WrappedTargetException {
        Object view = Configuration.getConfigurationRoot(xmsf, path, true);
        Configuration.removeNode(view, name);
        XChangesBatch xUpdateControl = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)view);
        xUpdateControl.commitChanges();
    }

    public static String[] getNodeDisplayNames(XNameAccess _xNameAccessNode) {
        return Configuration.getNodeChildNames(_xNameAccessNode, PropertyNames.PROPERTY_NAME);
    }

    public static String[] getNodeChildNames(XNameAccess xNameAccessNode, String _schildname) {
        String[] snames = null;
        try {
            snames = xNameAccessNode.getElementNames();
            String[] sdisplaynames = new String[snames.length];
            for (int i = 0; i < snames.length; ++i) {
                Object oContent = Helper.getUnoPropertyValue(xNameAccessNode.getByName(snames[i]), _schildname);
                sdisplaynames[i] = !AnyConverter.isVoid((Object)oContent) ? (String)Helper.getUnoPropertyValue(xNameAccessNode.getByName(snames[i]), _schildname) : snames[i];
            }
            return sdisplaynames;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return snames;
        }
    }

    public static XNameAccess getChildNodebyIndex(XNameAccess _xNameAccess, int _index) {
        try {
            String[] snames = _xNameAccess.getElementNames();
            Object oNode = _xNameAccess.getByName(snames[_index]);
            return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oNode);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static XNameAccess getChildNodebyName(XNameAccess _xNameAccessNode, String _SubNodeName) {
        try {
            if (_xNameAccessNode.hasByName(_SubNodeName)) {
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)_xNameAccessNode.getByName(_SubNodeName));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public static XNameAccess getChildNodebyDisplayName(XNameAccess _xNameAccessNode, String _displayname) {
        return Configuration.getChildNodebyDisplayName(_xNameAccessNode, _displayname, PropertyNames.PROPERTY_NAME);
    }

    public static XNameAccess getChildNodebyDisplayName(XNameAccess _xNameAccessNode, String _displayname, String _nodename) {
        String[] snames = null;
        try {
            snames = _xNameAccessNode.getElementNames();
            for (int i = 0; i < snames.length; ++i) {
                String curdisplayname = (String)Helper.getUnoPropertyValue(_xNameAccessNode.getByName(snames[i]), _nodename);
                if (!curdisplayname.equals(_displayname)) continue;
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)_xNameAccessNode.getByName(snames[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public static XNameAccess getChildNodebyDisplayName(XMultiServiceFactory _xMSF, Locale _aLocale, XNameAccess _xNameAccessNode, String _displayname, String _nodename, int _nmaxcharcount) {
        String[] snames = null;
        try {
            snames = _xNameAccessNode.getElementNames();
            for (int i = 0; i < snames.length; ++i) {
                String curdisplayname = (String)Helper.getUnoPropertyValue(_xNameAccessNode.getByName(snames[i]), _nodename);
                if (_nmaxcharcount > 0 && _nmaxcharcount < curdisplayname.length()) {
                    curdisplayname = curdisplayname.substring(0, _nmaxcharcount);
                }
                if (!(curdisplayname = Desktop.removeSpecialCharacters(_xMSF, _aLocale, curdisplayname)).equals(_displayname)) continue;
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)_xNameAccessNode.getByName(snames[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }
}

