/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.wizards.common.ConfigNode;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Indexable;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.XMLProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSet
implements ConfigNode,
XMLProvider,
ListModel {
    private final Class<?> childClass;
    private final Map<String, Object> childrenMap = new HashMap<String, Object>();
    private final List<Object> childrenList = new ArrayList<Object>();
    public Object root;
    protected boolean noNulls = true;
    private EventListenerList listenerList = null;

    public ConfigSet(Class<?> childType) {
        this.childClass = childType;
    }

    public void add(String name, Object child) {
        this.childrenMap.put(name, child);
        try {
            int i = ((Indexable)child).getIndex();
            int oldSize = this.getSize();
            while (this.getSize() <= i) {
                this.childrenList.add(null);
            }
            this.childrenList.set(i, child);
            if (oldSize > i) {
                oldSize = i;
            }
            this.fireListDataListenerIntervalAdded(oldSize, i);
        }
        catch (ClassCastException cce) {
            this.childrenList.add(child);
            this.fireListDataListenerIntervalAdded(this.getSize() - 1, this.getSize() - 1);
        }
    }

    public void add(int i, Object o) {
        int name = i;
        while (this.getElement(PropertyNames.EMPTY_STRING + name) != null) {
            ++name;
        }
        this.childrenMap.put(PropertyNames.EMPTY_STRING + name, o);
        this.childrenList.add(i, o);
        this.fireListDataListenerIntervalAdded(i, i);
    }

    protected Object createChild() throws InstantiationException, IllegalAccessException {
        return this.childClass.newInstance();
    }

    @Override
    public void writeConfiguration(Object configView, Object param) {
        Object[] names = this.childrenMap.keySet().toArray();
        if (ConfigNode.class.isAssignableFrom(this.childClass)) {
            int i;
            String[] children = Configuration.getChildrenNames(configView);
            for (i = 0; i < children.length; ++i) {
                try {
                    Configuration.removeNode(configView, children[i]);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (i = 0; i < names.length; ++i) {
                try {
                    ConfigNode child = (ConfigNode)this.getElement(names[i]);
                    Object childView = Configuration.addConfigNode(configView, (String)names[i]);
                    child.writeConfiguration(childView, param);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            throw new IllegalArgumentException("Unable to write primitive sets to configuration (not implemented)");
        }
    }

    @Override
    public void readConfiguration(Object configurationView, Object param) {
        block8: {
            String[] names;
            block7: {
                int i;
                names = Configuration.getChildrenNames(configurationView);
                if (!ConfigNode.class.isAssignableFrom(this.childClass)) break block7;
                for (i = 0; i < names.length; ++i) {
                    try {
                        ConfigNode child = (ConfigNode)this.createChild();
                        child.setRoot(this.root);
                        child.readConfiguration(Configuration.getNode(names[i], configurationView), param);
                        this.add(names[i], (Object)child);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (!this.noNulls) break block8;
                for (i = 0; i < this.childrenList.size(); ++i) {
                    if (this.childrenList.get(i) != null) continue;
                    this.childrenList.remove(i--);
                }
                break block8;
            }
            for (int i = 0; i < names.length; ++i) {
                try {
                    Object child = Configuration.getNode(names[i], configurationView);
                    this.add(names[i], child);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void remove(Object obj) {
        Object key = this.getKey(obj);
        this.childrenMap.remove(key);
        int i = this.childrenList.indexOf(obj);
        this.childrenList.remove(obj);
        this.fireListDataListenerIntervalRemoved(i, i);
    }

    public void remove(int i) {
        Object o = this.getElementAt(i);
        this.remove(o);
    }

    public void clear() {
        this.childrenMap.clear();
        this.childrenList.clear();
    }

    public void update(int i) {
        this.fireListDataListenerContentsChanged(i, i);
    }

    @Override
    public Node createDOM(Node parent) {
        Object[] items = this.items();
        for (int i = 0; i < items.length; ++i) {
            Object item = items[i];
            if (!(item instanceof XMLProvider)) continue;
            ((XMLProvider)item).createDOM(parent);
        }
        return parent;
    }

    public Object[] items() {
        return this.childrenList.toArray();
    }

    public Object getKey(Object object) {
        for (Map.Entry<String, Object> me : this.childrenMap.entrySet()) {
            if (me.getValue() != object) continue;
            return me.getKey();
        }
        return null;
    }

    public Object getKey(int i) {
        int c = 0;
        while (i > -1) {
            if (this.getElementAt(c) != null) {
                --i;
            }
            ++c;
        }
        if (c == 0) {
            return null;
        }
        return this.getKey(this.getElementAt(c - 1));
    }

    @Override
    public void setRoot(Object newRoot) {
        this.root = newRoot;
    }

    @Override
    public synchronized void addListDataListener(ListDataListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ListDataListener.class, listener);
    }

    @Override
    public synchronized void removeListDataListener(ListDataListener listener) {
        this.listenerList.remove(ListDataListener.class, listener);
    }

    private void fireListDataListenerIntervalAdded(int i0, int i1) {
        ListDataEvent event = new ListDataEvent(this, 1, i0, i1);
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).intervalAdded(event);
        }
    }

    private void fireListDataListenerIntervalRemoved(int i0, int i1) {
        ListDataEvent event = new ListDataEvent(this, 2, i0, i1);
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).intervalRemoved(event);
        }
    }

    private void fireListDataListenerContentsChanged(int i0, int i1) {
        ListDataEvent event = new ListDataEvent(this, 0, i0, i1);
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).contentsChanged(event);
        }
    }

    public Object getElementAt(int i) {
        return this.childrenList.get(i);
    }

    public Object getElement(Object o) {
        return this.childrenMap.get(o);
    }

    @Override
    public int getSize() {
        return this.childrenList.size();
    }

    public Set<String> keys() {
        return this.childrenMap.keySet();
    }

    public int getIndexOf(Object item) {
        return this.childrenList.indexOf(item);
    }

    public void reindexSet(Object confView, String memberName, String indexPropertyName) throws Exception {
        int i;
        String[] names = Configuration.getChildrenNames(confView);
        ArrayList<Object> v = new ArrayList<Object>(names.length);
        Object member = null;
        int index = 0;
        for (i = 0; i < names.length; ++i) {
            if (names[i].equals(memberName)) continue;
            member = Configuration.getConfigurationNode(names[i], confView);
            index = Configuration.getInt(indexPropertyName, member);
            while (index >= v.size()) {
                v.add(null);
            }
            v.set(index, member);
        }
        index = 1;
        for (i = 0; i < v.size(); ++i) {
            member = v.get(i);
            if (member == null) continue;
            Configuration.set(index++, indexPropertyName, member);
        }
    }

    public void sort(Comparator<Object> comparator) {
        Collections.sort(this.childrenList, comparator);
    }
}

