/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.wizards.common.ConfigNode;
import com.sun.star.wizards.common.Configuration;
import java.lang.reflect.Field;

public class ConfigGroup
implements ConfigNode {
    public Object root;

    public void writeConfiguration(Object configurationView, Object param) {
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().startsWith((String)param)) continue;
            try {
                this.writeField(fields[i], configurationView, (String)param);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error writing field: " + fields[i].getName());
                ex.printStackTrace();
            }
        }
    }

    private void writeField(Field field, Object configView, String prefix) throws Exception {
        String propertyName = field.getName().substring(prefix.length());
        Class<?> fieldType = field.getType();
        if (ConfigNode.class.isAssignableFrom(fieldType)) {
            Object childView = Configuration.addConfigNode(configView, propertyName);
            ConfigNode child = (ConfigNode)field.get(this);
            child.writeConfiguration(childView, prefix);
        } else if (fieldType.isPrimitive()) {
            Configuration.set(this.convertValue(field), propertyName, configView);
        } else if (fieldType.equals(String.class)) {
            Configuration.set(field.get(this), propertyName, configView);
        }
    }

    public Object convertValue(Field field) throws IllegalAccessException {
        if (field.getType().equals(Boolean.TYPE)) {
            return field.getBoolean(this) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (field.getType().equals(Integer.TYPE)) {
            return field.getInt(this);
        }
        if (field.getType().equals(Short.TYPE)) {
            return field.getShort(this);
        }
        if (field.getType().equals(Float.TYPE)) {
            return new Double(field.getFloat(this));
        }
        if (field.getType().equals(Double.TYPE)) {
            return new Double(field.getDouble(this));
        }
        return null;
    }

    public void readConfiguration(Object configurationView, Object param) {
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().startsWith((String)param)) continue;
            try {
                this.readField(fields[i], configurationView, (String)param);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Error reading field: " + fields[i].getName());
                ex.printStackTrace();
            }
        }
    }

    private void readField(Field field, Object configView, String prefix) throws Exception {
        String propertyName = field.getName().substring(prefix.length());
        Class<?> fieldType = field.getType();
        if (ConfigNode.class.isAssignableFrom(fieldType)) {
            ConfigNode child = (ConfigNode)field.get(this);
            child.setRoot(this.root);
            child.readConfiguration(Configuration.getNode(propertyName, configView), prefix);
        } else if (fieldType.isPrimitive()) {
            if (fieldType.equals(Boolean.TYPE)) {
                field.setBoolean(this, Configuration.getBoolean(propertyName, configView));
            } else if (fieldType.equals(Integer.TYPE)) {
                field.setInt(this, Configuration.getInt(propertyName, configView));
            } else if (fieldType.equals(Short.TYPE)) {
                field.setShort(this, Configuration.getShort(propertyName, configView));
            } else if (fieldType.equals(Float.TYPE)) {
                field.setFloat(this, Configuration.getFloat(propertyName, configView));
            } else if (fieldType.equals(Double.TYPE)) {
                field.setDouble(this, Configuration.getDouble(propertyName, configView));
            }
        } else if (fieldType.equals(String.class)) {
            field.set(this, Configuration.getString(propertyName, configView));
        }
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
    }
}

