/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.deployment.ExtensionRemovedException;
import com.sun.star.deployment.XPackage;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XTruncate;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.framework.container.DeployedUnoPackagesDB;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ParsedScriptUri;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.io.XInputStreamWrapper;
import com.sun.star.script.framework.io.XOutputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class UnoPkgContainer
extends ParcelContainer {
    private final Map<String, ParcelContainer> registeredPackages = new HashMap<String, ParcelContainer>();
    private final String extensionDb;
    private final String extensionRepository;

    public UnoPkgContainer(XComponentContext xCtx, String locationURL, String _extensionDb, String _extensionRepository, String language) throws IllegalArgumentException, WrappedTargetException {
        super(xCtx, locationURL, language, false);
        this.extensionDb = _extensionDb;
        this.extensionRepository = _extensionRepository;
        this.init();
    }

    public ParcelContainer getRegisteredUnoPkgContainer(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        LogUtils.DEBUG("** getRegisterPackage ctx = " + this.containerUrl);
        LogUtils.DEBUG("** getRegisterPackage  for uri " + url);
        LogUtils.DEBUG("** getRegisterPackage  for langugage " + this.language);
        ParcelContainer result = this.registeredPackages.get(url);
        LogUtils.DEBUG("getRegisterPackage result is  " + result);
        return result;
    }

    public boolean hasRegisteredUnoPkgContainer(String url) {
        return this.getRegisteredUnoPkgContainer(url) != null;
    }

    private void registerPackageContainer(String url, ParcelContainer c) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        LogUtils.DEBUG("RegisterPackage ctx = " + this.containerUrl);
        LogUtils.DEBUG("RegisterPackage language = " + this.language);
        LogUtils.DEBUG("RegisterPackage " + c + " for url " + url);
        this.registeredPackages.put(url, c);
    }

    public void deRegisterPackageContainer(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        LogUtils.DEBUG("In deRegisterPackageContainer for " + url);
        if (this.hasRegisteredUnoPkgContainer(url)) {
            try {
                DeployedUnoPackagesDB db = this.getUnoPackagesDB();
                if (db != null && db.removePackage(this.language, url)) {
                    this.writeUnoPackageDB(db);
                    ParcelContainer container = this.registeredPackages.get(url);
                    if (!container.hasElements() && container.parent() != null) {
                        container.parent().removeChildContainer(container);
                    }
                    this.registeredPackages.remove(url);
                }
            }
            catch (Exception e) {
                LogUtils.DEBUG("***** deRegisterPackageContainer() got exception " + e);
            }
        }
        LogUtils.DEBUG("Leaving deRegisterPackageContainer for " + url);
    }

    private void init() throws IllegalArgumentException {
        LogUtils.DEBUG("getting container for  " + this.containerUrl);
        try {
            DeployedUnoPackagesDB db = this.getUnoPackagesDB();
            if (db != null) {
                String[] packages;
                for (String thepackage : packages = db.getDeployedPackages(this.language)) {
                    try {
                        this.processUnoPackage(thepackage, this.language);
                    }
                    catch (IllegalArgumentException ila) {
                        LogUtils.DEBUG("Failed to process " + thepackage + " for " + this.language);
                        LogUtils.DEBUG("   Reason: " + (Object)((Object)ila));
                    }
                    catch (Exception e) {
                        LogUtils.DEBUG("Something very wrong!!!!!");
                        LogUtils.DEBUG("Failed to process " + thepackage + " for " + this.language);
                        LogUtils.DEBUG("   Reason: " + e);
                    }
                }
            }
        }
        catch (WrappedTargetException e) {
            LogUtils.DEBUG("No deployed uno-packages for " + this.containerUrl);
        }
    }

    public ScriptMetaData findScript(ParsedScriptUri psu) throws NoSuchElementException, WrappedTargetException {
        Object scriptData = null;
        String functionName = psu.function;
        String parcelName = psu.parcel;
        String location = psu.location;
        LogUtils.DEBUG("*** UnoPkgContainer.findScript() ***\ncontainerUrl = " + this.containerUrl + "\nfunction = " + functionName + "\nlocation = " + location + "\nparcel = " + parcelName);
        ParcelContainer pc = this.getChildContainer(location);
        if (pc == null) {
            throw new WrappedTargetException("Failed to resolve script ", null, (Object)new IllegalArgumentException("Cannot resolve script location for script = " + functionName));
        }
        return pc.findScript(psu);
    }

    private DeployedUnoPackagesDB getUnoPackagesDB() throws WrappedTargetException {
        InputStream is = null;
        DeployedUnoPackagesDB dp = null;
        try {
            String packagesUrl = PathUtils.make_url(this.extensionDb, "/Scripts/" + this.extensionRepository + "-extension-desc.xml");
            LogUtils.DEBUG("getUnoPackagesDB() looking for existing db in " + packagesUrl);
            if (m_xSFA.exists(packagesUrl)) {
                if (packagesUrl.startsWith("vnd.sun.star.tdoc")) {
                    throw new WrappedTargetException("Can't handle documents yet");
                }
                is = new XInputStreamWrapper(m_xSFA.openFileRead(packagesUrl));
                dp = new DeployedUnoPackagesDB(is);
                try {
                    is.close();
                    is = null;
                }
                catch (Exception exception) {}
            } else {
                LogUtils.DEBUG("getUnoPackagesDB() " + packagesUrl + " does not exist");
            }
        }
        catch (Exception e) {
            LogUtils.DEBUG("getUnoPackagesDB() caught Exception: " + e);
            LogUtils.DEBUG(LogUtils.getTrace(e));
            throw new WrappedTargetException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (Exception exception) {}
            }
        }
        return dp;
    }

    private void writeUnoPackageDB(DeployedUnoPackagesDB dp) throws IllegalArgumentException, WrappedTargetException {
        LogUtils.DEBUG("In writeUnoPackageDB() ");
        XOutputStream xos = null;
        OutputStream os = null;
        try {
            String packagesUrl = PathUtils.make_url(this.extensionDb, "/Scripts/" + this.extensionRepository + "-extension-desc.xml");
            xos = m_xSFA.openFileWrite(packagesUrl);
            XTruncate xTrc = (XTruncate)UnoRuntime.queryInterface(XTruncate.class, (Object)xos);
            if (xTrc != null) {
                LogUtils.DEBUG("In writeUnoPackageDB() Truncating....");
                xTrc.truncate();
            } else {
                LogUtils.DEBUG("In writeUnoPackageDB() CAN'T Truncate....");
            }
            os = new XOutputStreamWrapper(xos);
            dp.write(os);
            try {
                os.close();
                os = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            LogUtils.DEBUG("In writeUnoPackageDB() Exception: " + e);
            throw new WrappedTargetException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                    os = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void processUnoPackage(XPackage dPackage, String language) throws IllegalArgumentException, WrappedTargetException, ElementExistException {
        LogUtils.DEBUG("** in processUnoPackage ");
        String uri = dPackage.getURL();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        LogUtils.DEBUG("** processUnoPackage getURL() -> " + uri);
        LogUtils.DEBUG("** processUnoPackage getName() -> " + dPackage.getName());
        LogUtils.DEBUG("** processUnoPackage getMediaType() -> " + dPackage.getPackageType().getMediaType());
        try {
            LogUtils.DEBUG("** processUnoPackage getDisplayName() -> " + dPackage.getDisplayName());
        }
        catch (ExtensionRemovedException e) {
            throw new WrappedTargetException(e.getMessage(), (Object)this, (Object)e);
        }
        this.processUnoPackage(uri, language);
        DeployedUnoPackagesDB db = this.getUnoPackagesDB();
        if (db == null) {
            try {
                db = new DeployedUnoPackagesDB();
            }
            catch (IOException ioe) {
                throw new WrappedTargetException((Throwable)ioe);
            }
        }
        db.addPackage(language, uri);
        this.writeUnoPackageDB(db);
    }

    private void processUnoPackage(String uri, String language) throws IllegalArgumentException, WrappedTargetException, ElementExistException {
        if (this.hasRegisteredUnoPkgContainer(uri)) {
            throw new ElementExistException("Already a registered uno package " + uri + " for language " + language);
        }
        LogUtils.DEBUG("processUnoPackage - URL = " + uri);
        LogUtils.DEBUG("processUnoPackage - script library package");
        String parentUrl = uri;
        if (uri.contains("%2Funo_packages%2F") || uri.contains("/uno_packages/") || uri.contains("$UNO_USER_PACKAGES_CACHE/") || uri.contains("$UNO_SHARED_PACKAGES_CACHE/") || uri.contains("$BUNDLED_EXTENSIONS/")) {
            ParcelContainer pkgContainer;
            LogUtils.DEBUG("processUnoPackage - is part of a uno bundle");
            int index = uri.lastIndexOf(47);
            if (uri.endsWith("/")) {
                uri = uri.substring(0, index);
                index = uri.lastIndexOf(47);
            }
            if (index > -1) {
                parentUrl = uri.substring(0, index);
                LogUtils.DEBUG("processUnoPackage - composition is contained in " + parentUrl);
            }
            if ((pkgContainer = this.getChildContainerForURL(parentUrl)) == null) {
                pkgContainer = new ParcelContainer(this, this.m_xCtx, parentUrl, language, false);
                if (pkgContainer.loadParcel(uri) == null) {
                    throw new IllegalArgumentException("Couldn't load script library from composition package " + uri + " for language " + language);
                }
                this.addChildContainer(pkgContainer);
            } else if (pkgContainer.loadParcel(uri) == null) {
                throw new IllegalArgumentException("Couldn't load script library from composition package " + uri + " for language " + language);
            }
            this.registerPackageContainer(uri, pkgContainer);
        } else {
            if (this.loadParcel(uri) == null) {
                throw new IllegalArgumentException("Couldn't load script library package " + uri + " for language " + language);
            }
            this.registerPackageContainer(uri, this);
        }
    }
}

